/**
 * Initializes and manages H5P elements within a Moodle environment.
 *
 * This module defines functions to handle user interactions with H5P content,
 * capturing xAPI events, and storing user responses. It listens for specific
 * xAPI verbs such as 'answered', 'completed', and 'interacted' to determine
 * when to store user responses. The module also handles the removal of warning
 * messages and refreshes content elements upon successful data storage.
 *
 * @module cdelement_h5p/h5p
 * @copyright  2024 bdecent gmbh <https://bdecent.de>
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("cdelement_h5p/h5p",["jquery","mod_contentdesigner/elements","core/ajax","core/notification"],(function($,Elements,AJAX,Notification){var interactedInstances=[];const elementH5P=instance=>{document.querySelector('.h5p-element-instance[data-instanceid="'+instance+'"]').querySelector(".h5p-iframe").onload=()=>h5pExternal(instance)},h5pExternal=instance=>{var iframe=document.querySelector('.h5p-element-instance[data-instanceid="'+instance+'"]').querySelector(".h5p-iframe");if(null!=iframe.contentWindow.H5P){var h5p=iframe.contentWindow.H5P;void 0!==h5p.externalDispatcher?h5p.externalDispatcher.on("xAPI",(function(event){if(event&&event.data&&event.data.statement){var statement=event.data.statement;if(statement.verb&&statement.verb.id){var extensionID,isCompleted="http://adlnet.gov/expapi/verbs/answered"===statement.verb.id||"http://adlnet.gov/expapi/verbs/completed"===statement.verb.id,isChild=statement.context&&statement.context.contextActivities&&statement.context.contextActivities.parent&&statement.context.contextActivities.parent[0]&&statement.context.contextActivities.parent[0].id,isInteracted=!1,isResponsed=!1;if("http://adlnet.gov/expapi/verbs/interacted"===statement.verb.id)try{extensionID=statement.object.definition.extensions["http://h5p.org/x-api/h5p-local-content-id"],interactedInstances[extensionID]=!0}catch(err){Notification.alert(err)}else{try{var _interactedInstances$;extensionID=statement.object.definition.extensions["http://h5p.org/x-api/h5p-local-content-id"],isInteracted=null!==(_interactedInstances$=interactedInstances[extensionID])&&void 0!==_interactedInstances$&&_interactedInstances$}catch(err){Notification.alert(err)}if(void 0!==statement.result){if(void 0!==statement.result.response){for(var _statement$result$sco,max=null!==(_statement$result$sco=statement.result.score.max)&&void 0!==_statement$result$sco?_statement$result$sco:0,response=statement.result.response,i=1;i<=max;i++)response=response.replace("[,]","");isResponsed=""!=response}else isResponsed=!0;var isPassed=statement.result.score.max<1||statement.result.score.max==statement.result.score.raw||void 0!==statement.result.success&&1==statement.result.success;if(isCompleted&&!isChild&&isResponsed&&isInteracted&&isPassed){var promises=storeUserResponse(statement,instance);if(!promises)return;promises[0].then((response=>{response&&(removeWarning(),Elements.refreshContent())})).catch(Notification.exception)}}}}}})):setTimeout((()=>elementH5P(instance)),200)}else setTimeout((()=>elementH5P(instance)),200)},removeWarning=()=>{null!==Elements.courseContent().querySelector(".label.label-warning")&&Elements.courseContent().querySelector(".label.label-warning").remove()},storeUserResponse=(statement,instance)=>{var _statement$result$com,_statement$result$suc,_statement$result$dur,_statement$result$res,_statement$result$sco2,_statement$result$sco3,_statement$result$sco4,_statement$result$sco5,params={cmid:Elements.contentDesignerData().cmid,instanceid:instance,result:{completion:null!==(_statement$result$com=statement.result.completion)&&void 0!==_statement$result$com?_statement$result$com:0,success:null!==(_statement$result$suc=statement.result.success)&&void 0!==_statement$result$suc?_statement$result$suc:0,duration:null!==(_statement$result$dur=statement.result.duration)&&void 0!==_statement$result$dur?_statement$result$dur:"",response:null!==(_statement$result$res=statement.result.response)&&void 0!==_statement$result$res?_statement$result$res:"",score:{min:null!==(_statement$result$sco2=statement.result.score.min)&&void 0!==_statement$result$sco2?_statement$result$sco2:0,max:null!==(_statement$result$sco3=statement.result.score.max)&&void 0!==_statement$result$sco3?_statement$result$sco3:0,raw:null!==(_statement$result$sco4=statement.result.score.raw)&&void 0!==_statement$result$sco4?_statement$result$sco4:0,scaled:null!==(_statement$result$sco5=statement.result.score.scaled)&&void 0!==_statement$result$sco5?_statement$result$sco5:0}}};return AJAX.call([{methodname:"cdelement_h5p_store_result",args:params}])};return{init:function(instance){elementH5P(instance)}}}));

//# sourceMappingURL=h5p.min.js.map