define("videotimeplugin_live/videotime",["exports","core/ajax","core/config","mod_videotime/videotime","block_deft/janus-gateway","core/log","core/notification","block_deft/publish","block_deft/subscribe","videotimeplugin_live/socket"],(function(_exports,_ajax,_config,_videotime,_janusGateway,_log,_notification,_publish,_subscribe,_socket){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * Video time player specific js
   *
   * @package    videotimeplugin_live
   * @module     videotimeplugin_live/videotime
   * @copyright  2022 bdecent gmbh <https://bdecent.de>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_config=_interopRequireDefault(_config),_videotime=_interopRequireDefault(_videotime),_janusGateway=_interopRequireDefault(_janusGateway),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification),_publish=_interopRequireDefault(_publish),_subscribe=_interopRequireDefault(_subscribe),_socket=_interopRequireDefault(_socket);var wstoken,rooms={};class Publish extends _publish.default{async register(pluginHandle){try{const response=await _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.contextid),plugin:pluginHandle.plugin,room:this.roomid,ptype:"publish"==this.ptype,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"videotimeplugin_live_join_room"}])[0];return this.feed=response.id,response}catch(e){_notification.default.exception(e)}return null}publishFeed(){return _ajax.default.call([{args:{id:Number(this.feed),room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"videotimeplugin_live_publish_feed"}])[0]}unpublish(){return document.querySelectorAll("#video-controls-camera, #video-controls-display").forEach((video=>{video.srcObject=null,video.parentNode.classList.add("hidden")})),_ajax.default.call([{args:{id:Number(this.feed),publish:!1,room:this.roomid},contextid:this.contextid,fail:_notification.default.exception,methodname:"videotimeplugin_live_publish_feed"}])[0]}handleClose(){document.querySelectorAll('[data-contextid="'+this.contextid+'"][data-action="publish"]').forEach((button=>{button.classList.remove("hidden")})),this.janus.destroy(),[this.currentCamera||null,this.currentDisplay||null].forEach((async videoInput=>{if(!videoInput)return;const videoStream=await videoInput;videoStream&&videoStream.getTracks().forEach((track=>{track.enabled=!1,track.stop()}))}))}async onLocalTrack(track,on){if("audio"!=track.kind){if(on){const remoteStream=new MediaStream([track]);return remoteStream.mid=track.mid,void _janusGateway.default.attachMediaStream(document.getElementById("video-controls-"+this.tracks[track.id]),remoteStream)}if(this.currentCamera){const videoStream=await this.currentCamera;videoStream&&videoStream.getTracks().forEach((current=>{current.id==track.id&&(this.currentCamera=null,document.getElementById("video-controls-"+this.tracks[track.id]).parentNode.classList.add("hidden"))}))}if(this.currentDisplay){const videoStream=await this.currentDisplay;videoStream&&videoStream.getTracks().forEach((current=>{current.id==track.id&&(this.currentDisplay=null,document.getElementById("video-controls-"+this.tracks[track.id]).parentNode.classList.add("hidden"))}))}}}handleClick(e){const button=e.target.closest('[data-contextid="'+this.contextid+'"][data-action="publish"], [data-contextid="'+this.contextid+'"][data-action="close"], [data-contextid="'+this.contextid+'"][data-action="mute"], [data-contextid="'+this.contextid+'"][data-action="unmute"], [data-contextid="'+this.contextid+'"][data-action="switch"], [data-contextid="'+this.contextid+'"][data-action="unpublish"]');if(button){const action=button.getAttribute("data-action"),type=button.getAttribute("data-type")||"camera";switch(e.stopPropagation(),e.preventDefault(),document.querySelectorAll('[data-region="deft-venue"] [data-action="publish"], [data-region="deft-venue"] [data-action="unpublish"]').forEach((button=>{button.getAttribute("data-action")==action&&button.getAttribute("data-type")==type||button.classList.remove("hidden")})),action){case"close":document.getElementById("video-controls-"+type).srcObject=null,document.getElementById("video-controls-"+type).parentNode.classList.add("hidden"),this.tracks[this.selectedTrack.id]==type&&this.unpublish();break;case"mute":case"unmute":this.muteAudio("mute"==action,type);break;case"publish":this.videoInput="display"==type?this.shareDisplay():this.shareCamera(),document.querySelectorAll("#video-controls-camera, #video-controls-display").forEach((video=>{video.parentNode.classList.remove("selected")})),document.getElementById("video-controls-"+type).parentNode.classList.remove("hidden"),document.getElementById("video-controls-"+type).parentNode.classList.add("selected"),this.processStream([]);break;case"switch":document.querySelectorAll("#video-controls-camera, #video-controls-display").forEach((video=>{video.parentNode.classList.remove("selected")})),this.videoInput="display"==type?this.currentDisplay:this.currentCamera,document.getElementById("video-controls-"+type).parentNode.classList.remove("hidden"),document.getElementById("video-controls-"+type).parentNode.classList.add("selected"),this.processStream([]);break;case"unpublish":this.unpublish()}}return!0}async muteAudio(mute,type){try{const videoStream=await("display"==type?this.currentDisplay:this.currentCamera);return videoStream&&videoStream.getAudioTracks().forEach((track=>{track.enabled=!mute})),videoStream}catch(e){_notification.default.exception(e)}return null}async shareCamera(){const videoInput=this.videoInput,currentCamera=this.currentCamera;if(currentCamera){const videoStream=await currentCamera;if(videoStream)return videoStream}try{this.currentCamera=navigator.mediaDevices.getUserMedia({video:!0,audio:!0});const videoStream=await this.currentCamera;return this.tracks=this.tracks||{},videoStream.getTracks().forEach((track=>{this.tracks[track.id]="camera"})),videoStream}catch(e){_log.default.debug(e)}return videoInput}async shareDisplay(){const videoInput=this.videoInput,currentDisplay=this.currentDisplay||null,displayInput=navigator.mediaDevices.getDisplayMedia({video:!0,audio:!0});this.videoInput=displayInput;try{const videoStream=await displayInput;if(this.tracks=this.tracks||{},videoStream.getTracks().forEach((track=>{this.tracks[track.id]="display"})),this.currentDisplay=displayInput,currentDisplay){const videoStream=await currentDisplay;videoStream&&videoStream.getTracks().forEach((track=>{track.stop()}))}return videoStream}catch(e){return _log.default.debug(e),videoInput}}async processStream(tracks){try{const videoStream=await this.videoInput;if(this.tracks=this.tracks||{},videoStream){const audiotransceiver=this.getTransceiver("audio"),videotransceiver=this.getTransceiver("video");if(videoStream.getVideoTracks().forEach((track=>{track.addEventListener("ended",(()=>{this.selectedTrack.id==track.id?this.unpublish():document.getElementById("video-controls-"+this.tracks[track.id]).parentNode.classList.add("hidden")})),this.selectedTrack=track,videotransceiver?this.videoroom.replaceTracks({tracks:[{type:"video",mid:videotransceiver.mid,capture:track}],error:_notification.default.exception}):tracks.push({type:"video",capture:track,recv:!1})})),videoStream.getAudioTracks().forEach((track=>{document.querySelector('.hidden[data-action="mute"][data-contextid="'+this.contextid+'"][data-type="'+this.tracks[this.selectedTrack.id]+'"]')&&(track.enabled=!1),audiotransceiver?this.videoroom.replaceTracks({tracks:[{type:"audio",mid:audiotransceiver.mid,capture:track}],error:_notification.default.exception}):tracks.push({type:"audio",capture:track,recv:!1})})),!tracks.length)return videoStream;this.videoroom.createOffer({tracks:tracks,success:jsep=>{this.videoroom.send({message:{request:"configure",video:!0,audio:!0},jsep:jsep})},error:function(error){_notification.default.alert("WebRTC error... ",error.message)}})}}catch(e){_notification.default.exception(e)}return!0}}class VideoTime extends _videotime.default{async initialize(contextid,token,peerid){_log.default.debug("Initializing Video Time "+this.elementId),this.contextid=contextid,this.plugins=[],this.peerid=peerid,this.instance.token&&(wstoken=this.instance.token);try{const response=await this.getRoom(),socket=new _socket.default(contextid,token);this.iceservers=JSON.parse(response.iceservers),this.roomid=response.roomid,this.server=response.server,rooms[String(contextid)]={contextid:contextid,peerid:peerid,roomid:response.roomid,server:response.server,iceServers:JSON.parse(response.iceservers)},this.roomid=response.roomid,document.querySelectorAll('[data-contextid="'+this.contextid+'"] .videotime-control').forEach((control=>{control.classList.remove("hidden")})),socket.subscribe((async()=>{try{const response=await this.getFeed(),room=rooms[String(contextid)];room.publish&&room.publish.restart&&(response.feed==peerid&&this.unpublish(),room.publish=null),this.subscribeTo(Number(response.feed))}catch(e){_notification.default.exception(e)}}))}catch(e){_notification.default.exception(e)}return this.addListeners(),!0}async getRoom(){if(wstoken){const url=new URL(_config.default.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;data.set("wstoken",wstoken),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_live_get_room"),data.set("contextid",this.contextid);try{const response=await fetch(url);return response.ok||_notification.default.exeption("Web service error"),await response.json()}catch(e){_notification.default.exception(e)}}return await _ajax.default.call([{methodname:"videotimeplugin_live_get_room",args:{contextid:this.contextid},fail:_notification.default.exception}])[0]}async getFeed(){if(wstoken){const url=new URL(_config.default.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;data.set("wstoken",wstoken),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_live_get_feed"),data.set("contextid",this.contextid);try{const response=fetch(url);return response.ok||_notification.default.exeption("Web service error"),await response.json()}catch(e){_notification.default.exception(e)}}return await _ajax.default.call([{methodname:"videotimeplugin_live_get_feed",args:{contextid:this.contextid},fail:_notification.default.exception}])[0]}getPlayer(){return document.getElementById(this.elementId)}addListeners(){const player=this.getPlayer();document.querySelector("body").removeEventListener("click",handleClick),document.querySelector("body").addEventListener("click",handleClick),player?(player.addEventListener("play",(()=>(this.hasPro&&this.startWatchInterval(),this.view(),!0))),this.hasPro&&(player.addEventListener("play",function(){this.playing=!0,_log.default.debug("VIDEO_TIME play")}.bind(this)),player.addEventListener("playing",function(){this.playing=!0,_log.default.debug("VIDEO_TIME playing")}.bind(this)),player.addEventListener("pause",function(){this.playing=!1,_log.default.debug("VIDEO_TIME pause")}.bind(this)),player.addEventListener("stalled",function(){this.playing=!1,_log.default.debug("VIDEO_TIME stalled")}.bind(this)),player.addEventListener("suspend",function(){this.playing=!1,_log.default.debug("VIDEO_TIME suspend")}.bind(this)),player.addEventListener("abort",function(){this.playing=!1,_log.default.debug("VIDEO_TIME abort")}.bind(this)),player.addEventListener("ended",this.handleEnd.bind(this)),player.addEventListener("pause",this.handlePause.bind(this)))):_log.default.debug("Player was not properly initialized for course module "+this.cmId)}subscribeTo(source){const room=rooms[String(this.contextid)];document.querySelectorAll('[data-contextid="'+this.contextid+'"][data-action="publish"]').forEach((button=>{Number(this.peerid),button.classList.remove("hidden")})),document.querySelectorAll('[data-contextid="'+this.contextid+'"][data-action="unpublish"]').forEach((button=>{Number(this.peerid),button.classList.remove("hidden")})),!this.remoteFeed||this.remoteFeed.creatingSubscription||this.remoteFeed.restart?this.remoteFeed&&this.remoteFeed.restart?this.remoteFeed.current!=source&&(this.remoteFeed=null,this.subscribeTo(source)):this.remoteFeed?setTimeout((()=>{this.subscribeTo(source)}),500):source&&(this.remoteFeed=new Subscribe(this.contextid,this.iceservers,this.roomid,this.server,this.peerid),this.remoteFeed.remoteVideo=document.getElementById(this.elementId),this.remoteFeed.remoteAudio=document.getElementById(this.elementId).parentNode.querySelector("audio"),this.remoteFeed.muteAudio=room.publish&&room.publish.feed===source,this.remoteFeed.startConnection(source),document.querySelectorAll('[data-contextid="'+this.contextid+'"] img.poster-img').forEach((img=>{img.classList.add("hidden")})),document.querySelectorAll('[data-contextid="'+this.contextid+'"] video').forEach((img=>{img.classList.remove("hidden")}))):this.updateSubscription(source)}updateSubscription(source){const room=rooms[String(this.contextid)],update={request:"update",subscribe:[{feed:Number(source)}],unsubscribe:[{feed:Number(this.remoteFeed.current)}]};!source&&this.remoteFeed.current?delete update.subscribe:source&&!this.remoteFeed.current&&delete update.unsubscribe,this.remoteFeed.current!=source&&(this.remoteFeed.muteAudio=room.publish&&room.publish.feed===source,this.remoteFeed.videoroom.send({message:update}),this.remoteFeed.audioTrack&&(this.remoteFeed.audioTrack.enabled=!this.remoteFeed.muteAudio),room.publish&&this.remoteFeed.current==room.publish.feed&&(room.publish.handleClose(),room.publish=null),this.remoteFeed.current=source,!source&&this.remoteFeed&&(this.remoteFeed.handleClose(),this.remoteFeed=null),Number(source)?(document.querySelectorAll('[data-contextid="'+this.contextid+'"] .videotime-embed img.poster-img').forEach((img=>{img.classList.add("hidden")})),document.querySelectorAll('[data-contextid="'+this.contextid+'"] .videotime-embed video').forEach((video=>{video.classList.remove("hidden")}))):(document.querySelectorAll('[data-contextid="'+this.contextid+'"] .videotime-embed img.poster-img').forEach((img=>{img.classList.remove("hidden")})),document.querySelectorAll('[data-contextid="'+this.contextid+'"] .videotime-embed video').forEach((video=>{video.srcObject=null,video.classList.add("hidden")}))))}getDuration(){return 0}getPlaybackRate(){return 1}getPaused(){return!0}recordWatchTime(){}setSessionState(){}setCurrentTime(){}setPercent(){}}_exports.default=VideoTime;const handleClick=function(e){const button=e.target.closest('[data-roomid] [data-action="publish"], [data-roomid] [data-action="unpublish"],[data-roomid] [data-action="close"], [data-roomid] [data-action="switch"], [data-roomid] [data-action="mute"], [data-roomid] [data-action="unmute"]');if(button){const action=button.getAttribute("data-action"),contextid=e.target.closest("[data-contextid]").getAttribute("data-contextid"),room=rooms[String(contextid)],iceServers=room.iceServers,peerid=room.peerid,roomid=room.roomid,server=room.server,type=button.getAttribute("data-type");e.stopPropagation(),e.preventDefault(),"publish"!=action||room.publish&&!room.publish.restart?("mute"!=action&&"unmute"!=action||(button.classList.add("hidden"),button.parentNode.querySelectorAll('[data-action="mute"], [data-action="unmute"]').forEach((button=>{button.getAttribute("data-action")!=action&&button.classList.remove("hidden")}))),room.publish&&room.publish.handleClick(e)):(room.publish=new Publish(contextid,iceServers,roomid,server,peerid),room.publish.videoInput="display"==type?room.publish.shareDisplay():room.publish.shareCamera(),room.publish.startConnection(),document.getElementById("video-controls-"+(type||"camera")).parentNode.classList.remove("hidden"),document.getElementById("video-controls-"+(type||"camera")).parentNode.classList.add("selected"))}};class Subscribe extends _subscribe.default{async register(pluginHandle){if(wstoken){const url=new URL(_config.default.wwwroot+"/webservice/rest/server.php"),data=url.searchParams;data.set("wstoken",wstoken),data.set("moodlewsrestformat","json"),data.set("wsfunction","videotimeplugin_live_join_room"),data.set("handle",pluginHandle.getId()),data.set("id",Number(this.contextid)),data.set("plugin",pluginHandle.plugin),data.set("room",this.roomid),data.set("feed",this.feed),data.set("session",pluginHandle.session.getSessionId());try{const response=await fetch(url);return response.ok||_notification.default.exeption("Web service error"),await response.json()}catch(e){_notification.default.exception(e)}}return await _ajax.default.call([{args:{handle:pluginHandle.getId(),id:Number(this.contextid),plugin:pluginHandle.plugin,room:this.roomid,ptype:!1,feed:this.feed,session:pluginHandle.session.getSessionId()},contextid:this.contextid,fail:_notification.default.exception,methodname:"videotimeplugin_live_join_room"}])[0]}attachAudio(audioStream){_janusGateway.default.attachMediaStream(this.remoteVideo.parentNode.querySelector("audio"),audioStream),audioStream.getTracks().forEach((track=>{this.audioTrack=track,track.enabled=!this.muteAudio}))}attachVideo(videoStream){_janusGateway.default.attachMediaStream(this.remoteVideo,videoStream)}}return _exports.default}));

//# sourceMappingURL=videotime.min.js.map