define("videotimeplugin_videojs/videotime",["exports","mod_videotime/videotime","core/log","media_videojs/video-lazy","media_videojs/Youtube-lazy"],(function(_exports,_videotime,_log,_videoLazy,_YoutubeLazy){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * Video time player specific js
   *
   * @package    videotimeplugin_videojs
   * @module     videotimeplugin_videojs/videotime
   * @copyright  2022 bdecent gmbh <https://bdecent.de>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_videotime=_interopRequireDefault(_videotime),_log=_interopRequireDefault(_log),_videoLazy=_interopRequireDefault(_videoLazy);class VideoTime extends _videotime.default{initialize(){_log.default.debug("Initializing Video Time "+this.elementId);const instance=this.instance,options={autoplay:Number(instance.autoplay),controls:Number(instance.controls),sources:[{type:instance.type,src:instance.vimeo_url}],loop:Number(instance.option_loop),fluid:Number(instance.responsive),playsinline:Number(instance.playsinline),playbackRates:Number(instance.speed)?[.5,.75,1,1.25,1.5,2]:[1],muted:Number(instance.muted)};"video/youtube"===instance.type&&(options.techOrder=["youtube"]),!Number(instance.responsive)&&Number(instance.height)&&Number(instance.width)&&(options.height=Number(instance.height),options.width=Number(instance.width)),_log.default.debug("Initializing VideoJS player with options:"),_log.default.debug(options),this.player=new _videoLazy.default(this.elementId,options),this.player.one("canplay",(()=>{if(!instance.resume_playback||instance.resume_time<=0||this.resumed)return!0;let duration=this.getPlayer().duration(),resumeTime=instance.resume_time;return resumeTime+1>=Math.floor(duration)&&(_log.default.debug("VIDEO_TIME video finished, resuming at start of video."),resumeTime=0),_log.default.debug("VIDEO_TIME duration is "+duration),_log.default.debug("VIDEO_TIME resuming at "+resumeTime),resumeTime&&setTimeout((()=>{this.setCurrentPosition(resumeTime)}),10),!0})),this.handleStartTime(),this.addListeners();for(let i=0;i<this.plugins.length;i++){this.plugins[i].initialize(this,instance)}return!0}async addListeners(){if(this.player){if(this.player.on("play",(()=>(this.played||(this.hasPro&&this.startWatchInterval(),this.view()),!0))),this.hasPro&&(this.player.on("ended",this.handleEnd.bind(this)),this.player.on("pause",this.handlePause.bind(this)),this.player.options().responsive)){new ResizeObserver((()=>{this.player.height(this.player.videoHeight()/this.player.videoWidth()*this.player.currentWidth())})).observe(document.querySelector("#"+this.elementId))}}else _log.default.debug("Player was not properly initialized for course module "+this.cmId)}async setStartTime(starttime){let time=starttime.match(/((([0-9]+):)?(([0-9]+):))?([0-9]+(\.[0-9]+))/);return time?(this.resumeTime=3600*Number(time[3]||0)+60*Number(time[5]||0)+Number(time[6]),await this.player.currentTime(this.resumeTime)):(_log.default.debug("Set start time:"+starttime),await this.player.currentTime())}getDuration(){return new Promise((resolve=>(resolve(this.player.duration()),!0)))}getPlaybackRate(){return new Promise((resolve=>(resolve(this.player.playbackRate()),!0)))}setCurrentPosition(secs){return new Promise((resolve=>(resolve(this.player.currentTime(secs)),!0)))}async getCurrentPosition(){let position=await this.player.currentTime();return this.plugins.forEach((async plugin=>{plugin.getCurrentPosition&&(position=await plugin.getCurrentPosition(position))})),position}getPaused(){return this.player.paused()}}return _exports.default=VideoTime,_exports.default}));

//# sourceMappingURL=videotime.min.js.map