/**
 * AMD code for the frequently used comments chooser for the marking guide grading form.
 *
 * @module     mod_verbalfeedback/questionnaire
 * @class      view
 * @copyright  2020 Kevin Tippenhauer <kevin.tippenhauer@bfh.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_verbalfeedback/questionnaire",["jquery","core/templates","core/notification","core/ajax","core/str","core/modal_factory","core/modal_events"],(function($,Templates,Notification,Ajax,Str,ModalFactory,ModalEvents){var responses=[];let editor;const getEditor=function(){return editor||(editor=$(".editor_atto").length>0?"atto":window.tinyMCE?"tiny":"textarea",editor)},setComment=function(row,classSelector,comment){let append=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if("atto"===getEditor()){const editorcontent=row.find(classSelector+".editor_atto_content");return append?void editorcontent.append("<ul><li>"+comment+"</li></ul>"):void editorcontent.html(comment)}const commentId=row.find(classSelector).attr("id");if(commentId){const $input=$("#"+commentId);if("tiny"===getEditor())return append?void window.tinyMCE.get(commentId).insertContent("<ul><li>"+comment+"</li></ul><br/>"):void window.tinyMCE.get(commentId).setContent(comment);if(append){const oldComment=$input.val();if(""!==oldComment.trim())return void $input.val(oldComment+"\n\n"+comment)}$input.val(comment)}},getComment=function(row,classSel){if("atto"===getEditor()){let comment=row.find(classSel+".editor_atto_content").html();return""===comment.replace(/<[^>]+>/g,"").trim()?"":comment}const commentId=row.find(classSel).attr("id");if(commentId){let comment="";return comment="tiny"===getEditor()?window.tinyMCE.get(commentId).getContent():$("#"+commentId).val(),""===comment.replace(/<[^>]+>/g,"").trim()?"":comment}return""};var questionnaire=function(){this.registerEvents(),$('[data-region="question-row"]').each((function(){responses[$(this).data("criterionid")]={criterionid:$(this).data("criterionid"),value:null,studentcomment:"",privatecomment:""}}));let questionnaireTable=$('[data-region="questionnaire"]');if(1==questionnaireTable.data("preview"))return;let fromUser=questionnaireTable.data("fromuserid"),toUser=questionnaireTable.data("touserid"),verbalfeedbackId=questionnaireTable.data("verbalfeedbackid"),submissionId=questionnaireTable.data("submissionid");Ajax.call([{methodname:"mod_verbalfeedback_get_responses",args:{verbalfeedbackid:verbalfeedbackId,fromuserid:fromUser,touserid:toUser,submissionid:submissionId}}])[0].done((function(result){$.each(result.responses,(function(){let response=this;responses[response.criterionid].criterionid=response.criterionid,responses[response.criterionid].value=response.value,responses[response.criterionid].studentcomment=response.studentcomment,responses[response.criterionid].privatecomment=response.privatecomment,$('[data-region="question-row"]').each((function(){if($(this).data("criterionid")===response.criterionid){let options=$(this).find(".scaleoption");options&&options.each((function(){let selected=$(this).find("label");(selected.data("value")===response.value||""===selected.data("value")&&null===response.value)&&(selected.removeClass("badge-secondary"),selected.removeClass("badge-info"),selected.addClass("badge-success"))})),""!==response.studentcomment&&setComment($(this),".student-comment",response.studentcomment),""!==response.privatecomment&&setComment($(this),".private-comment",response.privatecomment)}}))}))})).fail(Notification.exception)};function saveResponses(finalise){$(".student-comment").each((function(){let row=$(this).parents('[data-region="question-row"]');responses[row.data("criterionid")].studentcomment=getComment(row,".student-comment")})),$(".private-comment").each((function(){let row=$(this).parents('[data-region="question-row"]');responses[row.data("criterionid")].privatecomment=getComment(row,".private-comment")}));let questionnaireTable=$('[data-region="questionnaire"]'),toUser=questionnaireTable.data("touserid"),toUserFullname=questionnaireTable.data("tousername"),verbalfeedbackId=questionnaireTable.data("verbalfeedbackid"),submissionId=questionnaireTable.data("submissionid");if(questionnaireTable.data("anonymous")&&finalise){let messageStrings=[{key:"finaliseanonymousfeedback",component:"mod_verbalfeedback"},{key:"confirmfinaliseanonymousfeedback",component:"mod_verbalfeedback",param:{name:toUserFullname}}];Str.get_strings(messageStrings,"mod_verbalfeedback").done((function(messages){!function(title,confirmationMessage,verbalfeedbackId,submissionId,toUser,responses,finalise){let confirmButtonTextPromise=Str.get_string("finalise","mod_verbalfeedback"),confirmModalPromise=ModalFactory.create({title:title,body:confirmationMessage,large:!0,type:ModalFactory.types.SAVE_CANCEL});$.when(confirmButtonTextPromise,confirmModalPromise).done((function(confirmButtonText,modal){modal.setSaveButtonText(confirmButtonText),modal.show(),modal.getRoot().on(ModalEvents.hidden,(function(){modal.setBody("")})),modal.getRoot().on(ModalEvents.save,(function(){submitResponses(verbalfeedbackId,submissionId,toUser,responses,finalise)}))}))}(messages[0],messages[1],verbalfeedbackId,submissionId,toUser,responses,finalise)})).fail(Notification.exception)}else submitResponses(verbalfeedbackId,submissionId,toUser,responses,finalise)}function submitResponses(verbalfeedbackId,submissionId,toUser,responses,finalise){let responseObjects=[];for(const tuple of Object.entries(responses))null!==tuple[1]&&responseObjects.push(tuple[1]);Ajax.call([{methodname:"mod_verbalfeedback_save_responses",args:{verbalfeedbackid:verbalfeedbackId,submissionid:submissionId,touserid:toUser,responses:responseObjects,complete:finalise}}])[0].done((function(response){Str.get_strings([{key:"responsessaved",component:"mod_verbalfeedback"},{key:"errorresponsesavefailed",component:"mod_verbalfeedback"}]).done((function(messages){let notificationData={};response.result?(notificationData.message=messages[0],notificationData.type="success"):(notificationData.message=messages[1],notificationData.type="error"),Notification.addNotification(notificationData)})).fail(Notification.exception),window.location=response.redirurl})).fail(Notification.exception)}return questionnaire.prototype.registerEvents=function(){$(".scaleoption").click((function(e){e.preventDefault();let row=$(this).parents('[data-region="question-row"]'),options=row.find("label");$.each(options,(function(){if($(this).hasClass("badge-success")){$(this).removeClass("badge-success"),$(this).addClass("badge-secondary");var forId=$(this).attr("for");$("#"+forId).removeAttr("checked")}}));let selected=$(this).find("label");selected.removeClass("badge-secondary"),selected.removeClass("badge-info"),selected.addClass("badge-success"),$("#"+selected.attr("for")).attr("checked","checked");let criterionid=row.data("criterionid");""===selected.data("value")?responses[criterionid].value=null:responses[criterionid].value=selected.data("value")})),$(".scaleoptionlabel").hover((function(e){e.preventDefault(),$(this).hasClass("badge-success")||($(this).hasClass("badge-secondary")?($(this).removeClass("badge-secondary"),$(this).addClass("badge-info")):($(this).addClass("badge-secondary"),$(this).removeClass("badge-info")))})),$(".detail-scaleoption").click((function(e){e.preventDefault();let row=$(this).parents('[data-region="detailed-rating"]'),value=$(this).find(".detail-scaleoptionlabel").data("value");setComment(row,".student-comment",value,!0)})),$(".detail-scaleoptionlabel").hover((function(e){e.preventDefault(),$(this).hasClass("badge-success")||($(this).hasClass("badge-secondary")?($(this).removeClass("badge-secondary"),$(this).addClass("badge-info")):($(this).addClass("badge-secondary"),$(this).removeClass("badge-info")))})),$("#save-feedback").click((function(){saveResponses(!1)})),$("#submit-feedback").click((function(){saveResponses(!0)})),$(".btn-detail-rating").click((function(e){e.preventDefault();let detailedRating=$(this).parents('[data-region="question-row"]').find(".detailed-rating");detailedRating.hasClass("hidden")?(detailedRating.removeClass("hidden"),$(this).html("−")):(detailedRating.addClass("hidden"),$(this).html("+"))}))},questionnaire}));

//# sourceMappingURL=questionnaire.min.js.map