define("tiny_fontcolor/colorswat",["exports","./polyfill","./options","./common"],(function(_exports,pf,_options,_common){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.register$c=void 0,pf=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}
/**
   * Color palette setter for Tiny Font Color plugin.
   * This code is mostly reused from the TinyMCE silver theme. However, this
   * code is enhanced to have two different color maps for background and
   * text color. Also, the option to enable or disable custom colors
   * via a colorpicker can be set independently on both text- and
   * background color. If the colorpicker is disabled and the color
   * map is empty for one of the text- or background color, the menu entry as
   * well as the toolbar button will not appear in the editor.
   *
   * @module      tiny_fontcolor
   * @copyright   2023 Luca Bösch <luca.boesch@bfh.ch>
   * @copyright   2023 Stephan Robotta <stephan.robotta@bfh.ch>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */(pf);let global$4=localStorage;const labels=(()=>{let labels;return{get:function(name){let val=(0,pf.isNullable)(labels[name])?name:labels[name];for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++)args[_key-1]=arguments[_key];if(!(0,pf.isNullable)(args))for(let x=0;x<args.length;x++)val=val.replace("{"+x+"}",args[x]);return val},register:txt=>{labels=txt}}})(),Cell=initial=>{let value=initial;return{get:()=>value,set:v=>{value=v}}},storageName="tinymce-custom-colors",ColorCache=function(){let max=arguments.length>0&&void 0!==arguments[0]?arguments[0]:10,suffix=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";const storageString=global$4.getItem(storageName+suffix),localstorage=pf.isString(storageString)?JSON.parse(storageString):[],prune=list=>max-list.length<0?list.slice(0,max):list,cache=prune(localstorage),add=key=>{pf.indexOf(cache,key).each(remove),cache.unshift(key),cache.length>max&&cache.pop(),global$4.setItem(storageName,JSON.stringify(cache))},remove=idx=>{cache.splice(idx,1)},state=()=>cache.slice(0);return{add:add,state:state}},colorCache=ColorCache(10),colorCacheBg=ColorCache(10,"-background"),getColorCols$1=(name="color_cols",editor=>editor.options.get(name));var name;const getColors$3=(editor,name)=>name===_common.forecolor?(0,_options.getForecolorMap)(editor):(0,_options.getBackcolorMap)(editor),getCurrentColors=type=>((xs,f)=>{const len=xs.length,r=new Array(len);for(let i=0;i<len;i++){const x=xs[i];r[i]=f(x,i)}return r})(type===_common.forecolor?colorCache.state():colorCacheBg.state(),(color=>({type:"choiceitem",text:color,value:color}))),getCurrentColor=(editor,format)=>{let color;return editor.dom.getParents(editor.selection.getStart(),(elm=>{const value=(node=elm,pf.isNonNullable(node.style)?elm.style[format===_common.forecolor?"color":"backgroundColor"]:null);var node;value&&(color=color||value)})),pf.Optional.from(color)},handleColorChange=(editor,format,value)=>{if((0,_options.useCssClasses)(editor)){const cssClass=_common.forecolor.includes(format)?(0,_options.getForecolorClasses)(editor).find((v=>v[1]===value)):(0,_options.getBackcolorClasses)(editor).find((v=>v[1]===value));if(cssClass)return void editor.execCommand("mceApplyTextcolor","fontcolor_classes",cssClass[0])}editor.execCommand("mceApplyTextcolor",format,value)},applyColor=(editor,format,value,onChoice)=>{if("custom"===value){colorPickerDialog(editor)((colorOpt=>{colorOpt.each((color=>{(color=>{colorCache.add(color)})(color),handleColorChange(editor,format,color),onChoice(color)}))}),"#000000")}else"remove"===value?(onChoice(""),((editor,format)=>{(0,_options.useCssClasses)(editor)?editor.execCommand("mceRemoveTextcolor","fontcolor_classes"):editor.execCommand("mceRemoveTextcolor",format)})(editor,format)):(onChoice(value),handleColorChange(editor,format,value))},getColors$1=(colors,hasCustom,type)=>colors.concat(getCurrentColors(type).concat((hasCustom=>{const remove={type:"choiceitem",text:labels.get("removeColor"),icon:"color-swatch-remove-color",value:"remove"},custom={type:"choiceitem",text:labels.get("customColor"),icon:"color-picker",value:"custom"};return hasCustom?[remove,custom]:[remove]})(hasCustom))),getFetch$1=(colors,hasCustom,type)=>callback=>{callback(getColors$1(colors,hasCustom,type))},setIconColor=(splitButtonApi,name,newColor)=>{const id=name===_common.forecolor?"tox-icon-text-color__color":"tox-icon-highlight-bg-color__color";splitButtonApi.setIconFill(id,newColor)},registerTextColorButton=(editor,name,format,tooltip,lastColor)=>{let iconName,hasCustom;name===_common.forecolor?(iconName="text-color",hasCustom=(0,_options.isForecolorPickerOn)(editor)):(iconName="highlight-bg-color",hasCustom=(0,_options.isBackcolorPickerOn)(editor)),editor.ui.registry.addSplitButton(name,{tooltip:tooltip,presets:"color",icon:iconName,select:value=>getCurrentColor(editor,format).bind((currentRgb=>pf.fromString(currentRgb).map((rgba=>{const currentHex=pf.fromRgba(rgba).value;return pf.contains$1(value.toLowerCase(),currentHex)})))).getOr(!1),columns:getColorCols$1(editor),fetch:getFetch$1(getColors$3(editor,name),hasCustom,name),onAction:()=>{applyColor(editor,format,lastColor.get(),pf.noop)},onItemAction:(_splitButtonApi,value)=>{applyColor(editor,format,value,(newColor=>{lastColor.set(newColor),((editor,data)=>{editor.dispatch("TextColorChange",data)})(editor,{name:name,color:newColor})}))},onSetup:splitButtonApi=>{setIconColor(splitButtonApi,name,lastColor.get());const handler=e=>{e.name===name&&setIconColor(splitButtonApi,e.name,e.color)};return editor.on("TextColorChange",handler),()=>{editor.off("TextColorChange",handler)}}})},registerTextColorMenuItem=(editor,name,format,text)=>{editor.ui.registry.addNestedMenuItem(name,{text:text,icon:name===_common.forecolor?"text-color":"highlight-bg-color",getSubmenuItems:()=>[{type:"fancymenuitem",fancytype:"colorswatch",initData:{allowCustomColors:name===_common.forecolor?(0,_options.isForecolorPickerOn)(editor):(0,_options.isBackcolorPickerOn)(editor),colors:getColors$3(editor,name)},onAction:data=>{applyColor(editor,format,data.value,pf.noop)}}]})},colorPickerDialog=editor=>(callback,value)=>{const initialData={colorpicker:value};editor.windowManager.open({title:labels.get("colorPickerTitle"),size:"normal",body:{type:"panel",items:[{type:"htmlpanel",html:'<span class="dlg-color-picker-error hidden"></span>'},{type:"colorpicker",name:"colorpicker",label:labels.get("colorPickerColor")}]},buttons:[{type:"cancel",name:"cancel",text:labels.get("colorPickerCancel")},{type:"submit",name:"save",text:labels.get("colorPickerSave"),primary:!0}],initialData:initialData,onSubmit:api=>{const hex=api.getData().colorpicker,err=document.querySelector(".dlg-color-picker-error");let isValid=!0;err.parentNode.parentNode.querySelectorAll("input").forEach(((i,x)=>{if(x<3){const m=["R","G","B"],r=parseInt(i.value);(!i.value.match(/^\d{1,3}$/)||r<0||r>255)&&(err.innerHTML=labels.get("colorPickerErrRgbCode",m[x]+" = "+i.value),i.focus(),isValid=!1)}else(0,pf.isHexString)("#"+i.value)||(err.innerHTML=labels.get("colorPickerErrHexCode",hex),i.focus(),isValid=!1)})),isValid?(callback(pf.Optional.from(hex)),api.close()):(err.classList.remove("hidden"),err.classList.add("alert"))},onClose:pf.noop,onCancel:()=>{callback(pf.Optional.none())}})};_exports.register$c=(editor,txt)=>{if((0,_options.isForecolorPickerOn)(editor)||(0,_options.isBackcolorPickerOn)(editor)||0!==(0,_options.getForecolorMap)(editor).length||0!==(0,_options.getBackcolorMap)(editor).length){if((txt=>{labels.register(txt)})(txt),(editor=>{editor.addCommand("mceApplyTextcolor",((format,value)=>{((editor,format,value)=>{editor.undoManager.transact((()=>{editor.focus(),editor.formatter.apply(format,{value:value}),editor.nodeChanged()}))})(editor,format,value)})),editor.addCommand("mceRemoveTextcolor",(format=>{((editor,format)=>{editor.undoManager.transact((()=>{editor.focus(),editor.formatter.remove(format,{value:null},void 0,!0),editor.nodeChanged()}))})(editor,format)}))})(editor),(0,_options.isForecolorPickerOn)(editor)||(0,_options.getForecolorMap)(editor).length>0){const lastForeColor=Cell("#000000");registerTextColorButton(editor,_common.forecolor,"forecolor",labels.get("btnFgColor"),lastForeColor),registerTextColorMenuItem(editor,_common.forecolor,"forecolor",labels.get("menuItemFgcolor"))}if((0,_options.isBackcolorPickerOn)(editor)||(0,_options.getBackcolorMap)(editor).length>0){const lastBackColor=Cell("#000000");registerTextColorButton(editor,_common.backcolor,"hilitecolor",labels.get("btnBgcolor"),lastBackColor),registerTextColorMenuItem(editor,_common.backcolor,"hilitecolor",labels.get("menuItemBgcolor"))}(0,_options.useCssClasses)(editor)&&editor.on("SkinLoaded",(()=>{editor.formatter.register("fontcolor_classes",{inline:"span",attributes:{class:"%value"},links:!0,remove_similar:!0,clear_child_styles:!0});const contentStyles=[];(0,_options.getBackcolorClasses)(editor).forEach((e=>{contentStyles.push(".".concat(e[0],"{background-color:").concat(e[1],"}"))})),(0,_options.getForecolorClasses)(editor).forEach((e=>{contentStyles.push(".".concat(e[0],"{color: ").concat(e[1],"}"))}));const mceDefaultStyles=editor.dom.select("#mceDefaultStyles");if(mceDefaultStyles.length>0)mceDefaultStyles[0].innerHTML+=contentStyles.join(" ");else{const styleEl=document.createElement("style");styleEl.setAttribute("type","text/css");const cssText=document.createTextNode(contentStyles.join(""));styleEl.appendChild(cssText),editor.dom.select("head")[0].appendChild(styleEl)}}))}}}));

//# sourceMappingURL=colorswat.min.js.map