define("tiny_fontcolor/polyfill",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.typeOf=_exports.toHex=_exports.startsWith=_exports.shorthandRegex=_exports.rgbaRegex=_exports.rgbaColour=_exports.rgbRegex=_exports.removeLeading=_exports.removeFromStart=_exports.rawIndexOf=_exports.normalizeHex=_exports.noop=_exports.nativeIndexOf=_exports.mapColors=_exports.longformRegex=_exports.longformAlphaRegex=_exports.isUndefined=_exports.isType$1=_exports.isString=_exports.isNullable=_exports.isNonNullable=_exports.isHexString=_exports.isArrayOf=_exports.isArray=_exports.indexOf=_exports.hexColour=_exports.hasProto=_exports.fromStringValues=_exports.fromString$1=_exports.fromString=_exports.fromRgba=_exports.eq$1=_exports.contains$1=_exports.checkRange=_exports.anyToHex=_exports.Optional=void 0;
/**
   * Helper functions that come from the theme.js of the TinyMCE and that are
   * heavily used by the colorswat.js.
   *
   * @module      tiny_fontcolor
   * @copyright   2023 Luca Bösch <luca.boesch@bfh.ch>
   * @copyright   2023 Stephan Robotta <stephan.robotta@bfh.ch>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const hasProto=(v,constructor,predicate)=>{return!!predicate(v,constructor.prototype)||(null===(_v$constructor=v.constructor)||void 0===_v$constructor?void 0:_v$constructor.name)===constructor.name;var _v$constructor};_exports.hasProto=hasProto;const typeOf=x=>{const t=typeof x;return null===x?"null":"object"===t&&Array.isArray(x)?"array":"object"===t&&hasProto(x,String,((o,proto)=>proto.isPrototypeOf(o)))?"string":t};_exports.typeOf=typeOf;const eq$1=t=>a=>t===a;_exports.eq$1=eq$1;const isType$1=type=>value=>typeOf(value)===type;_exports.isType$1=isType$1;const isString=isType$1("string");_exports.isString=isString;const isArray=isType$1("array");_exports.isArray=isArray;const isUndefined=eq$1(void 0);_exports.isUndefined=isUndefined;const isNullable=a=>null==a;_exports.isNullable=isNullable;const isNonNullable=a=>!isNullable(a);_exports.isNonNullable=isNonNullable;_exports.isArrayOf=(value,pred)=>{if(isArray(value)){for(let i=0,len=value.length;i<len;++i)if(!pred(value[i]))return!1;return!0}return!1};const nativeIndexOf=Array.prototype.indexOf;_exports.nativeIndexOf=nativeIndexOf;const rawIndexOf=(ts,t)=>nativeIndexOf.call(ts,t);_exports.rawIndexOf=rawIndexOf;_exports.indexOf=(xs,x)=>{const r=rawIndexOf(xs,x);return-1===r?Optional.none():Optional.some(r)};_exports.noop=()=>{};_exports.contains$1=function(str,substr){let start=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,end=arguments.length>3?arguments[3]:void 0;const idx=str.indexOf(substr,start);return-1!==idx&&(!!isUndefined(end)||idx+substr.length<=end)};const removeFromStart=(str,numChars)=>str.substring(numChars);_exports.removeFromStart=removeFromStart;const toHex=component=>{const hex=component.toString(16);return(1===hex.length?"0"+hex:hex).toUpperCase()};_exports.toHex=toHex;const fromRgba=rgbaColour=>{const value=toHex(rgbaColour.red)+toHex(rgbaColour.green)+toHex(rgbaColour.blue)+toHex(rgbaColour.alpha);return hexColour(value)};_exports.fromRgba=fromRgba;const rgbRegex=/^\s*rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)\s*$/i;_exports.rgbRegex=rgbRegex;const rgbaRegex=/^\s*rgba\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?(?:\.\d+)?)\s*\)\s*$/i;_exports.rgbaRegex=rgbaRegex;const fromStringValues=(red,green,blue,alpha)=>{const r=parseInt(red,10),g=parseInt(green,10),b=parseInt(blue,10),a=parseFloat(alpha);return rgbaColour(r,g,b,a)};_exports.fromStringValues=fromStringValues;const fromString=rgbaString=>{if("transparent"===rgbaString)return Optional.some(rgbaColour(0,0,0,0));const rgbMatch=rgbRegex.exec(rgbaString);if(null!==rgbMatch)return Optional.some(fromStringValues(rgbMatch[1],rgbMatch[2],rgbMatch[3],"1"));const rgbaMatch=rgbaRegex.exec(rgbaString);return null!==rgbaMatch?Optional.some(fromStringValues(rgbaMatch[1],rgbaMatch[2],rgbaMatch[3],rgbaMatch[4])):Optional.none()};_exports.fromString=fromString;const removeLeading=(str,prefix)=>startsWith(str,prefix)?removeFromStart(str,prefix.length):str;_exports.removeLeading=removeLeading;const checkRange=(str,substr,start)=>""===substr||str.length>=substr.length&&str.substr(start,start+substr.length)===substr;_exports.checkRange=checkRange;const hexColour=value=>({value:value});_exports.hexColour=hexColour;const shorthandRegex=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;_exports.shorthandRegex=shorthandRegex;const longformRegex=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;_exports.longformRegex=longformRegex;const longformAlphaRegex=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;_exports.longformAlphaRegex=longformAlphaRegex;const isHexString=hex=>shorthandRegex.test(hex)||longformRegex.test(hex)||longformAlphaRegex.test(hex);_exports.isHexString=isHexString;const normalizeHex=hex=>removeLeading(hex,"#").toUpperCase();_exports.normalizeHex=normalizeHex;const fromString$1=hex=>isHexString(hex)?Optional.some({value:normalizeHex(hex)}):Optional.none();_exports.fromString$1=fromString$1;const startsWith=(str,prefix)=>checkRange(str,prefix,0);_exports.startsWith=startsWith;const anyToHex=color=>fromString$1(color).orThunk((()=>fromString(color).map(fromRgba))).getOrThunk((()=>{const canvas=document.createElement("canvas");canvas.height=1,canvas.width=1;const canvasContext=canvas.getContext("2d");canvasContext.clearRect(0,0,canvas.width,canvas.height),canvasContext.fillStyle="#FFFFFF",canvasContext.fillStyle=color,canvasContext.fillRect(0,0,1,1);const rgba=canvasContext.getImageData(0,0,1,1).data,r=rgba[0],g=rgba[1],b=rgba[2],a=rgba[3];return fromRgba(rgbaColour(r,g,b,a))}));_exports.anyToHex=anyToHex;const rgbaColour=(red,green,blue,alpha)=>({red:red,green:green,blue:blue,alpha:alpha});_exports.rgbaColour=rgbaColour;_exports.mapColors=colorMap=>{const colors=[];for(let i=0;i<colorMap.length;i+=2)colors.push({text:colorMap[i+1],value:"#"+anyToHex(colorMap[i]).value,type:"choiceitem"});return colors};class Optional{constructor(tag,value){this.tag=tag,this.value=value}static some(value){return new Optional(!0,value)}static none(){return Optional.singletonNone}fold(onNone,onSome){return this.tag?onSome(this.value):onNone()}isSome(){return this.tag}isNone(){return!this.tag}map(mapper){return this.tag?Optional.some(mapper(this.value)):Optional.none()}bind(binder){return this.tag?binder(this.value):Optional.none()}exists(predicate){return this.tag&&predicate(this.value)}forall(predicate){return!this.tag||predicate(this.value)}filter(predicate){return!this.tag||predicate(this.value)?this:Optional.none()}getOr(replacement){return this.tag?this.value:replacement}or(replacement){return this.tag?this:replacement}getOrThunk(thunk){return this.tag?this.value:thunk()}orThunk(thunk){return this.tag?this:thunk()}getOrDie(message){if(this.tag)return this.value;throw new Error(null!=message?message:"Called getOrDie on None")}static from(value){return isNonNullable(value)?Optional.some(value):Optional.none()}getOrNull(){return this.tag?this.value:null}getOrUndefined(){return this.value}each(worker){this.tag&&worker(this.value)}toArray(){return this.tag?[this.value]:[]}toString(){return this.tag?"some(".concat(this.value,")"):"none()"}}_exports.Optional=Optional,Optional.singletonNone=new Optional(!1)}));

//# sourceMappingURL=polyfill.min.js.map