define("tiny_multilang2/htmlparser",["exports","./constants"],(function(_exports,_constants){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.parseEditorContent=void 0;
/**
   * Handling of the editor content to add and remove the visual styling and
   * helper nodes to modify language settings.
   *
   * @module      tiny_multilang2
   * @copyright   2024 Stephan Robotta <stephan.robotta@bfh.ch>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class HTMLParser{constructor(){this.onTagOpen=null,this.onTagClose=null,this.onText=null,this.onComment=null,this.onScript=null,this.onStyle=null,this.chunk="",this.parse=function(input){let content=input;for(;content.length>0;){let match=content.match(/<[^>]*>/);if(match){let index=match.index;if(index>0&&(this.chunk=content.substring(0,index),content=content.substring(index),"function"==typeof this.onText&&this.onText(this.chunk)),this.chunk=match[0],"/"===match[0].charAt(1)){if("function"==typeof this.onTagClose){const tag=match[0].substring(2,match[0].length-1).trim().toLowerCase();this.onTagClose(tag)}}else if(0===match[0].indexOf("\x3c!--"))this.handleInlineCode("--\x3e",content),"function"==typeof this.onComment&&this.onComment(this.chunk);else if(0===match[0].toLowerCase().indexOf("<script"))this.handleInlineCode("<\/script>",content),"function"==typeof this.onScript&&this.onScript(this.chunk);else if(0===match[0].toLowerCase().indexOf("<style"))this.handleInlineCode("</style>",content),"function"==typeof this.onStyle&&this.onStyle(this.chunk);else if("function"==typeof this.onTagOpen){const attr1=this.mapAttrs(match[0].match(/([\w\-_]+)="([^"]*)"/g)),attr2=this.mapAttrs(match[0].match(/([\w\-_]+)='([^']*)'/g)),tag=match[0].match(/^<(\w+)/);this.onTagOpen(tag[1].toLowerCase(),{...attr1,...attr2})}content=content.substring(this.chunk.length)}else"function"==typeof this.onText&&this.onText(content),this.chunk=content,content=""}},this.getChunk=function(){return this.chunk},this.mapAttrs=function(attrs){let res={};if(attrs)for(let i=0;i<attrs.length;i++){let[k,v]=attrs[i].split("=");res[k]=v?v.substring(1,v.length):null}return res},this.handleInlineCode=function(endTag,content){let end=content.toLowerCase().indexOf(endTag);-1===end?end=content.length:end+=endTag.length,this.chunk=content.substring(0,end)}}}_exports.parseEditorContent=function(html){let newHtml="",mlang=0,inClose=!1;const parser=new HTMLParser,passThru=function(comment){newHtml+=comment};return parser.onTagOpen=function(tag,attr){"span"===tag&&attr.class&&attr.class.indexOf("multilang-begin")>-1?mlang++:"span"===tag&&attr.class&&attr.class.indexOf("multilang-end")>-1&&mlang>0&&(mlang--,inClose=!0),newHtml+=parser.getChunk()},parser.onTagClose=function(tag){"span"===tag&&inClose&&(inClose=!1),newHtml+=parser.getChunk()},parser.onText=function(text){if(inClose)return void(newHtml+=text);const intermediateReplacements=[];for(;;){const m=text.match(new RegExp("{\\s*mlang(\\s+([^}]+?))?\\s*}","i"));if(!m)break;const textBefore=text.substring(0,m.index),textAfter=text.substring(m.index+m[0].length);let r=m[0];m[2]?(0===mlang&&(r=_constants.spanMultilangBegin.replace(new RegExp("%lang","g"),m[2])),mlang++):(1===mlang&&(r=_constants.spanMultilangEnd),mlang--),intermediateReplacements.push(r),text="".concat(textBefore,"___~~").concat(intermediateReplacements.length,"~~___").concat(textAfter)}for(let i=0;i<intermediateReplacements.length;i++)text=text.replace("___~~".concat(i+1,"~~___"),intermediateReplacements[i]);newHtml+=text},parser.onComment=passThru,parser.onScript=passThru,parser.onStyle=passThru,parser.parse(html),newHtml}}));

//# sourceMappingURL=htmlparser.min.js.map