define("tiny_multilang2/ui",["exports","./options","./constants","./htmlparser"],(function(_exports,_options2,_constants,_htmlparser){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.onSubmit=_exports.onInit=_exports.onFocus=_exports.onDelete=_exports.onBeforeGetContent=_exports.applyLanguage=void 0;
/**
   * Commands for the plugin logic of the Moodle tiny_multilang2 plugin.
   *
   * @module      tiny_multilang2
   * @author      Iñaki Arenaza <iarenaza@mondragon.edu>
   * @author      Stephan Robotta <stephan.robotta@bfh.ch>
   * @author      Tai Le Tan <dev.tailetan@gmail.com>
   * @copyright   2015 onwards Iñaki Arenaza & Mondragon Unibertsitatea
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
let _isSubmit=!1;const _options={},addVisualStyling=function(ed){let content=(0,_htmlparser.parseEditorContent)(ed.getContent());const doc=(new DOMParser).parseFromString(content,"text/html");if(0===doc.children.length)return content;const nodes=doc.querySelectorAll("span.multilang");if(0===nodes.length)return content;for(const span of nodes){const newSpan=_constants.spanMultilangBegin.replace(new RegExp("%lang","g"),span.getAttribute("lang")).replace("mceNonEditable","mceNonEditable fallback")+span.innerHTML+_constants.spanMultilangEnd.replace("mceNonEditable","mceNonEditable fallback");span.insertAdjacentHTML("afterend",newSpan),span.remove()}return doc.getElementsByTagName("body")[0].innerHTML},removeVisualStyling=function(ed){["begin","end"].forEach((function(t){for(const span of ed.dom.select("span.multilang-"+t))if("begin"===t&&span.classList.contains("fallback")){let innerHTML="",end=span,toRemove=[];for(;end&&(end=end.nextSibling,!(0,_constants.isNull)(end));){if(!(0,_constants.isNull)(end.classList)&&end.classList.contains("multilang-end")){toRemove.push(end);break}3===end.nodeType?innerHTML+=end.nodeValue:1===end.nodeType&&(innerHTML+=end.outerHTML),toRemove.push(end)}if(!(0,_constants.isNull)(end)){const lang=span.innerHTML.match(new RegExp("{\\s*mlang\\s+([^}]+?)\\s*}","i"));if(lang){const newHTML='<span class="multilang" lang="'.concat(lang[1],'">').concat(innerHTML,"</span>");for(end of(ed.dom.setOuterHTML(span,newHTML),toRemove))ed.dom.remove(end)}}}else ed.dom.setOuterHTML(span,span.innerHTML.toLowerCase())}))},getHighlightNodeFromSelect=function(ed,search){let span;return ed.dom.getParents(ed.selection.getStart(),(elm=>{if(!(0,_constants.isNull)(elm.classList)){const counterpart="begin"===search?"end":"begin";elm.classList.contains("multilang-"+counterpart)?span="begin"===search?findClosestAncestor(ed,elm):findClosestSuccessor(ed,elm):elm.classList.contains("multilang-"+search)&&(span=elm)}})),span},findClosestAncestor=function(ed,node){const nodeList=ed.dom.select("span.multilang-begin, span.multilang-end");for(let i=0;i<nodeList.length;i++)if(nodeList[i]===node&&i>0&&isMultilangTag(nodeList[i-1],"begin"))return nodeList[i-1];return null},findClosestSuccessor=function(ed,node){const nodeList=ed.dom.select("span.multilang-begin, span.multilang-end");for(let i=0;i<nodeList.length;i++)if(nodeList[i]===node&&i<nodeList.length-1&&isMultilangTag(nodeList[i+1],"end"))return nodeList[i+1];return null},isMultilangTag=function(node,search){return!(0,_constants.isNull)(node.classList)&&node.classList.contains("multilang-"+search)},hideContentToolbar=function(el){for(;!(0,_constants.isNull)(el);){if(el.nodeType===Node.ELEMENT_NODE&&!(0,_constants.isNull)(el.getAttribute("class"))&&-1!=el.getAttribute("class").indexOf("tox-pop-"))return void(el.style.display="none");el=el.parentNode}};_exports.onInit=function(ed,options){Object.keys(options).forEach((function(key){_options[key]=options[key]})),ed.setContent(addVisualStyling(ed)),(0,_options2.isContentToHighlight)(ed)&&ed.dom.addStyle((0,_options2.getHighlightCss)(ed))};_exports.onBeforeGetContent=function(ed,content){if(!(0,_constants.isNull)(content.source_view)&&!0===content.source_view){const onClose=function(ed){ed.off("close",onClose),ed.setContent(addVisualStyling(ed))};new MutationObserver(((mutations,obs)=>{const viewSrcModal=document.querySelector('[data-region="modal"]');if(viewSrcModal)return viewSrcModal.addEventListener("click",(event=>{const{action:action}=event.target.dataset;["cancel","save","hide"].includes(action)&&onClose(ed)})),void obs.disconnect();document.querySelector(".tox-dialog-wrap")&&(ed.on("CloseWindow",(()=>{onClose(ed)})),obs.disconnect())})).observe(document.body,{childList:!0,subtree:!0}),removeVisualStyling(ed)}};_exports.onFocus=function(ed){_isSubmit&&(ed.setContent(addVisualStyling(ed),{no_events:!0}),_isSubmit=!1)};_exports.onSubmit=function(ed){removeVisualStyling(ed),_isSubmit=!0};_exports.onDelete=function(ed,event){if(event.isComposing||(0,_constants.isNull)(event.clientX)&&46!==event.keyCode&&8!==event.keyCode)return;if(!(0,_constants.isNull)(event.clientX)&&(event.target.nodeType!==Node.ELEMENT_NODE||"path"!==event.target.nodeName&&"svg"!==event.target.nodeName))return;const begin=getHighlightNodeFromSelect(ed,"begin"),end=getHighlightNodeFromSelect(ed,"end");(0,_constants.isNull)(begin)||(0,_constants.isNull)(end)||(event.preventDefault(),ed.dom.remove(begin),ed.dom.remove(end),(0,_constants.isNull)(event.clientX)||hideContentToolbar(event.target),cleanupBogus(ed))};const cleanupBogus=function(ed){for(const span of ed.dom.select('span[class*="multilang"')){const p=span.parentElement;!(0,_constants.isNull)(p.classList)&&p.classList.contains("mce-offscreen-selection")&&ed.dom.remove(p)}};_exports.applyLanguage=function(ed,iso,event){if((0,_constants.isNull)(iso))return;if("remove"===iso){return void ed.contentDocument.body.querySelectorAll(".multilang-begin, .multilang-end").forEach((element=>{ed.dom.remove(element)}))}const regexLang=/%lang/g;let text=ed.selection.getContent();if(""===(0,_constants.trim)(text)){if(!(0,_constants.isNull)(event))return void hideContentToolbar(event.target);let newtext=_constants.spanMultilangBegin.replace(regexLang,iso)+" "+_constants.spanMultilangEnd;return(0,_options2.mlangFilterExists)(ed)||(newtext=newtext.replaceAll("mceNonEditable","mceNonEditable fallback")),void ed.insertContent(newtext)}(0,_constants.isNull)(event)||hideContentToolbar(event.target);const span=getHighlightNodeFromSelect(ed,"begin");if(!(0,_constants.isNull)(span)){let replacement=_constants.spanMultilangBegin.replace(regexLang,iso);return span.classList.contains("fallback")&&(replacement=replacement.replace("mceNonEditable","mceNonEditable fallback")),ed.dom.setOuterHTML(span,replacement),void cleanupBogus(ed)}if(-1!==text.indexOf("multilang-begin")||-1!==text.indexOf("multilang-end"))return void ed.notificationManager.open({text:_options.langInSelectionErrMsg,type:"error"});const block=function(text){let result={el:null,cnt:0};const body=(new DOMParser).parseFromString(text,"text/html").body;if(body.firstChild.nodeType!==Node.ELEMENT_NODE)return result;for(let i=0;i<body.children.length;i++)body.children[i].nodeType===Node.ELEMENT_NODE&&-1!==_constants.blockTags.indexOf(body.children[i].tagName.toString().toLowerCase())&&(result.cnt+=1,(0,_constants.isNull)(result.el)&&(result.el=body.children[i]));return result}(text);if(!(0,_constants.isNull)(block.el)){if(1===block.cnt){let newtext=_constants.spanMultilangBegin.replace(regexLang,iso)+block.el.innerHTML+_constants.spanMultilangEnd;return(0,_options2.mlangFilterExists)(ed)||(newtext=newtext.replaceAll("mceNonEditable","mceNonEditable fallback")),block.el.innerHTML=newtext,void ed.selection.setContent(block.el.outerHTML)}if(!(0,_options2.mlangFilterExists)(ed))return void ed.notificationManager.open({text:_options.multipleBlocksErrMsg,type:"error"})}let newtext=_constants.spanMultilangBegin.replace(regexLang,iso)+text+_constants.spanMultilangEnd;(0,_options2.mlangFilterExists)(ed)||(newtext=newtext.replaceAll("mceNonEditable","mceNonEditable fallback")),ed.selection.setContent(newtext)}}));

//# sourceMappingURL=ui.min.js.map