define("block_aipromptgen/ui",["exports","block_aipromptgen/age","block_aipromptgen/pickers","block_aipromptgen/actions"],(function(_exports,_age,_pickers,_actions){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;
/**
   * ES6 orchestrator module: aggregates individual feature modules for the AI Prompt Generator block.
   * Split into smaller modules for clarity, testability, and alignment with Moodle JS module guidelines.
   *
   * @module     block_aipromptgen/ui
   * @copyright  2025 AI4Teachers
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const initProviderSend=()=>{const sendBtn=document.getElementById("ai4t-sendtoai"),select=document.getElementById("ai4t-provider"),gen=document.getElementById("ai4t-generated");let hidden=document.getElementById("ai4t-sendto");if(!hidden){const form=document.getElementById("promptform");form&&(hidden=document.createElement("input"),hidden.type="hidden",hidden.name="sendto",hidden.id="ai4t-sendto",form.appendChild(hidden))}if(!(sendBtn&&select&&gen&&hidden))return;const resp=document.getElementById("ai4t-airesponse"),findForm=()=>document.getElementById("promptform")||document.getElementById("mform1")||sendBtn.closest("form"),refreshState=()=>{const opt=select.options[select.selectedIndex],unconfigured=opt&&/✕\s*$/.test(opt.textContent||"");sendBtn.disabled=!gen.value.trim()||unconfigured},scrollToResponse=()=>{const heading=document.getElementById("ai4t-response-heading");if(heading)try{heading.scrollIntoView({behavior:"smooth",block:"start"})}catch(e){heading.scrollIntoView()}};select.addEventListener("change",refreshState),gen.addEventListener("input",refreshState),sendBtn.addEventListener("click",(e=>{if(sendBtn.disabled)return;const provider=select.value;if("ollama"===provider)return e.preventDefault(),void(()=>{if(!window.EventSource){const form=findForm();return void(form&&form.submit())}const courseInput=document.querySelector("input[name=courseid]"),courseid=courseInput?courseInput.value:"";hidden.value="ollama",resp&&(resp.textContent="",resp.setAttribute("aria-busy","true"));let statusEl=document.getElementById("ai-response-status");var _resp$parentNode;!statusEl&&resp&&(statusEl=document.createElement("div"),statusEl.id="ai-response-status",statusEl.className="small text-muted",null===(_resp$parentNode=resp.parentNode)||void 0===_resp$parentNode||_resp$parentNode.insertBefore(statusEl,resp)),statusEl&&(statusEl.textContent="Streaming...");const base=(window.M&&window.M.cfg&&M.cfg.wwwroot?M.cfg.wwwroot:"")+"/blocks/aipromptgen/stream.php";let prompt=gen.value||gen.textContent||"";if(!prompt){const fd=new FormData(findForm()||void 0);prompt="Topic: "+(fd.get("topic")||"")+"\nLesson: "+(fd.get("lesson")||"")+"\nOutcomes: "+(fd.get("outcomes")||"")}const es=new EventSource(base+"?courseid="+encodeURIComponent(courseid)+"&provider=ollama&prompt="+encodeURIComponent(prompt));let first=!0;es.addEventListener("start",(()=>{statusEl&&(statusEl.textContent="Started"),scrollToResponse()})),es.addEventListener("chunk",(ev=>{resp&&(resp.textContent+=ev.data,first&&(scrollToResponse(),first=!1))})),es.addEventListener("error",(ev=>{resp&&(resp.textContent+="\n[Error] "+(ev.data||"")),statusEl&&(statusEl.textContent="Error"),scrollToResponse()})),es.addEventListener("done",(()=>{statusEl&&(statusEl.textContent="Done"),resp&&resp.removeAttribute("aria-busy"),scrollToResponse(),es.close()}))})();hidden.value=provider;const form=findForm();form&&form.submit()})),refreshState()};_exports.init=()=>{const genWrapper=document.getElementById("ai4t-generated-wrapper");if(genWrapper)try{genWrapper.scrollIntoView({behavior:"smooth",block:"start"})}catch(e){genWrapper.scrollIntoView()}(0,_age.initAgeModal)(),(0,_pickers.attachPicker)({openId:"ai4t-lesson-browse",modalId:"ai4t-modal",closeId:"ai4t-modal-close",cancelId:"ai4t-modal-cancel",itemSelector:".ai4t-lesson-item",targetId:"id_lesson"}),(0,_pickers.attachPicker)({openId:"ai4t-topic-browse",modalId:"ai4t-topic-modal",closeId:"ai4t-topic-modal-close",cancelId:"ai4t-topic-modal-cancel",itemSelector:".ai4t-topic-item",targetId:"id_topic"}),(0,_pickers.attachOutcomesModal)(),(0,_pickers.initLanguageModal)(),(0,_pickers.attachPicker)({openId:"ai4t-purpose-browse",modalId:"ai4t-purpose-modal",closeId:"ai4t-purpose-modal-close",cancelId:"ai4t-purpose-modal-cancel",itemSelector:".ai4t-purpose-item",targetId:"id_purpose"}),(0,_pickers.attachPicker)({openId:"ai4t-audience-browse",modalId:"ai4t-audience-modal",closeId:"ai4t-audience-modal-close",cancelId:"ai4t-audience-modal-cancel",itemSelector:".ai4t-audience-item",targetId:"id_audience"}),(0,_pickers.attachPicker)({openId:"ai4t-classtype-browse",modalId:"ai4t-classtype-modal",closeId:"ai4t-classtype-modal-close",cancelId:"ai4t-classtype-modal-cancel",itemSelector:".ai4t-classtype-item",targetId:"id_classtype"}),(0,_actions.attachCopyDownload)(),initProviderSend()}}));

//# sourceMappingURL=ui.min.js.map