<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Provides the information for backup.
 *
 * @package   bbbext_bnreminders
 * @copyright 2024 onwards, Blindside Networks Inc
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author    Laurent David (laurent@call-learning.fr)
 */
class backup_bbbext_bnreminders_subplugin extends backup_subplugin {

    /**
     * Returns the subplugin information to attach the BigBlueButton instance.
     *
     * @return backup_subplugin_element
     */
    protected function define_bigbluebuttonbn_subplugin_structure() {
        // Create XML elements.
        $subplugin = $this->get_subplugin_element();
        $subpluginwrapper = new backup_nested_element($this->get_recommended_name());

        $subpluginelementmain = new backup_nested_element(
            'bbbext_bnreminders',
            null,
            ['reminderenabled', 'remindertoguestsenabled']
        );
        $subpluginelementreminder = new backup_nested_element(
            'bbbext_bnreminders_rem',
            null,
            ['timespan', 'lastsent']
        );
        $subpluginelementguest = new backup_nested_element('bbbext_bnreminders_guests', ['id'],
            [
                'bigbluebuttonbnid',
                'email',
                'userfrom',
                'issent',
                'isenabled',
                'usermodified',
                'timemodified',
                'timecreated',
            ]);

        // Connect XML elements into the tree.
        $subplugin->add_child($subpluginwrapper);
        $subpluginwrapper->add_child($subpluginelementmain);
        $subpluginwrapper->add_child($subpluginelementreminder);
        $subpluginwrapper->add_child($subpluginelementguest);

        // Set source to populate the data.
        $subpluginelementmain->set_source_table(
            'bbbext_bnreminders',
            ['bigbluebuttonbnid' => backup::VAR_PARENTID]
        );
        $subpluginelementreminder->set_source_table(
            'bbbext_bnreminders_rem',
            ['bigbluebuttonbnid' => backup::VAR_PARENTID]
        );

        // To know if we are including userinfo.
        $userinfo = $this->get_setting_value('userinfo');
        // This source definition only happen if we are including user info.
        if ($userinfo) {
            $subpluginelementguest->set_source_table('bbbext_bnreminders_guests',
                ['bigbluebuttonbnid' => backup::VAR_PARENTID]);
        }
        return $subplugin;
    }
}
