/**
 * Bulk upload JavaScript module for Videoassessment
 *
 * @module     mod_videoassessment/bulkupload
 * @package
 * @copyright  2024 Don Hinkleman (hinkelman@mac.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_videoassessment/bulkupload",["jquery","core/log"],(function($,log){const conf={parallels:2},str={error:"Error",queued:"Queued",uploading:"Uploading",converting:"Converting",complete:"Complete"};function get(id){return document.getElementById(id)}function text(s){return document.createTextNode(s)}function ajax(method,url,params,onComplete,onProgress){const data=new FormData;params&&Object.keys(params).forEach((key=>data.append(key,params[key]))),"undefined"!=typeof M&&M.cfg&&M.cfg.sesskey&&data.append("sesskey",M.cfg.sesskey),data.append("uniq",Date.now());const xhr=new XMLHttpRequest;xhr.open(method,url,!0),onComplete&&(xhr.onreadystatechange=()=>{4===xhr.readyState&&onComplete(xhr.responseText,xhr.status)}),onProgress&&(xhr.upload||xhr).addEventListener("progress",(e=>{onProgress(e.loaded||e.position,e.total||e.totalSize)})),xhr.send(data)}class Status{constructor(cell){this.cell=cell}set(status){!function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}(this.cell),this.cell.appendChild(text(str[status])),this.cell.parentNode.className=status}}Status.ERROR="error",Status.QUEUED="queued",Status.UPLOADING="uploading",Status.CONVERTING="converting",Status.COMPLETE="complete";class Progress{constructor(cell){const table=document.createElement("table"),row=table.insertRow(-1);this.scales=Array.from({length:50},(()=>row.insertCell(-1))),cell.appendChild(table)}set(value){const n=Math.floor(this.scales.length*value/100);this.scales.forEach(((scale,index)=>{scale.className=index<n?"done":""}))}}return{setConfig(name,value){conf[name]=value},setString(name,value){str[name]=value},init(cmid){if(!window.File||!window.XMLHttpRequest||!window.FormData)return void log.debug("Unsupported browser for file upload.");$("#not_supported_browser").hide();const tasklist=get("tasklist");let queue=[],running=0;const startAll=()=>{for(;running<conf.parallels&&queue.length;)queue.shift().start(),running++},stopped=()=>{running--,startAll()};class Task{constructor(file,status,progress){this.file=file,this.status=status,this.progress=progress}isCode(code){return/^[A-Za-z0-9\-\._]+$/.test(code)}refresh(code){ajax("post","ajax.php",{cmid:cmid,code:code},((result,status)=>{if(200===status&&/^\d+$/.test(result)){const percent=parseInt(result,10);this.progress.set(percent),percent>=100?(this.status.set(Status.COMPLETE),stopped()):setTimeout((()=>this.refresh(code)),1e3)}else this.status.set(Status.ERROR),stopped()}))}start(){ajax("post","ajax.php",{cmid:cmid,file:this.file},((result,status)=>{200===status&&this.isCode(result)?(this.status.set(Status.CONVERTING),this.refresh(result)):(this.status.set(Status.ERROR),stopped())}),((loaded,total)=>{this.progress.set(100*loaded/total)})),this.status.set(Status.UPLOADING)}}const add=file=>{const row=tasklist.insertRow(-1),addCell=className=>{const cell=row.insertCell(-1);return cell.className=className,cell};addCell("filename").appendChild(text(file.name)),addCell("filesize").appendChild(text(function(size){const units=["B","KB","MB","GB","TB"];let unit=units.shift();for(;size>=1024&&units.length;)size/=1024,unit=units.shift();return"".concat(size.toFixed(1)," ").concat(unit)}(file.size))),addCell("mimetype").appendChild(text(file.type));const status=new Status(addCell("status")),progress=new Progress(addCell("progress"));queue.push(new Task(file,status,progress)),status.set(Status.QUEUED),startAll()},droparea=get("droparea"),cancel=event=>(event.preventDefault(),event.stopPropagation(),!1);droparea.addEventListener("dragenter",cancel,!1),droparea.addEventListener("dragover",cancel,!1),droparea.addEventListener("drop",(event=>(Array.from(event.dataTransfer.files).forEach((file=>add(file))),cancel(event))),!1);get("fileToUpload").addEventListener("change",(event=>(Array.from(event.target.files).forEach((file=>add(file))),cancel(event))),!1),droparea.style.display="block"}}}));

//# sourceMappingURL=bulkupload.min.js.map