/**
 * Video assessment
 *
 * @package
 * @module     mod_videoassessment/getHTMLMediaElement
 * @copyright  2024 Don Hinkleman (hinkelman@mac.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_videoassessment/getHTMLMediaElement",[],(function(){function myMediaElement(){this.value="Media Element"}return myMediaElement.prototype.getHTMLMediaElement=function(mediaElement,config){config=config||{};const nodeName=mediaElement.nodeName&&mediaElement.nodeName.toLowerCase();if(!nodeName||"audio"!==nodeName&&"video"!==nodeName){if(!mediaElement.getVideoTracks().length)return this.getAudioElement(mediaElement,config);var mediaStream=mediaElement;if("srcObject"in(mediaElement=document.createElement(mediaStream.getVideoTracks().length?"video":"audio")))mediaElement.srcObject=mediaStream;else{const isMoz=!!navigator.mozGetUserMedia,streamURL=isMoz?mediaStream:window.webkitURL.createObjectURL(mediaStream);mediaElement[isMoz?"mozSrcObject":"src"]=streamURL}}if(mediaElement.nodeName&&"audio"==mediaElement.nodeName.toLowerCase())return this.getAudioElement(mediaElement,config);mediaElement.controls=!1;var buttons=config.buttons||["mute-audio","mute-video","full-screen","volume-slider","stop"];buttons.has=function(element){return-1!==buttons.indexOf(element)},config.toggle=config.toggle||[],config.toggle.has=function(element){return-1!==config.toggle.indexOf(element)};var mediaElementContainer=document.createElement("div");mediaElementContainer.className="media-container";var mediaControls=document.createElement("div");if(mediaControls.className="media-controls",mediaElementContainer.appendChild(mediaControls),buttons.has("mute-audio")){var muteAudio=document.createElement("div");muteAudio.className="control "+(config.toggle.has("mute-audio")?"unmute-audio selected":"mute-audio"),mediaControls.appendChild(muteAudio),muteAudio.onclick=function(){-1!=muteAudio.className.indexOf("unmute-audio")?(muteAudio.className=muteAudio.className.replace("unmute-audio selected","mute-audio"),mediaElement.muted=!1,mediaElement.volume=1,config.onUnMuted&&config.onUnMuted("audio")):(muteAudio.className=muteAudio.className.replace("mute-audio","unmute-audio selected"),mediaElement.muted=!0,mediaElement.volume=0,config.onMuted&&config.onMuted("audio"))}}if(buttons.has("mute-video")){var muteVideo=document.createElement("div");muteVideo.className="control "+(config.toggle.has("mute-video")?"unmute-video selected":"mute-video"),mediaControls.appendChild(muteVideo),muteVideo.onclick=function(){-1!=muteVideo.className.indexOf("unmute-video")?(muteVideo.className=muteVideo.className.replace("unmute-video selected","mute-video"),mediaElement.muted=!1,mediaElement.volume=1,mediaElement.play(),config.onUnMuted&&config.onUnMuted("video")):(muteVideo.className=muteVideo.className.replace("mute-video","unmute-video selected"),mediaElement.muted=!0,mediaElement.volume=0,mediaElement.pause(),config.onMuted&&config.onMuted("video"))}}if(buttons.has("take-snapshot")){var takeSnapshot=document.createElement("div");takeSnapshot.className="control take-snapshot",mediaControls.appendChild(takeSnapshot),takeSnapshot.onclick=function(){config.onTakeSnapshot&&config.onTakeSnapshot()}}if(buttons.has("stop")){var stop=document.createElement("div");stop.className="control stop",mediaControls.appendChild(stop),stop.onclick=function(){mediaElementContainer.style.opacity=0,setTimeout((function(){mediaElementContainer.parentNode&&mediaElementContainer.parentNode.removeChild(mediaElementContainer)}),800),config.onStopped&&config.onStopped()}}var volumeControl=document.createElement("div");if(volumeControl.className="volume-control",buttons.has("record-audio")){var recordAudio=document.createElement("div"),recAudSelc="stop-recording-audio selected";recordAudio.className="control "+(config.toggle.has("record-audio")?recAudSelc:"record-audio"),volumeControl.appendChild(recordAudio),recordAudio.onclick=function(){-1!=recordAudio.className.indexOf("stop-recording-audio")?(recordAudio.className=recordAudio.className.replace(recAudSelc,"record-audio"),config.onRecordingStopped&&config.onRecordingStopped("audio")):(recordAudio.className=recordAudio.className.replace("record-audio",recAudSelc),config.onRecordingStarted&&config.onRecordingStarted("audio"))}}if(buttons.has("record-video")){var recordVideo=document.createElement("div"),recVidSelc="stop-recording-video selected";recordVideo.className="control "+(config.toggle.has("record-video")?recVidSelc:"record-video"),volumeControl.appendChild(recordVideo),recordVideo.onclick=function(){-1!=recordVideo.className.indexOf("stop-recording-video")?(recordVideo.className=recordVideo.className.replace(recVidSelc,"record-video"),config.onRecordingStopped&&config.onRecordingStopped("video")):(recordVideo.className=recordVideo.className.replace("record-video",recVidSelc),config.onRecordingStarted&&config.onRecordingStarted("video"))}}if(buttons.has("volume-slider")){var volumeSlider=document.createElement("div");volumeSlider.className="control volume-slider",volumeControl.appendChild(volumeSlider);var slider=document.createElement("input");slider.type="range",slider.min=0,slider.max=100,slider.value=100,slider.onchange=function(){mediaElement.volume="."+slider.value.toString().substr(0,1)},volumeSlider.appendChild(slider)}if(buttons.has("full-screen")){var zoom=document.createElement("div");zoom.className="control "+(config.toggle.has("zoom-in")?"zoom-out selected":"zoom-in"),slider||recordAudio||recordVideo||!zoom?volumeControl.appendChild(zoom):mediaControls.insertBefore(zoom,mediaControls.firstChild),zoom.onclick=function(){-1!=zoom.className.indexOf("zoom-out")?(zoom.className=zoom.className.replace("zoom-out selected","zoom-in"),exitFullScreen()):(zoom.className=zoom.className.replace("zoom-in","zoom-out selected"),launchFullscreen(mediaElementContainer))};const launchFullscreen=function(element){element.requestFullscreen?element.requestFullscreen():element.mozRequestFullScreen?element.mozRequestFullScreen():element.webkitRequestFullscreen&&element.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT)},exitFullScreen=function(){document.fullscreen&&document.cancelFullScreen(),document.mozFullScreen&&document.mozCancelFullScreen(),document.webkitIsFullScreen&&document.webkitCancelFullScreen()},screenStateChange=function(e){if(e.srcElement==mediaElementContainer){var isFullScreeMode=document.webkitIsFullScreen||document.mozFullScreen||document.fullscreen;mediaElementContainer.style.width=(isFullScreeMode?window.innerWidth-20:config.width)+"px",mediaElementContainer.style.display=isFullScreeMode?"block":"inline-block",config.height&&(mediaBox.style.height=(isFullScreeMode?window.innerHeight-20:config.height)+"px"),!isFullScreeMode&&config.onZoomout&&config.onZoomout(),isFullScreeMode&&config.onZoomin&&config.onZoomin(),isFullScreeMode||-1==zoom.className.indexOf("zoom-out")||(zoom.className=zoom.className.replace("zoom-out selected","zoom-in"),config.onZoomout&&config.onZoomout()),setTimeout(adjustControls,1e3)}};document.addEventListener("fullscreenchange",screenStateChange,!1),document.addEventListener("mozfullscreenchange",screenStateChange,!1),document.addEventListener("webkitfullscreenchange",screenStateChange,!1)}["volume-slider","full-screen","record-audio","record-video"].some(buttons.has)&&mediaElementContainer.appendChild(volumeControl);var mediaBox=document.createElement("div");if(mediaBox.className="media-box",mediaElementContainer.appendChild(mediaBox),config.title){var h2=document.createElement("h2");h2.innerHTML=config.title,h2.setAttribute("style","\n                position:absolute;\n                color:white;\n                font-size:17px;\n                text-shadow:1px 1px black;\n                padding:0;\n                margin:0;\n                text-align:left;\n                margin-top:10px;\n                margin-left:10px;\n                display:block;\n                border:0;\n                line-height:1.5;\n                z-index:1;\n            "),mediaBox.appendChild(h2)}mediaBox.appendChild(mediaElement),config.width||(config.width=innerWidth/2-50),mediaElementContainer.style.width=config.width+"px",config.height&&(mediaBox.style.height=config.height+"px"),mediaBox.querySelector("video").style.maxHeight=innerHeight+"px";var times=0;function adjustControls(){mediaControls.style.marginLeft=mediaElementContainer.clientWidth-mediaControls.clientWidth-2+"px",slider?(slider.style.width=mediaElementContainer.clientWidth/3+"px",volumeControl.style.marginLeft=mediaElementContainer.clientWidth/3-30+"px",zoom&&(zoom.style["border-top-right-radius"]="5px")):volumeControl.style.marginLeft=mediaElementContainer.clientWidth-volumeControl.clientWidth-2+"px",volumeControl.style.marginTop=mediaElementContainer.clientHeight-volumeControl.clientHeight-2+"px",times<10?(times++,setTimeout(adjustControls,1e3)):times=0}return config.showOnMouseEnter||void 0===config.showOnMouseEnter?(mediaElementContainer.onmouseenter=mediaElementContainer.onmousedown=function(){adjustControls(),mediaControls.style.opacity=1,volumeControl.style.opacity=1},mediaElementContainer.onmouseleave=function(){mediaControls.style.opacity=0,volumeControl.style.opacity=0}):setTimeout((function(){adjustControls(),setTimeout((function(){mediaControls.style.opacity=1,volumeControl.style.opacity=1}),300)}),700),adjustControls(),mediaElementContainer.toggle=function(clasName){if("string"==typeof clasName)return"mute-audio"==clasName&&muteAudio&&muteAudio.onclick(),"mute-video"==clasName&&muteVideo&&muteVideo.onclick(),"record-audio"==clasName&&recordAudio&&recordAudio.onclick(),"record-video"==clasName&&recordVideo&&recordVideo.onclick(),"stop"==clasName&&stop&&stop.onclick(),this;for(var i=0;i<clasName.length;i++)mediaElementContainer.toggle(clasName[i])},mediaElementContainer.media=mediaElement,mediaElementContainer},myMediaElement.prototype.getAudioElement=function(mediaElement,config){config=config||{};const nodeName=mediaElement.nodeName&&mediaElement.nodeName.toLowerCase();if(!nodeName||"audio"!==nodeName&&"video"!==nodeName){var mediaStream=mediaElement;if("srcObject"in(mediaElement=document.createElement("audio")))mediaElement.mediaElement=mediaStream;else{const isMoz=!!navigator.mozGetUserMedia;mediaElement[isMoz?"mozSrcObject":"src"]=isMoz?mediaStream:window.webkitURL.createObjectURL(mediaStream)}}config.toggle=config.toggle||[],config.toggle.has=function(element){return-1!==config.toggle.indexOf(element)},mediaElement.controls=!1,mediaElement.play();var mediaElementContainer=document.createElement("div");mediaElementContainer.className="media-container";var mediaControls=document.createElement("div");mediaControls.className="media-controls",mediaElementContainer.appendChild(mediaControls);var muteAudio=document.createElement("div");if(muteAudio.className="control "+(config.toggle.has("mute-audio")?"unmute-audio selected":"mute-audio"),mediaControls.appendChild(muteAudio),muteAudio.style["border-top-left-radius"]="5px",muteAudio.onclick=function(){-1!=muteAudio.className.indexOf("unmute-audio")?(muteAudio.className=muteAudio.className.replace("unmute-audio selected","mute-audio"),mediaElement.muted=!1,config.onUnMuted&&config.onUnMuted("audio")):(muteAudio.className=muteAudio.className.replace("mute-audio","unmute-audio selected"),mediaElement.muted=!0,config.onMuted&&config.onMuted("audio"))},!config.buttons||config.buttons&&-1!=config.buttons.indexOf("record-audio")){var recordAudio=document.createElement("div"),recordingClass="stop-recording-audio selected";recordAudio.className="control "+(config.toggle.has("record-audio")?recordingClass:"record-audio"),mediaControls.appendChild(recordAudio),recordAudio.onclick=function(){-1!=recordAudio.className.indexOf("stop-recording-audio")?(recordAudio.className=recordAudio.className.replace(recordingClass,"record-audio"),config.onRecordingStopped&&config.onRecordingStopped("audio")):(recordAudio.className=recordAudio.className.replace("record-audio",recordingClass),config.onRecordingStarted&&config.onRecordingStarted("audio"))}}var volumeSlider=document.createElement("div");volumeSlider.className="control volume-slider",volumeSlider.style.width="auto",mediaControls.appendChild(volumeSlider);var slider=document.createElement("input");slider.style.marginTop="11px",slider.style.width=" 200px",config.buttons&&-1==config.buttons.indexOf("record-audio")&&(slider.style.width=" 241px"),slider.type="range",slider.min=0,slider.max=100,slider.value=100,slider.onchange=function(){mediaElement.volume="."+slider.value.toString().substr(0,1)},volumeSlider.appendChild(slider);var stop=document.createElement("div");stop.className="control stop",mediaControls.appendChild(stop),stop.onclick=function(){mediaElementContainer.style.opacity=0,setTimeout((function(){mediaElementContainer.parentNode&&mediaElementContainer.parentNode.removeChild(mediaElementContainer)}),800),config.onStopped&&config.onStopped()},stop.style["border-top-right-radius"]="5px",stop.style["border-bottom-right-radius"]="5px";var mediaBox=document.createElement("div");mediaBox.className="media-box",mediaElementContainer.appendChild(mediaBox);var h2=document.createElement("h2");h2.innerHTML=config.title||"Audio Element",h2.setAttribute("style","\n            position:absolute;\n            color:rgb(160, 160, 160);\n            font-size: 20px;\n            text-shadow: 1px 1px rgb(255, 255, 255);\n            padding:0;\n            margin:0;\n        "),mediaBox.appendChild(h2),mediaBox.appendChild(mediaElement),mediaElementContainer.style.width="329px",mediaBox.style.height="90px",h2.style.width=mediaElementContainer.style.width,h2.style.height="50px",h2.style.overflow="hidden";var times=0;function adjustControls(){mediaControls.style.marginLeft=mediaElementContainer.clientWidth-mediaControls.clientWidth-7+"px",mediaControls.style.marginTop=mediaElementContainer.clientHeight-mediaControls.clientHeight-6+"px",times<10?(times++,setTimeout(adjustControls,1e3)):times=0}return config.showOnMouseEnter||void 0===config.showOnMouseEnter?(mediaElementContainer.onmouseenter=mediaElementContainer.onmousedown=function(){adjustControls(),mediaControls.style.opacity=1},mediaElementContainer.onmouseleave=function(){mediaControls.style.opacity=0}):setTimeout((function(){adjustControls(),setTimeout((function(){mediaControls.style.opacity=1}),300)}),700),adjustControls(),mediaElementContainer.toggle=function(clasName){if("string"==typeof clasName)return"mute-audio"==clasName&&muteAudio&&muteAudio.onclick(),"record-audio"==clasName&&recordAudio&&recordAudio.onclick(),"stop"==clasName&&stop&&stop.onclick(),this;for(var i=0;i<clasName.length;i++)mediaElementContainer.toggle(clasName[i])},mediaElementContainer.media=mediaElement,mediaElementContainer},myMediaElement}));

//# sourceMappingURL=getHTMLMediaElement.min.js.map