// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Video assessment
 *
 * @module mod_videoassessment/utils
 * @package
 * @copyright  2024 Don Hinkleman (hinkelman@mac.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define([], function () {
    return {

        /**
         * Generates a secure random string.
         * @returns {string}
         */
        getRandomString() {
            if (window.crypto && window.crypto.getRandomValues) {
                const array = window.crypto.getRandomValues(new Uint32Array(3));
                return Array.from(array).map(v => v.toString(36)).join('');
            }
            return (Math.random() * Date.now()).toString(36);
        },

        /**
         * Generates a unique filename.
         * @param {string} extension
         * @returns {string}
         */
        getFileName(extension = 'webm') {
            const now = new Date();
            const prefix = `RecordRTC-${now.getUTCFullYear()}${now.getUTCMonth()}${now.getUTCDate()}`;
            return `${prefix}-${this.getRandomString()}.${extension}`;
        },

        /**
         * Converts an object to a string.
         * @param {Object} obj
         * @returns {string}
         */
        stringify(obj) {
            return Object.entries(obj)
                .filter(entry => typeof entry[1] !== 'function')
                .map(([key, value]) => `${key}: ${value}`)
                .join(', ');
        }
    };
});
