# Bootstrap Migration Filter (bsmigrate)

A Moodle text filter that automatically migrates Bootstrap 4 CSS classes and data attributes to their Bootstrap 5 equivalents during HTML content rendering.

## Purpose

This filter addresses the challenge of migrating from Bootstrap 4 to Bootstrap 5 by automatically translating deprecated Bootstrap 4 classes and data attributes to their Bootstrap 5 counterparts. It processes HTML content in real-time, making it invaluable during the transition period when content may contain a mix of Bootstrap 4 and Bootstrap 5 syntax.

## Features

- **Comprehensive Class Translation**: Translates 130+ Bootstrap 4 classes to Bootstrap 5 equivalents
- **Data Attribute Processing**: Updates Bootstrap 4 data attributes (`data-toggle`, `data-target`, etc.) to Bootstrap 5 format (`data-bs-*`)
- **Case-Insensitive Processing**: Handles class names regardless of case
- **Duplicate Class Handling**: Automatically deduplicates classes after translation
- **Performance Optimized**: Skips processing when no Bootstrap classes are detected
- **Comprehensive Coverage**: Includes all major Bootstrap components and utility classes

## Scope

### CSS Classes Covered

The filter translates classes across all major Bootstrap categories:

#### Layout & Spacing
- **Margin/Padding**: `ml-*` → `ms-*`, `mr-*` → `me-*`, `pl-*` → `ps-*`, `pr-*` → `pe-*`
- **Responsive Spacing**: All breakpoints (sm, md, lg, xl, xxl) with auto margins
- **Grid System**: `no-gutters` → `g-0`

#### Typography & Alignment
- **Text Alignment**: `text-left/right` → `text-start/end`
- **Font Weights**: `font-weight-*` → `fw-*`
- **Font Style**: `font-italic` → `fst-italic`

#### Components
- **Forms**: `custom-control*` → `form-check*`, `custom-select` → `form-select`
- **Buttons**: `btn-block` → `d-grid`, `close` → `btn-close`
- **Badges**: `badge-primary` → `bg-primary`, `badge-pill` → `rounded-pill`
- **Media Object**: `media` → `d-flex`, `media-body` → `flex-grow-1 ms-3`
- **Cards**: `card-deck` → `row row-cols-1 row-cols-md-3 g-4`

#### Utilities
- **Float**: `float-left/right` → `float-start/end`
- **Borders**: `border-left/right` → `border-start/end`
- **Rounded**: `rounded-left/right` → `rounded-start/end`
- **Visibility**: `sr-only` → `visually-hidden`

#### Deprecated Components
- **Jumbotron**: `jumbotron` → `bg-light p-5 rounded-3`
- **Form Controls**: `form-control-file` → `form-control`
- **Input Groups**: `input-group-prepend/append` → `input-group-text`
- **Dropdowns**: `dropdown-menu-right` → `dropdown-menu-end`

### Data Attributes Covered

Bootstrap 4 data attributes are updated to Bootstrap 5 format:
- `data-toggle` → `data-bs-toggle`
- `data-target` → `data-bs-target`
- `data-dismiss` → `data-bs-dismiss`
- `data-slide` → `data-bs-slide`
- `data-parent` → `data-bs-parent`
- `data-spy` → `data-bs-spy`
- And 10+ more data attributes

## Installation

### Automatic Installation (Recommended)

1. Download the plugin package
2. Go to **Site Administration** → **Plugins** → **Install plugins**
3. Upload the plugin package
4. Follow the installation prompts

### Manual Installation

1. Extract the plugin files to your Moodle installation:
   ```bash
   cd /path/to/moodle
   cp -r bsmigrate filter/
   ```

2. Visit your Moodle site as an administrator to trigger the installation process

3. Complete the installation through the web interface

## Configuration

### Enabling the Filter

1. Navigate to **Site Administration** → **Plugins** → **Filters** → **Manage filters**
2. Find "Bsmigrate" in the filter list
3. Set it to "On" or "Off but available"
4. Configure the contexts where it should be active:
   - **System**: Apply globally
   - **Course categories**: Apply to specific categories
   - **Courses**: Apply to individual courses
   - **Activities**: Apply to specific activities

### Filter Order

The Bootstrap Migration filter should typically be placed:
- **After** content filters that might generate HTML
- **Before** theme-specific filters
- **Before** the final HTML cleanup filters

### Performance Considerations

- The filter automatically skips content without Bootstrap classes
- Enable only in contexts where Bootstrap 4 content exists
- Consider disabling after migration is complete

## Usage Examples

### Before (Bootstrap 4)
```html
<div class="container ml-3 mr-auto">
    <div class="row no-gutters">
        <div class="col-md-6 text-left">
            <button class="btn btn-primary float-right ml-2"
                    data-toggle="modal"
                    data-target="#myModal">
                Open Modal
            </button>
        </div>
    </div>
</div>
```

### After (Bootstrap 5)
```html
<div class="container ms-3 me-auto">
    <div class="row g-0">
        <div class="col-md-6 text-start">
            <button class="btn btn-primary float-end ms-2"
                    data-bs-toggle="modal"
                    data-bs-target="#myModal">
                Open Modal
            </button>
        </div>
    </div>
</div>
```

## Technical Information

### System Requirements

- **Moodle Version**: 5.0+ (requires 2024100700)
- **PHP Version**: 8.2+ (as per Moodle requirements)
- **Bootstrap Version**: Designed for Bootstrap 4 → 5 migration

### Architecture

- **Main Filter Class**: `filter_bsmigrate\text_filter`
- **Translation Engine**: `filter_bsmigrate\bs_translator`
- **Processing Method**: Regex-based pattern matching with case-insensitive handling

### Performance Characteristics

- **Early Exit**: Skips processing if no Bootstrap classes detected
- **Regex Optimization**: Uses efficient patterns for class and attribute matching
- **Memory Efficient**: Processes content in-place without creating large intermediate arrays

## Testing

The plugin includes comprehensive PHPUnit tests:

```bash
# Run all tests
vendor/bin/phpunit filter/bsmigrate/tests/

# Run specific test suites
vendor/bin/phpunit filter/bsmigrate/tests/text_filter_test.php
vendor/bin/phpunit filter/bsmigrate/tests/bs_translator_test.php
```

### Test Coverage
- **70 Total Tests**: 50 text filter tests + 20 translator tests
- **980+ Assertions**: Comprehensive coverage of all class mappings
- **Component Testing**: Tests for forms, navigation, utilities, and deprecated components
- **Edge Cases**: Handles mixed case, duplicate classes, and complex HTML structures

## Troubleshooting

### Common Issues

1. **Classes not being translated**
   - Verify the filter is enabled in the correct context
   - Check that the content actually contains Bootstrap 4 classes
   - Ensure filter order allows proper processing

2. **Performance concerns**
   - Limit filter scope to relevant contexts only
   - Monitor server performance after enabling

3. **Unexpected results**
   - Check for CSS conflicts between Bootstrap 4 and 5
   - Verify theme compatibility with Bootstrap 5

### Debugging

Enable Moodle debugging to see filter processing information:
```php
$CFG->debug = DEBUG_DEVELOPER;
$CFG->debugdisplay = 1;
```

## Contributing

### Development Setup

1. Clone the repository into your Moodle filter directory
2. Run the test suite to ensure everything works:
   ```bash
   vendor/bin/phpunit filter/bsmigrate/tests/
   ```

### Code Standards

The plugin follows Moodle coding standards:
- PSR-4 autoloading with `filter_bsmigrate` namespace
- Comprehensive PHPDoc documentation
- PHPCS compliance for code formatting
- Comprehensive unit test coverage

### Adding New Mappings

To add new class mappings:

1. Update the `$classmappings` array in `classes/bs_translator.php`
2. Add corresponding tests in `tests/bs_translator_test.php`
3. Run tests to ensure functionality
4. Update this README with new mappings

## License

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

## Author

**Bas Brands** - [Sonsbeekmedia](mailto:bas@sonsbeekmedia.nl)

## Version Information

- **Current Version**: 1.0
- **Release Date**: September 2025
- **Moodle Compatibility**: 5.0+

## Support

For issues, feature requests, or contributions, please contact the author or submit issues through the appropriate channels for your Moodle installation.

---

*This filter is designed to facilitate the Bootstrap 4 to 5 migration process. Once your content has been fully migrated to Bootstrap 5, this filter can be safely disabled to improve performance.*
