define("mod_board/board",["exports","jquery","core/str","core/ajax","core/modal_factory","core/modal_events","core/notification","mod_board/jquery.editable.amd","mod_board/jquery.sortable.amd","core/fragment","mod_board/comments","./movenotesdialog","./movecolumnsdialog"],(function(_exports,_jquery,_str,_ajax,_modal_factory,_modal_events,_notification,_jqueryEditable,_jquerySortable,_fragment,_comments,_movenotesdialog,_movecolumnsdialog){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A javascript module to handle the board.
   *
   * @author     Karen Holland <karen@brickfieldlabs.ie>
   * @copyrigt   2021 Brickfield Education Labs <https://www.brickfield.ie/>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=function(settings){var strings={default_column_heading:"",post_button_text:"",cancel_button_text:"",remove_note_title:"",remove_note_text:"",remove_column_title:"",note_changed_title:"",note_changed_text:"",note_deleted_text:"",rate_note_title:"",rate_note_text:"",rate_remove_note_text:"",Ok:"",delete:"",Cancel:"",warning:"",modal_title_new:"",modal_title_edit:"",option_youtube:"",option_image:"",option_link:"",aria_newcolumn:"",aria_newpost:"",aria_deletecolumn:"",aria_movecolumn:"",aria_deletepost:"",aria_movepost:"",aria_editpost:"",aria_addmedia:"",aria_addmedianew:"",aria_deleteattachment:"",aria_postedit:"",aria_canceledit:"",aria_postnew:"",aria_cancelnew:"",aria_ratepost:"",invalid_file_extension:"",invalid_file_size_min:"",invalid_file_size_max:"",invalid_youtube_url:""},options=JSON.parse(settings.settings)||{},board=options.board||{},contextid=options.contextid;var reloadTimer=null,lastHistoryId=null,isEditor=options.isEditor||!1,usersCanEdit=options.usersCanEdit,userId=parseInt(options.userId)||-1,ownerId=parseInt(options.ownerId),mediaSelection=options.mediaselection||1,editingNote=0,isReadOnlyBoard=options.readonly||!1,ratingenabled=options.ratingenabled,sortby=options.sortby||1,editModal=null,enableblanktarget=1===parseInt(options.enableblanktarget),serviceCall=function(method,args,callback,failcallback){"board_history"!==method&&stopUpdating(),function(method,args,callback,failcallback){_ajax.default.call([{methodname:"mod_board_"+method,args:args,done:function(data){callback(data)},fail:function(error){_notification.default.exception(error),failcallback&&failcallback(error)}}])}(method,args,(function(){callback&&callback.apply(null,arguments),"board_history"!==method&&"get_board"!=method&&updateBoard(!0)}),failcallback)},getNote=function(ident){return(0,_jquery.default)(".board_note[data-ident='"+ident+"']")},getNoteTextForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_text")},getNoteHeadingForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_heading")},getNoteBorderForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_border")},getNoteAttachmentsForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_attachment")},textIdentifierForNote=function(note){var noteText=getNoteTextForNote(note).html(),noteHeading=getNoteHeadingForNote(note).html(),noteAttachment=attachmentDataForNote(note);return noteHeading.length>0?noteHeading:noteText.length>0?noteText.replace(/<br\s*\/?>/gi," ").replace(/\n/g," ").split(/\s+/).slice(0,5).join(" "):noteAttachment.info&&noteAttachment.info.length>0?noteAttachment.info:null},updateNoteAria=function(noteId){var note=getNote(noteId),columnIdentifier=note.closest(".board_column").find(".mod_board_column_name").text();if(noteId){var noteIdentifier=textIdentifierForNote(note),deleteNoteString=strings.aria_deletepost.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier);note.find(".delete_note").attr("aria-label",deleteNoteString).attr("title",deleteNoteString);var moveNoteString=strings.aria_movepost.replace("{post}",noteIdentifier);note.find(".move_note").attr("aria-label",moveNoteString).attr("title",moveNoteString);var editNoteString=strings.aria_editpost.replace("{post}",noteIdentifier);note.find(".edit_note").attr("aria-label",editNoteString).attr("title",editNoteString),note.find(".mod_board_rating").attr("aria-label",strings.aria_ratepost.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier)),note.find(".note_ariatext").html(noteIdentifier)}},updateColumnAria=function(columnId){var column=(0,_jquery.default)(".board_column[data-ident="+columnId+"]"),columnIdentifier=column.find(".mod_board_column_name").text(),newNoteString=strings.aria_newpost.replace("{column}",columnIdentifier),moveColumnString=strings.aria_movecolumn.replace("{column}",columnIdentifier),deleteColumnString=strings.aria_deletecolumn.replace("{column}",columnIdentifier);column.find(".newnote").attr("aria-label",newNoteString).attr("title",newNoteString),column.find(".mod_column_move").attr("aria-label",moveColumnString).attr("title",moveColumnString),column.find(".delete_column").attr("aria-label",deleteColumnString).attr("title",deleteColumnString),column.find(".board_note").each((function(index,note){updateNoteAria((0,_jquery.default)(note).data("ident"))}))},stopNoteEdit=function(){if(editingNote){var note=getNote(editingNote);if(note){var noteHeading=getNoteHeadingForNote(note),noteText=getNoteTextForNote(note),noteBorder=getNoteBorderForNote(note);noteHeading.show(),noteBorder.show(),noteText.show(),noteHeading.html()||(noteHeading.hide(),noteBorder.hide()),!noteText.html()&&noteHeading.html()&&(noteText.hide(),noteBorder.hide())}editingNote=0}else getNote(0).remove()};const sortAfterDelete=(columnID,sortorder)=>{let column=(columnID=>(0,_jquery.default)(".board_column[data-ident='".concat(columnID,"'] .board_column_content")))(columnID);column.children().filter(((_,element)=>parseInt((0,_jquery.default)(element).data("sortorder"))>parseInt(sortorder))).each(((_,element)=>{let so=(0,_jquery.default)(element).data("sortorder");(0,_jquery.default)(element).data("sortorder",so-1)}))};var setAttachment=function(note,attachment){var noteAttachment=getNoteAttachmentsForNote(note);if(noteAttachment){attachment?attachment.type+="":attachment={type:"0"};var attType=noteAttachment.find(".mod_board_type");attType.val(attachment.type?attachment.type:"0"),attType.val()>"0"&&(noteAttachment.find(".info").val(decodeText(attachment.info)),noteAttachment.find(".url").val(decodeText(attachment.url))),function(note){var noteAttachment=getNoteAttachmentsForNote(note),type=noteAttachment.find(".mod_board_type").val(),attachmentInfo=noteAttachment.find(".info"),attachmentUrl=noteAttachment.find(".url"),attachmentFile=noteAttachment.find(".mod_board_file");type>"0"?(attachmentInfo.prop("placeholder",strings["option_"+attachmentTypeToString(type)+"_info"]),attachmentUrl.prop("placeholder",strings["option_"+attachmentTypeToString(type)+"_url"]),attachmentInfo.show(),2==type&&FileReader?(attachmentFile.show(),attachmentUrl.hide()):(attachmentFile.hide(),attachmentUrl.show())):(attachmentInfo.hide(),attachmentUrl.hide(),attachmentFile.hide(),attachmentInfo.val(""),attachmentUrl.val(""))}(note)}previewAttachment(note,attachment)},attachmentDataForNote=function(note){var attachment={type:0,info:null,url:null,filename:null,filecontents:null},noteAttachment=getNoteAttachmentsForNote(note);if(noteAttachment.length){attachment.type=noteAttachment.find(".mod_board_type").val(),attachment.info=encodeText(noteAttachment.find(".info").val()),attachment.url=encodeText(noteAttachment.find(".url").val());var fileElem=noteAttachment.find(".mod_board_file>input");fileElem.data("filename")&&(attachment.filename=fileElem.data("filename"),attachment.filecontents=fileElem.data("filecontents"))}return attachment.info&&attachment.info.length||attachment.url&&attachment.url.length||attachment.filename||(attachment.type=0),attachment},attachmentTypeToString=function(type){switch(type){case"1":return"youtube";case"2":return"image";case"3":return"link";default:return null}};var previewAttachment=function(note,attachment){var elem=note.find(".mod_board_preview");if(attachment||(attachment=attachmentDataForNote(note)),getNoteTextForNote(note).html().length?elem.removeClass("mod_board_notext"):elem.addClass("mod_board_notext"),elem.removeClass("wrapper_youtube"),elem.removeClass("wrapper_image"),elem.removeClass("wrapper_url"),attachment.filename&&2==parseInt(attachment.type))elem.html('<img src="'.concat(attachment.filecontents,'" alt="').concat(attachment.info,'"\n                class="mod_board_preview_element"/>')),elem.addClass("wrapper_image"),elem.show();else if(attachment.url){const blanktarget=enableblanktarget?' target="_blank"':"";switch(parseInt(attachment.type)){case 1:{let url=(url=>{let videoID=url.match(/(\/|%3D|v=)([0-9A-z-_]{11})([%#?&]|$)/);return videoID&&void 0!==videoID[2]&&11===videoID[2].length?"https://www.youtube-nocookie.com/embed/".concat(videoID[2]):null})(attachment.url);null===url?elem.html(strings.invalid_youtube_url):(elem.html('<iframe src="'+url+'" class="mod_board_preview_element" frameborder="0" allow="accelerometer; autoplay; clipboard-write;encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe><a href="#" class="stretched-link" aria-hidden="true"></a>'),elem.addClass("wrapper_youtube").addClass("position-relative")),elem.show()}break;case 2:elem.html('<img src="'.concat(attachment.url,'" alt="').concat(attachment.info,'"\n                        class="mod_board_preview_element"/>')),elem.addClass("wrapper_image"),elem.show();break;case 3:elem.html('<a href="'+attachment.url+'" class="mod_board_preview_element"'+blanktarget+">"+(attachment.info||attachment.url)+"</a>"),elem.addClass("wrapper_url"),elem.show();break;default:elem.html(""),elem.hide()}}else elem.html(""),elem.hide()},addNote=function(columnid,ident,heading,content,attachment,owner,sortorder,rating){var ismynote=owner.id==userId||!ident,iseditable=isEditor||ismynote&&!isReadOnlyBoard;if(!ident){var pendingNote=getNote(0);pendingNote&&pendingNote.remove()}if(3==sortby){(0,_jquery.default)(".board_column[data-ident='".concat(columnid,"'] .board_column_content")).children().filter(((_,element)=>parseInt((0,_jquery.default)(element).data("sortorder"))>=parseInt(sortorder))).each(((_,element)=>{let so=(0,_jquery.default)(element).data("sortorder");(0,_jquery.default)(element).data("sortorder",so+1)}))}var note=(0,_jquery.default)('<div class="board_note" data-column="'+columnid+'" data-ident="'+ident+'" data-sortorder="'+sortorder+'"></div>');ismynote&&note.addClass("mod_board_mynote"),iseditable&&note.addClass("mod_board_editablenote"),ismynote||iseditable||note.addClass("mod_board_nosort");var notecontent=(0,_jquery.default)('<div class="mod_board_note_content"></div>'),notecontrols=(0,_jquery.default)('<div class="mod_board_note_controls"></div>'),noteHeading=(0,_jquery.default)('<div class="mod_board_note_heading" tabindex="0">'+(heading||"")+"</div>"),noteBorder=(0,_jquery.default)('<div class="mod_board_note_border"></div>'),noteText=(0,_jquery.default)('<div class="mod_board_note_text" tabindex="0">'+(content||"")+"</div>"),noteAriaText=(0,_jquery.default)('<div class="note_ariatext hidden" role="heading" aria-level="4" tabindex="0"></div>'),attachmentPreview=(0,_jquery.default)('<div class="mod_board_preview"></div>');notecontent.append(noteHeading),notecontent.append(noteBorder),notecontent.append(noteText),notecontent.append(noteAriaText),notecontent.append(attachmentPreview),note.append(notecontent);var columnContent=(0,_jquery.default)(".board_column[data-ident="+columnid+"] .board_column_content"),beginEdit=()=>{!function(ident){if(editingNote){if(editingNote==ident)return;stopNoteEdit()}if(ident){var pendingNote=getNote(0);pendingNote&&pendingNote.remove()}var note=getNote(ident);note&&(showModalForm(note),ident&&(editingNote=ident))}(ident)};if(ident){if(ratingenabled){note.addClass("mod_board_rateablenote");var rateElement=(0,_jquery.default)('<div class="fa fa-star mod_board_rating" role="button" tabindex="0"> '.concat(rating," </div>"));handleAction(rateElement,(()=>{!function(ident){if(ratingenabled&&!isReadOnlyBoard){var note=getNote(ident),rating=note.find(".mod_board_rating");rating.data("disabled")||(rating.data("disabled",!0),serviceCall("can_rate_note",{id:ident},(function(result){if(result.canrate){const rateRemoveText=result.hasrated?strings.rate_remove_note_text:strings.rate_note_text;_notification.default.confirm(strings.rate_note_title,rateRemoveText,strings.Ok,strings.Cancel,(function(){serviceCall("rate_note",{id:ident},(function(result){result.status&&(lastHistoryId=result.historyid,rating.html(" ".concat(result.rating," ")),2==sortby&&sortNotes(note.closest(".board_column_content"))),rating.data("disabled",!1)}))})).then((function(rateModal){rateModal.getRoot().on(_modal_events.default.hidden,(function(){rating.data("disabled",!1)}))}))}})))}}(ident)})),notecontrols.append(rateElement)}if(iseditable){var removeElement=(0,_jquery.default)('<div class="fa fa-remove delete_note" role="button" tabindex="0"></div>');if(handleAction(removeElement,(()=>{!function(ident){_notification.default.confirm(strings.remove_note_title,strings.remove_note_text,strings.delete,strings.Cancel,(function(){serviceCall("delete_note",{id:ident},(function(result){if(result.status){lastHistoryId=result.historyid;let note=getNote(ident);if(3==sortby){let columnID=note.data("column"),sortorder=note.data("sortorder");sortAfterDelete(columnID,sortorder)}note.remove()}}))}))}(ident)})),notecontrols.append(removeElement),1==usersCanEdit||isEditor){var moveElement=(0,_jquery.default)('<div class="mod_board_move fa fa-arrows move_note" role="button" tabindex="0"></div>');notecontrols.append(moveElement),_movenotesdialog.default.init(ownerId,moveNote)}var editElement=(0,_jquery.default)('<div class="mod_board_move fa fa-pencil edit_note" role="button" tabindex="0"></div>');notecontrols.append(editElement),handleAction(editElement,(()=>{beginEdit()})),updateSortable(),setAttachment(note,attachment)}else previewAttachment(note,attachment);note.append(notecontrols),handleAction(notecontent,(()=>fullScreenNote(ident,notecontent))),noteHeading.html()||(noteHeading.hide(),noteBorder.hide()),!noteText.html()&&noteHeading.html()&&(noteText.hide(),noteBorder.hide());var lastOne=columnContent.find(".board_note").last();lastOne.length?note.insertAfter(lastOne):columnContent.prepend(note)}else(0,_jquery.default)(".board_column[data-ident="+columnid+"] .board_column_newcontent").append(note),note.hide(),beginEdit()},addColumn=function(ident,name,locked,notes,colour){let headerStyle='style="border-top: 10px solid #'.concat(colour,'"');var iseditable=isEditor,nameCache=null,column=(0,_jquery.default)('<div class="board_column board_column_hasdata" data-locked="'.concat(locked,'"                 ').concat(headerStyle,' data-ident="').concat(ident,'"></div>')),columnHeader=(0,_jquery.default)('<div class="board_column_header"></div>'),columnSort=(0,_jquery.default)('<div class="mod_board_column_sort fa"></div>'),columnName=(0,_jquery.default)('<div class="mod_board_column_name" tabindex="0" aria-level="3" role="heading">'+name+"</div>"),columnContent=(0,_jquery.default)('<div class="board_column_content"></div>'),columnNewContent=(0,_jquery.default)('<div class="board_column_newcontent"></div>');if(3!=sortby&&columnHeader.append(columnSort),columnHeader.append(columnName),options.hideheaders&&columnName.addClass("d-none"),columnSort.on("click",(function(){sortNotes(columnContent,!0)})),iseditable){column.addClass("mod_board_editablecolumn");const lockIcon=locked?"fa-lock":"fa-unlock",lockElement=(0,_jquery.default)('<div class="icon fa '.concat(lockIcon,' lock_column" role="button" tabindex="0"></div>')),lockstring=locked?"aria_column_locked":"aria_column_unlocked";(0,_str.get_string)(lockstring,"mod_board",name).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)})),handleAction(lockElement,(()=>{const lockColumn="true"!==column.attr("data-locked");serviceCall("lock_column",{id:ident,status:lockColumn},(function(result){const columnName=column.find(".mod_board_column_name").text();result.status&&(lockColumn?(lockElement.removeClass("fa-unlock").addClass("fa-lock"),column.attr("data-locked","true"),column.find(".board_button.newnote").addClass("d-none"),(0,_str.get_string)("aria_column_locked","mod_board",columnName).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)}))):(lockElement.removeClass("fa-lock").addClass("fa-unlock"),column.attr("data-locked","false"),column.find(".board_button.newnote").removeClass("d-none"),(0,_str.get_string)("aria_column_unlocked","mod_board",columnName).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)}))),lastHistoryId=result.historyid,updateSortable())}))})),columnHeader.append(lockElement),columnHeader.addClass("icon-size-3");const moveElement=(0,_jquery.default)('<div class="icon fa fa-arrows mod_column_move" role="button" tabindex="0"></div>');columnHeader.append(moveElement),_movecolumnsdialog.default.init(moveColumn);var removeElement=(0,_jquery.default)('<div class="icon fa fa-remove delete_column" role="button" tabindex="0"></div>');handleAction(removeElement,(()=>{_notification.default.confirm(strings.remove_column_title,(0,_str.get_string)("remove_column_text","mod_board",getColumnName(ident)),strings.delete,strings.Cancel,(function(){serviceCall("delete_column",{id:ident},(function(result){result.status&&(column.remove(),lastHistoryId=result.historyid)}))}))})),columnHeader.append(removeElement)}if(column.append(columnHeader),column.append(columnContent),column.append(columnNewContent),iseditable&&(!function(elem,callback,callBeforeOnKeyEditing){if(elem.is(":editable"))throw new Error("handleEditableAction - must be called before setting the element as editable");elem.on("dblclick keypress",(function(e){if("keypress"==e.type){if(!isAriaTriggerKey(e.keyCode)||elem.is(":editing"))return;if(e.preventDefault(),callBeforeOnKeyEditing&&callback(),elem.editable("open"),callBeforeOnKeyEditing)return}callback()}))}(columnName,(function(){nameCache=columnName.html()}),!0),columnName.editable({toggleFontSize:!1,closeOnEnter:!0,callback:function(data){data.content?serviceCall("update_column",{id:ident,name:columnName.html()},(function(result){result.status?(lastHistoryId=result.historyid,updateColumnAria(ident)):(columnName.html(nameCache),nameCache=null)}),(function(){columnName.html(nameCache),nameCache=null})):(columnName.html(nameCache),nameCache=null)}})),!isReadOnlyBoard){const newNoteButton=(0,_jquery.default)('<div class="board_button newnote" role="button" tabindex="0"><div class="button_content"><span class="fa '+options.noteicon+'"></span></div></div>');columnNewContent.append(newNoteButton),"true"===column.attr("data-locked")&&newNoteButton.addClass("d-none"),handleAction(columnNewContent.find(".newnote"),(function(){addNote(ident,0,null,null,null,{id:userId},0,0)}))}var lastOne=(0,_jquery.default)(".mod_board .board_column_hasdata").last();if(lastOne.length?column.insertAfter(lastOne):(0,_jquery.default)(".mod_board").append(column),notes)for(var index in notes){let sortorder=3==sortby?notes[index].sortorder:notes[index].timecreated;addNote(ident,notes[index].id,notes[index].heading,notes[index].content,{type:notes[index].type,info:notes[index].info,url:notes[index].url},{id:notes[index].userid},sortorder,notes[index].rating)}sortNotes(columnContent),updateColumnAria(ident),(isEditor||1==usersCanEdit)&&updateSortable(),isEditor&&columnSorting()};const getColumnName=id=>(0,_jquery.default)(".board_column[data-ident='".concat(id,"']")).find(".mod_board_column_name").html();const selectHeadingColour=()=>{let colCount=(0,_jquery.default)(".board_column").length-1,colourCount=options.colours.length;return options.colours[colCount%colourCount]};var updateNote=function(note,heading,data){var noteHeading=getNoteHeadingForNote(note),noteText=getNoteTextForNote(note),noteBorder=getNoteBorderForNote(note);noteText.html(data.content),noteHeading.html(data.heading),setAttachment(note,data.attachment),updateNoteAria(data.id),noteHeading.show(),noteBorder.show(),noteText.show(),noteHeading.html()||(noteHeading.hide(),noteBorder.hide()),!noteText.html()&&noteHeading.html()&&(noteText.hide(),noteBorder.hide())},processBoardHistory=function(){serviceCall("board_history",{id:board.id,ownerid:ownerId,since:lastHistoryId},(function(boardhistory){for(var index in boardhistory){var item=boardhistory[index];if(item.boardid==board.id){var data=JSON.parse(item.content);if("add_note"==item.action){let sortorder=3==sortby?data.sortorder:data.timecreated;addNote(data.columnid,data.id,data.heading,data.content,data.attachment,{id:item.userid},sortorder,data.rating),updateNoteAria(data.id),sortNotes((0,_jquery.default)(".board_column[data-ident="+data.columnid+"] .board_column_content"))}else if("update_note"==item.action){let note=getNote(data.id),formModal=editModal,historyData=data;if(note){getNoteHeadingForNote(note);editingNote==data.id?_notification.default.confirm(strings.note_changed_title,strings.note_changed_text,strings.Ok,strings.Cancel,(function(){formModal.hide(),updateNote(note,0,historyData),stopNoteEdit()})):updateNote(note,0,data)}}else if("delete_note"==item.action){editingNote==data.id&&(_notification.default.alert(strings.warning,strings.note_deleted_text),stopNoteEdit());let note=getNote(data.id);if(3==sortby){let columnID=note.data("column"),sortorder=note.data("sortorder");sortAfterDelete(columnID,sortorder)}note.remove()}else if("add_column"==item.action)addColumn(data.id,data.name,!1,{},selectHeadingColour());else if("move_column"==item.action){const board=(0,_jquery.default)(".mod_board");data.sortorder.forEach((column=>{board.find(".board_column[data-ident='".concat(column,"']")).detach().appendTo(board)}))}else if("update_column"==item.action)(0,_jquery.default)(".board_column[data-ident='"+data.id+"'] .mod_board_column_name").html(data.name),updateColumnAria(data.id);else if("lock_column"==item.action)(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").attr("data-locked",data.locked),data.locked?(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").find(".board_button.newnote").addClass("d-none"):(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").find(".board_button.newnote").removeClass("d-none"),updateSortable();else if("delete_column"==item.action){var column=(0,_jquery.default)(".board_column[data-ident='"+data.id+"']");editingNote&&column.find('.board_note[data-ident="'+editingNote+'"]').length&&stopNoteEdit(),column.remove()}else if("rate_note"==item.action){var note=getNote(data.id);note.find(".mod_board_rating").html(data.rating),2==sortby&&sortNotes(note.closest(".board_column_content"))}lastHistoryId=item.id}}updateBoard()}))},updateBoard=function(instant){instant?processBoardHistory():options.history_refresh>0&&(reloadTimer&&stopUpdating(),reloadTimer=setTimeout(processBoardHistory,1e3*options.history_refresh))},stopUpdating=function(){clearTimeout(reloadTimer),reloadTimer=null},sortNotes=function(content,toggle){var desc,asc,sortCol=(0,_jquery.default)(content).parent().find(".mod_board_column_sort"),direction=(0,_jquery.default)(content).data("sort");if(direction||(direction=2==sortby?"desc":"asc"),toggle&&(direction="asc"==direction?"desc":"asc"),"asc"==direction?(sortCol.removeClass("fa-angle-down"),sortCol.addClass("fa-angle-up")):(sortCol.removeClass("fa-angle-up"),sortCol.addClass("fa-angle-down")),(0,_jquery.default)(content).data("sort",direction),1==sortby)desc=function(a,b){return(0,_jquery.default)(b).data("sortorder")-(0,_jquery.default)(a).data("sortorder")},asc=function(a,b){return(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder")};else if(2==sortby)desc=function(a,b){return(0,_jquery.default)(b).find(".mod_board_rating").text()-(0,_jquery.default)(a).find(".mod_board_rating").text()||(0,_jquery.default)(b).data("sortorder")-(0,_jquery.default)(a).data("sortorder")},asc=function(a,b){return(0,_jquery.default)(a).find(".mod_board_rating").text()-(0,_jquery.default)(b).find(".mod_board_rating").text()||(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder")};else if(3==sortby){let sortElements=(a,b)=>(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder");return void(0,_jquery.default)("> .board_note",(0,_jquery.default)(content)).sort(sortElements).appendTo((0,_jquery.default)(content))}(0,_jquery.default)("> .board_note",(0,_jquery.default)(content)).sort("asc"===direction?asc:desc).appendTo((0,_jquery.default)(content))},updateSortable=function(){let fromColumnID;(0,_jquery.default)(".board_column[data-locked='false'] .board_column_content").sortable({connectWith:".board_column[data-locked='false'] .board_column_content",cancel:".mod_board_nosort",handle:".move_note",start:function(_,ui){fromColumnID=(0,_jquery.default)(ui.item).closest(".board_column").data("ident")},stop:function(_,ui){var note=(0,_jquery.default)(ui.item),tocolumn=note.closest(".board_column"),elem=(0,_jquery.default)(this),noteid=note.data("ident"),columnid=tocolumn.data("ident");let sortorder=tocolumn.find(".board_column_content").children().index((0,_jquery.default)(".board_note[data-ident=".concat(noteid,"]")));moveNote(fromColumnID,{id:noteid,columnid:columnid,ownerid:ownerId,sortorder:sortorder},elem)}})};const moveNote=(fromColumnID,payload,elem)=>{updateSortOrders(fromColumnID,payload.columnid,payload.id,payload.sortorder),serviceCall("move_note",payload,(result=>{result.status?(lastHistoryId=result.historyid,updateNoteAria(payload.id),updateBoard(),sortNotes((0,_jquery.default)(".board_column[data-ident=".concat(payload.columnid,"] .board_column_content")))):elem&&elem.sortable("cancel")}))},columnSorting=()=>{let movingColumnId;(0,_jquery.default)(".mod_board").sortable({connectWith:".mod_board",axis:"x",containment:".mod_board_wrapper",cancel:".mod_board_nosort",handle:".mod_column_move",start:function(_,ui){movingColumnId=(0,_jquery.default)(ui.item).closest(".board_column").data("ident")},stop:function(_,ui){let column=(0,_jquery.default)(ui.item),sortorder=(0,_jquery.default)(".mod_board").find(".board_column").index(column);moveColumn({id:movingColumnId,sortorder:sortorder})}})},moveColumn=payload=>{serviceCall("move_column",payload,!1)},updateSortOrders=(fromColumnID,toColumnID,noteID,newSortOrder)=>{let toColumn=(0,_jquery.default)(".board_column[data-ident=".concat(toColumnID,"] .board_column_content")),movedNote=(0,_jquery.default)(".board_note[data-ident=".concat(noteID,"]")),oldSortOrder=movedNote.data("sortorder"),toChildren=toColumn.children();if(fromColumnID==toColumnID)toChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");oldSortOrder<newSortOrder?sortOrder<=newSortOrder&&sortOrder>=oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder-1):oldSortOrder>newSortOrder&&sortOrder>=newSortOrder&&sortOrder<=oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder+1)}));else{let fromChildren=(0,_jquery.default)(".board_column[data-ident=".concat(fromColumnID,"] .board_column_content")).children();toChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");sortOrder>=newSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder+1)})),fromChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");sortOrder>oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder-1)}))}movedNote.data("sortorder",newSortOrder)};var getBody=function(noteid,columnid,ownerId){var params={noteid:noteid,columnid:columnid,ownerid:ownerId};return _fragment.default.loadFragment("mod_board","note_form",contextid,params)},showModalForm=function(note){let title,noteId=0,columnId=note.data("column"),columnIdentifier=(0,_jquery.default)(".board_column[data-ident="+columnId+"]").find(".mod_board_column_name").text();columnIdentifier=encodeText(columnIdentifier),note.data("ident")?(noteId=note.data("ident"),title=strings.modal_title_edit.replace("{column}",columnIdentifier)):title=strings.modal_title_new.replace("{column}",columnIdentifier),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:getBody(noteId,columnId,ownerId),large:!0,removeOnClose:!0}).then((function(modal){return modal.getBodyPromise().then((function(){let saveInProgress=!1;editModal=modal,modal.setLarge(),modal.setSaveButtonText(strings.post_button_text),modal.setButtonText("cancel",strings.cancel_button_text),modal.getRoot().on(_modal_events.default.hidden,(function(){stopNoteEdit(),note.data("ident")||note.remove()})),modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault(),modal.getRoot().find("form").submit()}));var changeEvent=document.createEvent("HTMLEvents");if(changeEvent.initEvent("change",!0,!0),modal.getRoot().on("submit","form",(function(e){if(e.preventDefault(),saveInProgress)return;if(saveInProgress=!0,modal.getRoot().find("form").get(0).reportValidity()){modal.getRoot().find(":input").each((function(index,element){element.dispatchEvent(changeEvent)}));var invalid=_jquery.default.merge(modal.getRoot().find('[aria-invalid="true"]'),modal.getRoot().find(".error"),modal.getRoot().find(":invalid"));if(invalid.length)return invalid.first().focus(),void(saveInProgress=!1);var formData=JSON.stringify(modal.getRoot().find("form").serialize());serviceCall("submit_form",{contextid:contextid,jsonformdata:formData},(function(result){result.status?("insert"==result.action?(lastHistoryId=result.historyid,note.remove(),addNote(columnId,result.note.id,result.note.heading,result.note.content,{type:result.note.type,info:result.note.info,url:result.note.url},{id:result.note.userid},result.note.timecreated,result.note.rating),sortNotes((0,_jquery.default)(".board_column[data-ident="+columnId+"] .board_column_content")),updateNoteAria(result.note.id)):(lastHistoryId=result.historyid,getNoteTextForNote(note).html(result.note.content),getNoteHeadingForNote(note).html(result.note.heading),updateNoteAria(result.note.id),setAttachment(note,{type:result.note.type,info:result.note.info,url:result.note.url})),stopNoteEdit(),Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()})),modal.destroy()):modal.destroy()}))}else saveInProgress=!1})),1==mediaSelection){modal.getRoot().find("#fitem_id_mediatype").hide();let mediaSelect=modal.getRoot().find("#fitem_id_mediatype select"),ytButton=modal.getRoot().find(".mod_board_attachment_button.youtube_button"),pictureButton=modal.getRoot().find(".mod_board_attachment_button.image_button"),linkButton=modal.getRoot().find(".mod_board_attachment_button.link_button"),updateMediaButtons=function(){switch(ytButton.removeClass("selected"),pictureButton.removeClass("selected"),linkButton.removeClass("selected"),mediaSelect.val()){case"1":ytButton.addClass("selected");break;case"2":pictureButton.addClass("selected");break;case"3":linkButton.addClass("selected")}};updateMediaButtons(),handleAction(ytButton,(function(){"1"===mediaSelect.val()?mediaSelect.val(0):mediaSelect.val(1),updateMediaButtons(),mediaSelect[0].dispatchEvent(changeEvent)})),handleAction(pictureButton,(function(){"2"===mediaSelect.val()?mediaSelect.val(0):mediaSelect.val(2),updateMediaButtons(),mediaSelect[0].dispatchEvent(changeEvent)})),handleAction(linkButton,(function(){"3"===mediaSelect.val()?mediaSelect.val(0):mediaSelect.val(3),updateMediaButtons(),mediaSelect[0].dispatchEvent(changeEvent)}))}else modal.getRoot().find("#fitem_id_mediabuttons").hide();return function(note,modal){let addYoutube,addImage,addLink,postButton,cancelButton,columnIdentifier=note.closest(".board_column").find(".mod_board_column_name").text(),modalRoot=modal.getRoot();if(note.data("ident")){var noteIdentifier=textIdentifierForNote(note);postButton=strings.aria_postedit.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier),cancelButton=strings.aria_canceledit.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier),addYoutube=strings.aria_addmedia.replace("{type}",strings.option_youtube).replace("{column}",columnIdentifier).replace("{post}",noteIdentifier),addImage=strings.aria_addmedia.replace("{type}",strings.option_image).replace("{column}",columnIdentifier).replace("{post}",noteIdentifier),addLink=strings.aria_addmedia.replace("{type}",strings.option_link).replace("{column}",columnIdentifier).replace("{post}",noteIdentifier)}else postButton=strings.aria_postnew.replace("{column}",columnIdentifier),cancelButton=strings.aria_cancelnew.replace("{column}",columnIdentifier),addYoutube=strings.aria_addmedianew.replace("{type}",strings.option_youtube).replace("{column}",columnIdentifier),addImage=strings.aria_addmedianew.replace("{type}",strings.option_image).replace("{column}",columnIdentifier),addLink=strings.aria_addmedianew.replace("{type}",strings.option_link).replace("{column}",columnIdentifier);1==mediaSelection&&(modalRoot.find(".mod_board_attachment_button.youtube_button").attr("aria-label",addYoutube),modalRoot.find(".mod_board_attachment_button.youtube_button").attr("title",addYoutube),modalRoot.find(".mod_board_attachment_button.image_button").attr("aria-label",addImage),modalRoot.find(".mod_board_attachment_button.image_button").attr("title",addImage),modalRoot.find(".mod_board_attachment_button.link_button").attr("aria-label",addLink),modalRoot.find(".mod_board_attachment_button.link_button").attr("title",addLink));let button=modalRoot.find(modal.getActionSelector("save"));button&&button.attr("aria-label",postButton),button=modalRoot.find(modal.getActionSelector("cancel")),button&&button.attr("aria-label",cancelButton)}(note,modal),modal.show(),modal})).catch(_notification.default.exception),modal})).catch(_notification.default.exception)},fullScreenNote=(ident,notecontent)=>{const heading=getNoteHeadingForNote(notecontent).html(),modalBody=(0,_jquery.default)(document.createElement("div"));modalBody.addClass("mod_board_note_content");const text=getNoteTextForNote(notecontent);text&&modalBody.append(text.clone());const preview=(note=notecontent,(0,_jquery.default)(note).find(".mod_board_preview"));var note;preview&&modalBody.append(preview.clone());const commentArea=(0,_jquery.default)(document.createElement("div"));commentArea.attr("data-region","comment-area"),modalBody.append(commentArea),_comments.default.fetchFor(ident,commentArea),_modal_factory.default.create({type:_modal_factory.default.types.CANCEL,title:heading,body:modalBody}).then((function(modal){return modal.setLarge(),(0,_str.get_string)("close_button_text","mod_board").done((function(str){modal.setButtonText("cancel",str)})),modal.show(),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal}),this).catch(_notification.default.exception)},init=function(){serviceCall("get_board",{id:board.id,ownerid:ownerId},(function(columns){if(columns)for(var index in columns)addColumn(columns[index].id,columns[index].name,columns[index].locked,columns[index].notes||{},options.colours[columns[index].id%options.colours.length]);var column,newBusy;isEditor&&(column=(0,_jquery.default)('<div class="board_column_empty"></div>'),newBusy=!1,column.append('<div class="board_button newcolumn" role="button" tabindex="0" aria-label="'+strings.aria_newcolumn+'" title="'+strings.aria_newcolumn+'"><div class="button_content"><span class="fa '+options.columnicon+'"></span></div></div>'),handleAction(column.find(".newcolumn"),(function(){newBusy||(newBusy=!0,serviceCall("add_column",{boardid:board.id,name:strings.default_column_heading},(function(result){addColumn(result.id,strings.default_column_heading,!1,{},selectHeadingColour()),lastHistoryId=result.historyid,newBusy=!1}),(function(){newBusy=!1})))})),(0,_jquery.default)(".mod_board").append(column)),lastHistoryId=board.historyid,isEditor&&(updateSortable(),columnSorting()),updateBoard()}))},stringsInfo=[];for(var string in strings)stringsInfo.push({key:string,component:"mod_board"});_jquery.default.when((0,_str.get_strings)(stringsInfo)).done((function(results){var index=0;for(string in strings)strings[string]=results[index++];init()}))},_jquery=_interopRequireDefault(_jquery),_ajax=_interopRequireDefault(_ajax),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_notification=_interopRequireDefault(_notification),_fragment=_interopRequireDefault(_fragment),_comments=_interopRequireDefault(_comments),_movenotesdialog=_interopRequireDefault(_movenotesdialog),_movecolumnsdialog=_interopRequireDefault(_movecolumnsdialog);const isAriaTriggerKey=function(key){return 13==key||32==key},encodeText=function(rawText){return(0,_jquery.default)("<div />").text(rawText).html()},decodeText=function(encodedText){return(0,_jquery.default)("<div />").html(encodedText).text()},handleAction=function(elem,callback){return elem.on("click keypress",(function(e){if("keypress"==e.type){if(!isAriaTriggerKey(e.keyCode))return;e.preventDefault()}callback(),e.preventDefault()}))};return _exports.default}));

//# sourceMappingURL=board.min.js.map