# Brickfield board module plugin #
Copyright (C) 2023 [Brickfield Education Labs](https://www.brickfield.ie/)

## What is Board? ##
The Board module for Moodle is a plugin that enables a post-it board activity for students.
This is a collaborative activity where the teachers sets out a number of columns with
editable names and then students add contributions to a column. Students do not see who has
posted what.

On the board activity, students can:
* Add a new post with some of the following:
  * A heading.
  * Some text.
  * Add a link.
  * Upload an image.
  * Embed a Youtube video.
* Edit or Delete one of their posts.
* Add optional comments to posts.

They can also do the following depending on the settings of the teacher:
* Move their notes among columns.
* Rate, or star, someone else's post.

The teacher can set up the board activity with the following options:
* A closing date for submissions.
* How the posts are ordered in a column, by date or star count.
* Whether posts can be starred - by students, teachers, or neither.
* Standard moodle group access settings.

On the board, a teacher can:
* Move any of the posts from one column to another.
* Download a copy of the board contents.
* Download a spreadsheet of submissions of the students.
* Download a spreadsheet of comments by the students.

## Funding credits ##
Initial funding for this plugin was provided by the National Institute for Digital Learning
at Dublin City University under the SATLE fund from the National Forum. Subsequent funding
has been received from Athlone Institute of Technology under the SATLE fund from the
National Forum, and also from UCL.

## Version support ##
This plugin has been developed to work on Moodle releases 4.00, 4.01, 4.02, 4.03, 4.04, and 4.05.

## Development ##
This plugin has been developed and is maintained by Brickfield Education Labs.
If you wish to contribute funding to the ongoing development of features and / or
maintenance of the plugin - please contact [support@brickfield.ie](mailto:support@brickfield.ie).

This module uses code derived from ["jquery.editable.amd.js"](https://github.com/victorjonsson/jquery-editable/).
This code written by [Victor Jonsson](http://victorjonsson.se/) is licensed under [GNU GPLv2](http://www.gnu.org/licenses/gpl-2.0.html).

### Icon design ###
Many thanks to [Stuart Lamour](https://github.com/stuartlamour) for our new board icon! Also thanks to [Luca Bosch](https://github.com/lucaboesch) for our updated 4.04 icon!

## Documentation ##
All public documentation for this plugin is maintained at the
[Brickfield board helpdocs site](https://moodleboard.eu.helpdocs.com/).

## Important Links ##
* [Code repository](https://github.com/brickfield/moodle-mod_board)
* [Plugin Directory](https://moodle.org/plugins/mod_board)

## Installation ##
* Unzip and copy "board" folder into Moodle's "mod" folder
* Visit admin page to install module

Further installation instructions can be found on the
"[Installing plugins](http://docs.moodle.org/en/Installing_contributed_modules_or_plugins)" Moodle documentation page.
