# Board
Copyright (C) 2023 [Brickfield Education Labs](https://www.brickfield.ie/)

## What is Board?
Encourage lively discussions and idea-sharing with Board, a post-it board activity for students!

This is an anonymous collaborative activity, where students can add their contributions of text, images, files, URLs, and videos, as a collection of visual notes.

Commenting on notes is enabled by default via capabilities, and rating notes can be enabled or disabled in each board instance's settings.

## Usage
Teachers can deploy ready-made, purpose-built board activities from templates in moments, or create custom ones as needed.

Group and single-user modes are also available. Optional completion criteria are provided also.

Students can share their ideas anonymously, and teachers can track these contributions via their board download options.

Students can include the following in their notes:
- Heading.
- Text with multiple formatting options: headings, lists, line breaks, bold and italics.
- Link.
- Image.
- Video (Youtube).
- Comment on any viewable notes.
- Rate any viewable notes, if enabled.

## License
2023 Onward [Brickfield Education Labs](https://www.brickfield.ie)

## Version support
This plugin has been developed to work on Moodle releases 4.5 and 5.0.

## Funding credits
Initial funding for this plugin was provided by the National Institute for Digital Learning at Dublin City University under the SATLE fund from the National Forum. Subsequent funding has been received from Athlone Institute of Technology under the SATLE fund from the National Forum, and also from UCL.

Funding for templates, text formatting, and file attachments was also provided by the National Institute for Digital Learning at Dublin City University under the SATLE fund from the National Forum.

## Development
This plugin has been developed and is maintained by Brickfield Education Labs.

If you wish to contribute funding to the ongoing development of features and / or
maintenance of the plugin - please contact [support@brickfield.ie](mailto:support@brickfield.ie).

This module uses code derived from ["jquery.editable.amd.js"](https://github.com/victorjonsson/jquery-editable/).
This code written by [Victor Jonsson](http://victorjonsson.se/) is licensed under [GNU GPLv2](http://www.gnu.org/licenses/gpl-2.0.html).

### Icon design
Many thanks to [Stuart Lamour](https://github.com/stuartlamour) for our board icon! Also thanks to [Luca Bosch](https://github.com/lucaboesch) for our updated 4.04 icon!

## Important Links
* [Code repository](https://github.com/brickfield/moodle-mod_board).
* [Plugin directory](https://moodle.org/plugins/mod_board).
* [Board user guide](https://docs.brickfield.ie/mod-board/).

## Installation
1. Unzip and copy the "board" folder into your Moodle's "mod/" folder.
2. Visit the admin page to install the plugin.

Further installation instructions can be found on the "[Installing plugins](http://docs.moodle.org/en/Installing_contributed_modules_or_plugins)" Moodle documentation page.
