define("mod_board/board",["exports","jquery","core/str","core/ajax","core/modal_cancel","core/modal_events","core/notification","mod_board/jquery.sortable.amd","mod_board/comments","./movenotesdialog","./movecolumnsdialog","mod_board/ajax_form/modal","core/url"],(function(_exports,_jquery,_str,_ajax,_modal_cancel,_modal_events,_notification,_jquerySortable,_comments,_movenotesdialog,_movecolumnsdialog,_modal,_url){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A javascript module to handle the board.
   *
   * @author     Karen Holland <karen@brickfieldlabs.ie>
   * @copyrigt   2021 Brickfield Education Labs <https://www.brickfield.ie/>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=function(settings){var strings={default_column_heading:"",post_button_text:"",cancel_button_text:"",remove_note_title:"",remove_note_text:"",remove_column_title:"",note_changed_title:"",note_changed_text:"",note_deleted_text:"",column_deleted_text:"",rate_note_title:"",rate_note_text:"",rate_remove_note_text:"",Ok:"",delete:"",Cancel:"",warning:"",modal_title_new:"",modal_title_edit:"",option_youtube:"",option_image:"",option_link:"",option_file:"",aria_newcolumn:"",aria_newpost:"",aria_deletecolumn:"",aria_updatecolumn:"",aria_movecolumn:"",aria_deletepost:"",aria_movepost:"",aria_editpost:"",aria_addmedia:"",aria_addmedianew:"",aria_deleteattachment:"",aria_postedit:"",aria_canceledit:"",aria_postnew:"",aria_cancelnew:"",aria_ratepost:"",invalid_youtube_url:""},options=JSON.parse(settings.settings)||{},board=options.board||{};var reloadTimer=null,lastHistoryId=null,isEditor=options.isEditor||!1,usersCanEdit=options.usersCanEdit,userId=parseInt(options.userId)||-1,ownerId=parseInt(options.ownerId),groupId=parseInt(options.groupId),creatingNote=0,creatingNoteModal=null,updatingNote=0,updateNoteModal=null,isReadOnlyBoard=options.readonly||!1,ratingenabled=options.ratingenabled,sortby=options.sortby||1,enableblanktarget=1===parseInt(options.enableblanktarget),serviceCall=function(method,args,callback,failcallback){"board_history"!==method&&stopUpdating(),function(method,args,callback,failcallback){_ajax.default.call([{methodname:"mod_board_"+method,args:args,done:function(data){callback(data)},fail:function(error){_notification.default.exception(error),failcallback&&failcallback(error)}}])}(method,args,(function(){callback&&callback.apply(null,arguments),"board_history"!==method&&"get_board"!==method&&updateBoard(!0)}),failcallback)},getNote=function(ident){return(0,_jquery.default)(".board_note[data-ident='"+ident+"']")},getNoteTextForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_text")},getNoteHeadingForNote=function(note){return(0,_jquery.default)(note).find(".mod_board_note_heading")},updateNoteAria=function(noteId){var note=getNote(noteId),columnIdentifier=note.closest(".board_column").find(".mod_board_column_name").text();if(noteId){var noteIdentifier=decodeText(function(note){return note.attr("data-identifier")}(note)),deleteNoteString=strings.aria_deletepost.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier);note.find(".delete_note").attr("aria-label",deleteNoteString).attr("title",deleteNoteString);var moveNoteString=strings.aria_movepost.replace("{post}",noteIdentifier);note.find(".move_note").attr("aria-label",moveNoteString).attr("title",moveNoteString);var editNoteString=strings.aria_editpost.replace("{post}",noteIdentifier);note.find(".edit_note").attr("aria-label",editNoteString).attr("title",editNoteString),note.find(".mod_board_rating").attr("aria-label",strings.aria_ratepost.replace("{column}",columnIdentifier).replace("{post}",noteIdentifier)),note.find(".note_ariatext").html(noteIdentifier)}},updateColumnAria=function(columnId){var column=(0,_jquery.default)(".board_column[data-ident="+columnId+"]"),columnIdentifier=column.find(".mod_board_column_name").text(),newNoteString=strings.aria_newpost.replace("{column}",columnIdentifier),moveColumnString=strings.aria_movecolumn.replace("{column}",columnIdentifier),deleteColumnString=strings.aria_deletecolumn.replace("{column}",columnIdentifier),updateColumnString=strings.aria_updatecolumn.replace("{column}",columnIdentifier);column.find(".newnote").attr("aria-label",newNoteString).attr("title",newNoteString),column.find(".mod_column_move").attr("aria-label",moveColumnString).attr("title",moveColumnString),column.find(".delete_column").attr("aria-label",deleteColumnString).attr("title",deleteColumnString),column.find(".update_column").attr("aria-label",updateColumnString).attr("title",updateColumnString),column.find(".board_note").each((function(index,note){updateNoteAria((0,_jquery.default)(note).data("ident"))}))};const stopUpdatingNote=function(){updatingNote&&(updateNoteModal&&updateNoteModal.destroy(),updatingNote=0,updateNoteModal=null)};const sortAfterDelete=(columnID,sortorder)=>{let column=(columnID=>(0,_jquery.default)(".board_column[data-ident='".concat(columnID,"'] .board_column_content")))(columnID);column.children().filter(((_,element)=>parseInt((0,_jquery.default)(element).data("sortorder"))>parseInt(sortorder))).each(((_,element)=>{let so=(0,_jquery.default)(element).data("sortorder");(0,_jquery.default)(element).data("sortorder",so-1)}))};var previewAttachment=function(note,attachment){let elem=note.find(".mod_board_preview");if(getNoteTextForNote(note).html().length?elem.removeClass("mod_board_notext"):elem.addClass("mod_board_notext"),elem.removeClass("wrapper_youtube"),elem.removeClass("wrapper_image"),elem.removeClass("wrapper_url"),elem.removeClass("wrapper_file"),attachment.url){let preview=null;switch(parseInt(attachment.type)){case 1:{let url=(url=>{let videoID=url.match(/(\/|%3D|v=)([0-9A-z-_]{11})([%#?&]|$)/);return videoID&&void 0!==videoID[2]&&11===videoID[2].length?"https://www.youtube-nocookie.com/embed/".concat(videoID[2]):null})(attachment.url);null===url?elem.html(strings.invalid_youtube_url):(elem.html('<iframe src="'+url+'" class="mod_board_preview_element" frameborder="0" allow="accelerometer; autoplay; clipboard-write;encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe><a href="#" class="stretched-link" aria-hidden="true"></a>'),elem.addClass("wrapper_youtube").addClass("position-relative")),elem.show(),elem.addClass("wrapper_image"),elem.data("type",1),elem.data("info",attachment.info)}break;case 2:preview=document.createElement("img"),preview.src=attachment.url,preview.alt=decodeText(attachment.info),preview.classList.add("mod_board_preview_element"),elem.html(""),elem.append(preview),elem.addClass("wrapper_image"),elem.data("type",2),elem.data("info",attachment.info),elem.show();break;case 3:preview=document.createElement("a"),preview.href=attachment.url,preview.text=decodeText(attachment.info),preview.classList.add("mod_board_preview_element"),enableblanktarget&&(preview.target="_blank"),elem.html(""),elem.append(preview),elem.addClass("wrapper_url"),elem.data("type",3),elem.data("info",attachment.info),elem.show();break;case 4:preview=document.createElement("a"),preview.href=attachment.url,preview.text=decodeText(attachment.info),preview.classList.add("mod_board_preview_element"),elem.html(""),elem.append(preview),elem.addClass("wrapper_file"),elem.data("type",4),elem.data("info",attachment.info),elem.show();break;default:elem.html(""),elem.data("type",0),elem.data("info",""),elem.hide()}}else elem.html(""),elem.hide()},addNote=function(columnid,ident,identifier,heading,content,attachment,owner,sortorder,rating){var ismynote=owner.id==userId||!ident,iseditable=isEditor||ismynote&&!isReadOnlyBoard;if(ident){if(3==sortby){(0,_jquery.default)(".board_column[data-ident='".concat(columnid,"'] .board_column_content")).children().filter(((_,element)=>parseInt((0,_jquery.default)(element).data("sortorder"))>=parseInt(sortorder))).each(((_,element)=>{let so=(0,_jquery.default)(element).data("sortorder");(0,_jquery.default)(element).data("sortorder",so+1)}))}var note=(0,_jquery.default)('<div class="board_note" data-column="'+columnid+'" data-ident="'+ident+'" data-sortorder="'+sortorder+'"></div>');note.attr("data-identifier",identifier),ismynote&&note.addClass("mod_board_mynote"),iseditable&&note.addClass("mod_board_editablenote"),ismynote||iseditable||note.addClass("mod_board_nosort");var notecontent=(0,_jquery.default)('<div class="mod_board_note_content"></div>'),notecontrols=(0,_jquery.default)('<div class="mod_board_note_controls"></div>'),noteHeading=(0,_jquery.default)('<div class="mod_board_note_heading" tabindex="0">'+(heading||"")+"</div>"),noteBorder=(0,_jquery.default)('<div class="mod_board_note_border"></div>'),noteText=(0,_jquery.default)('<div class="mod_board_note_text" tabindex="0">'+(content||"")+"</div>"),noteAriaText=(0,_jquery.default)('<div class="note_ariatext hidden" role="heading" aria-level="4" tabindex="0"></div>'),attachmentPreview=(0,_jquery.default)('<div class="mod_board_preview"></div>');notecontent.append(noteHeading),notecontent.append(noteBorder),notecontent.append(noteText),notecontent.append(noteAriaText),notecontent.append(attachmentPreview),note.append(notecontent);var columnContent=(0,_jquery.default)(".board_column[data-ident="+columnid+"] .board_column_content");if(ratingenabled){note.addClass("mod_board_rateablenote");var rateElement=(0,_jquery.default)('<div class="fa fa-star mod_board_rating" role="button" tabindex="0"> '.concat(rating," </div>"));handleAction(rateElement,(()=>{!function(ident){if(ratingenabled&&!isReadOnlyBoard){var note=getNote(ident),rating=note.find(".mod_board_rating");rating.data("disabled")||(rating.data("disabled",!0),serviceCall("can_rate_note",{id:ident},(function(result){if(result.canrate){const rateRemoveText=result.hasrated?strings.rate_remove_note_text:strings.rate_note_text;_notification.default.confirm(strings.rate_note_title,rateRemoveText,strings.Ok,strings.Cancel,(function(){serviceCall("rate_note",{id:ident},(function(result){result.status&&(lastHistoryId=result.historyid,rating.html(" ".concat(result.rating," ")),2==sortby&&sortNotes(note.closest(".board_column_content"))),rating.data("disabled",!1)}))})).then((function(rateModal){rateModal.getRoot().on(_modal_events.default.hidden,(function(){rating.data("disabled",!1)}))}))}})))}}(ident)})),notecontrols.append(rateElement)}if(iseditable){var removeElement=(0,_jquery.default)('<div class="fa fa-remove delete_note" role="button" tabindex="0"></div>');if(handleAction(removeElement,(()=>{!function(ident){_notification.default.confirm(strings.remove_note_title,strings.remove_note_text,strings.delete,strings.Cancel,(function(){serviceCall("delete_note",{id:ident},(function(result){if(result.status){lastHistoryId=result.historyid;let note=getNote(ident);if(3==sortby){let columnID=note.data("column"),sortorder=note.data("sortorder");sortAfterDelete(columnID,sortorder)}note.remove()}}))}))}(ident)})),notecontrols.append(removeElement),1==usersCanEdit||isEditor){var moveElement=(0,_jquery.default)('<div class="mod_board_move fa fa-arrows move_note" role="button" tabindex="0"></div>');notecontrols.append(moveElement),_movenotesdialog.default.init(moveNote)}var editElement=(0,_jquery.default)('<div class="mod_board_move fa fa-pencil edit_note" role="button" tabindex="0"></div>');notecontrols.append(editElement),handleAction(editElement,(()=>{showNoteUpdateModal(ident)})),updateSortable()}previewAttachment(note,attachment),note.append(notecontrols),handleAction(notecontent,(()=>fullScreenNote(ident,notecontent))),noteHeading.html()||(noteHeading.hide(),noteBorder.hide()),!noteText.html()&&noteHeading.html()&&(noteText.hide(),noteBorder.hide());var lastOne=columnContent.find(".board_note").last();lastOne.length?note.insertAfter(lastOne):columnContent.prepend(note)}},addColumn=function(ident,name,locked,notes,colour){let headerStyle='style="border-top: 10px solid #'.concat(colour,'"');var iseditable=isEditor,column=(0,_jquery.default)('<div class="board_column board_column_hasdata" data-locked="'.concat(locked,'"                 ').concat(headerStyle,' data-ident="').concat(ident,'"></div>')),columnHeader=(0,_jquery.default)('<div class="board_column_header"></div>'),columnSort=(0,_jquery.default)('<div class="mod_board_column_sort fa"></div>'),columnName=(0,_jquery.default)('<div class="mod_board_column_name" tabindex="0" aria-level="3" role="heading">'+name+"</div>"),columnContent=(0,_jquery.default)('<div class="board_column_content"></div>'),columnNewContent=(0,_jquery.default)('<div class="board_column_newcontent"></div>');if(3!=sortby&&columnHeader.append(columnSort),columnHeader.append(columnName),options.hideheaders&&columnName.addClass("d-none"),columnSort.on("click",(function(){sortNotes(columnContent,!0)})),iseditable){column.addClass("mod_board_editablecolumn");const lockIcon=locked?"fa-lock":"fa-unlock",lockElement=(0,_jquery.default)('<div class="icon fa '.concat(lockIcon,' lock_column" role="button" tabindex="0"></div>')),lockstring=locked?"aria_column_locked":"aria_column_unlocked";(0,_str.get_string)(lockstring,"mod_board",decodeText(name)).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)})),handleAction(lockElement,(()=>{const lockColumn="true"!==column.attr("data-locked");serviceCall("lock_column",{id:ident,status:lockColumn},(function(result){const columnName=column.find(".mod_board_column_name").text();result.status&&(lockColumn?(lockElement.removeClass("fa-unlock").addClass("fa-lock"),column.attr("data-locked","true"),column.find(".board_button.newnote").addClass("d-none"),(0,_str.get_string)("aria_column_locked","mod_board",columnName).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)}))):(lockElement.removeClass("fa-lock").addClass("fa-unlock"),column.attr("data-locked","false"),column.find(".board_button.newnote").removeClass("d-none"),(0,_str.get_string)("aria_column_unlocked","mod_board",columnName).done((function(str){lockElement.attr("aria-label",str),lockElement.attr("title",str)}))),lastHistoryId=result.historyid,updateSortable())}))})),columnHeader.append(lockElement);var removeElement=(0,_jquery.default)('<div class="icon fa fa-remove delete_column" role="button" tabindex="0"></div>');handleAction(removeElement,(()=>{_notification.default.confirm(strings.remove_column_title,(0,_str.get_string)("remove_column_text","mod_board",getColumnName(ident)),strings.delete,strings.Cancel,(function(){serviceCall("delete_column",{id:ident},(function(result){result.status&&(column.remove(),lastHistoryId=result.historyid)}))}))})),columnHeader.append(removeElement),columnHeader.addClass("icon-size-3");const moveElement=(0,_jquery.default)('<div class="icon fa fa-arrows mod_column_move" role="button" tabindex="0"></div>');columnHeader.append(moveElement),_movecolumnsdialog.default.init(moveColumn);var updateElement=(0,_jquery.default)('<div class="icon fa fa-pencil update_column" role="button" tabindex="0"></div>');handleAction(updateElement,(()=>{showColumnUpdateModal(ident)})),columnHeader.append(updateElement)}if(column.append(columnHeader),column.append(columnContent),column.append(columnNewContent),!isReadOnlyBoard){const newNoteButton=(0,_jquery.default)('<div class="board_button newnote" role="button" tabindex="0"><div class="button_content"><span class="fa '+options.noteicon+'"></span></div></div>');columnNewContent.append(newNoteButton),"true"===column.attr("data-locked")&&newNoteButton.addClass("d-none"),handleAction(columnNewContent.find(".newnote"),(function(){showNoteCreateModal(ident)}))}var lastOne=(0,_jquery.default)(".mod_board .board_column_hasdata").last();if(lastOne.length?column.insertAfter(lastOne):(0,_jquery.default)(".mod_board").append(column),notes)for(var index in notes){let sortorder=3==sortby?notes[index].sortorder:notes[index].timecreated;addNote(ident,notes[index].id,notes[index].identifier,notes[index].heading,notes[index].content,{type:notes[index].type,info:notes[index].info,url:notes[index].url},{id:notes[index].userid},sortorder,notes[index].rating)}sortNotes(columnContent),updateColumnAria(ident),(isEditor||1==usersCanEdit)&&updateSortable(),isEditor&&columnSorting()};const getColumnName=id=>(0,_jquery.default)(".board_column[data-ident='".concat(id,"']")).find(".mod_board_column_name").html();const selectHeadingColour=()=>{let colCount=(0,_jquery.default)(".board_column").length-1,colourCount=options.colours.length;return options.colours[colCount%colourCount]};var updateNote=function(note,heading,data){var noteHeading=getNoteHeadingForNote(note),noteText=getNoteTextForNote(note),noteBorder=function(note){return(0,_jquery.default)(note).find(".mod_board_note_border")}(note);note.attr("data-identifier",data.identifier),noteText.html(data.content),noteHeading.html(data.heading),previewAttachment(note,data.attachment),updateNoteAria(data.id),noteHeading.show(),noteBorder.show(),noteText.show(),noteHeading.html()||(noteHeading.hide(),noteBorder.hide()),!noteText.html()&&noteHeading.html()&&(noteText.hide(),noteBorder.hide())},processBoardHistory=function(){let payload={id:board.id,ownerid:ownerId,groupid:groupId,since:lastHistoryId};serviceCall("board_history",payload,(function(boardhistory){for(var index in boardhistory){var item=boardhistory[index];if(item.boardid==board.id){var data=JSON.parse(item.content);if("add_note"===item.action){let sortorder=3==sortby?data.sortorder:data.timecreated;addNote(data.columnid,data.id,data.identifier,data.heading,data.content,data.attachment,{id:item.userid},sortorder,data.rating),updateNoteAria(data.id),sortNotes((0,_jquery.default)(".board_column[data-ident="+data.columnid+"] .board_column_content"))}else if("update_note"===item.action){let note=getNote(data.id);if(note){getNoteHeadingForNote(note);updatingNote==data.id?_notification.default.confirm(strings.note_changed_title,strings.note_changed_text,strings.Ok,strings.Cancel,(function(){stopUpdatingNote()})):updateNote(note,0,data)}}else if("delete_note"===item.action){updatingNote==data.id&&_notification.default.alert(strings.warning,strings.note_deleted_text).then((()=>{stopUpdatingNote()}));let note=getNote(data.id);if(3==sortby){let columnID=note.data("column"),sortorder=note.data("sortorder");sortAfterDelete(columnID,sortorder)}note.remove()}else if("add_column"===item.action)addColumn(data.id,data.name,!1,{},selectHeadingColour());else if("move_column"===item.action){const board=(0,_jquery.default)(".mod_board");data.sortorder.forEach((column=>{board.find(".board_column[data-ident='".concat(column,"']")).detach().appendTo(board)}))}else if("update_column"===item.action)(0,_jquery.default)(".board_column[data-ident='"+data.id+"'] .mod_board_column_name").html(data.name),updateColumnAria(data.id);else if("lock_column"===item.action)(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").attr("data-locked",data.locked),data.locked?(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").find(".board_button.newnote").addClass("d-none"):(0,_jquery.default)(".board_column[data-ident='"+data.id+"']").find(".board_button.newnote").removeClass("d-none"),updateSortable();else if("delete_column"===item.action){var column=(0,_jquery.default)(".board_column[data-ident='"+data.id+"']");updatingNote&&column.find('.board_note[data-ident="'+updatingNote+'"]').length&&_notification.default.alert(strings.warning,strings.column_deleted_text).then((()=>{stopUpdatingNote()})),creatingNote==data.id&&_notification.default.alert(strings.warning,strings.column_deleted_text).then((()=>{creatingNote&&(creatingNoteModal&&creatingNoteModal.destroy(),creatingNote=0,creatingNoteModal=null)})),column.remove()}else if("rate_note"===item.action){var note=getNote(data.id);note.find(".mod_board_rating").html(data.rating),2==sortby&&sortNotes(note.closest(".board_column_content"))}lastHistoryId=item.id}}updateBoard()}))},updateBoard=function(instant){instant?processBoardHistory():options.history_refresh>0&&(reloadTimer&&stopUpdating(),reloadTimer=setTimeout(processBoardHistory,1e3*options.history_refresh))},stopUpdating=function(){clearTimeout(reloadTimer),reloadTimer=null},sortNotes=function(content,toggle){var desc,asc,sortCol=(0,_jquery.default)(content).parent().find(".mod_board_column_sort"),direction=(0,_jquery.default)(content).data("sort");if(direction||(direction=2==sortby?"desc":"asc"),toggle&&(direction="asc"===direction?"desc":"asc"),"asc"===direction?(sortCol.removeClass("fa-angle-down"),sortCol.addClass("fa-angle-up")):(sortCol.removeClass("fa-angle-up"),sortCol.addClass("fa-angle-down")),(0,_jquery.default)(content).data("sort",direction),1==sortby)desc=function(a,b){return(0,_jquery.default)(b).data("sortorder")-(0,_jquery.default)(a).data("sortorder")},asc=function(a,b){return(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder")};else if(2==sortby)desc=function(a,b){return(0,_jquery.default)(b).find(".mod_board_rating").text()-(0,_jquery.default)(a).find(".mod_board_rating").text()||(0,_jquery.default)(b).data("sortorder")-(0,_jquery.default)(a).data("sortorder")},asc=function(a,b){return(0,_jquery.default)(a).find(".mod_board_rating").text()-(0,_jquery.default)(b).find(".mod_board_rating").text()||(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder")};else if(3==sortby){let sortElements=(a,b)=>(0,_jquery.default)(a).data("sortorder")-(0,_jquery.default)(b).data("sortorder");return void(0,_jquery.default)("> .board_note",(0,_jquery.default)(content)).sort(sortElements).appendTo((0,_jquery.default)(content))}(0,_jquery.default)("> .board_note",(0,_jquery.default)(content)).sort("asc"===direction?asc:desc).appendTo((0,_jquery.default)(content))},updateSortable=function(){let fromColumnID;(0,_jquery.default)(".board_column[data-locked='false'] .board_column_content").sortable({connectWith:".board_column[data-locked='false'] .board_column_content",cancel:".mod_board_nosort",handle:".move_note",start:function(_,ui){fromColumnID=(0,_jquery.default)(ui.item).closest(".board_column").data("ident")},stop:function(_,ui){var note=(0,_jquery.default)(ui.item),tocolumn=note.closest(".board_column"),elem=(0,_jquery.default)(this),noteid=note.data("ident"),columnid=tocolumn.data("ident");let sortorder=tocolumn.find(".board_column_content").children().index((0,_jquery.default)(".board_note[data-ident=".concat(noteid,"]")));moveNote(fromColumnID,{id:noteid,columnid:columnid,sortorder:sortorder},elem)}})};const moveNote=(fromColumnID,payload,elem)=>{updateSortOrders(fromColumnID,payload.columnid,payload.id,payload.sortorder),serviceCall("move_note",payload,(result=>{result.status?(lastHistoryId=result.historyid,updateNoteAria(payload.id),updateBoard(),sortNotes((0,_jquery.default)(".board_column[data-ident=".concat(payload.columnid,"] .board_column_content")))):elem&&elem.sortable("cancel")}))},columnSorting=()=>{let movingColumnId;(0,_jquery.default)(".mod_board").sortable({connectWith:".mod_board",axis:"x",containment:".mod_board_wrapper",cancel:".mod_board_nosort",handle:".mod_column_move",start:function(_,ui){movingColumnId=(0,_jquery.default)(ui.item).closest(".board_column").data("ident")},stop:function(_,ui){let column=(0,_jquery.default)(ui.item),sortorder=(0,_jquery.default)(".mod_board").find(".board_column").index(column);moveColumn({id:movingColumnId,sortorder:sortorder})}})},moveColumn=payload=>{serviceCall("move_column",payload,!1)},updateSortOrders=(fromColumnID,toColumnID,noteID,newSortOrder)=>{let toColumn=(0,_jquery.default)(".board_column[data-ident=".concat(toColumnID,"] .board_column_content")),movedNote=(0,_jquery.default)(".board_note[data-ident=".concat(noteID,"]")),oldSortOrder=movedNote.data("sortorder"),toChildren=toColumn.children();if(fromColumnID==toColumnID)toChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");oldSortOrder<newSortOrder?sortOrder<=newSortOrder&&sortOrder>=oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder-1):oldSortOrder>newSortOrder&&sortOrder>=newSortOrder&&sortOrder<=oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder+1)}));else{let fromChildren=(0,_jquery.default)(".board_column[data-ident=".concat(fromColumnID,"] .board_column_content")).children();toChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");sortOrder>=newSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder+1)})),fromChildren.each(((_,note)=>{let sortOrder=(0,_jquery.default)(note).data("sortorder");sortOrder>oldSortOrder&&(0,_jquery.default)(note).data("sortorder",sortOrder-1)}))}movedNote.data("sortorder",newSortOrder)},showNoteCreateModal=function(columnId){const urlParams={columnid:columnId,ownerid:ownerId,groupid:groupId};const modalConfig={formUrl:_url.default.relativeUrl("/mod/board/note_create_ajax.php",urlParams,!1),formSize:"lg",formSubmittedAction:result=>{creatingNote=0,creatingNoteModal=null,lastHistoryId=result.historyid,addNote(columnId,result.note.id,result.note.identifier,result.note.heading,result.note.content,{type:result.note.type,info:result.note.info,url:result.note.url},{id:result.note.userid},result.note.timecreated,result.note.rating),sortNotes((0,_jquery.default)(".board_column[data-ident="+columnId+"] .board_column_content")),updateNoteAria(result.note.id)}};_modal.default.create(modalConfig).then((modal=>{creatingNote=columnId,(creatingNoteModal=modal).getRoot().on(_modal_events.default.hidden,(()=>{creatingNote=0,creatingNoteModal=null}))}))},showColumnCreateModal=function(boardID){const urlParams={boardid:boardID},modalConfig={formUrl:_url.default.relativeUrl("/mod/board/column_create_ajax.php",urlParams,!1),formSize:"sm",formSubmittedAction:"reload"};_modal.default.create(modalConfig)},showColumnUpdateModal=function(columnId){const urlParams={id:columnId},modalConfig={formUrl:_url.default.relativeUrl("/mod/board/column_update_ajax.php",urlParams,!1),formSize:"sm",formSubmittedAction:"reload"};_modal.default.create(modalConfig)},showNoteUpdateModal=function(noteId){const urlParams={id:noteId};const modalConfig={formUrl:_url.default.relativeUrl("/mod/board/note_update_ajax.php",urlParams,!1),formSize:"lg",formSubmittedAction:result=>{updatingNote=0,updateNoteModal=null;const note=getNote(noteId);lastHistoryId=result.historyid,note.attr("data-identifier",result.note.identifier),getNoteTextForNote(note).html(result.note.content),getNoteHeadingForNote(note).html(result.note.heading),updateNoteAria(result.note.id),previewAttachment(note,{type:result.note.type,info:result.note.info,url:result.note.url})}};_modal.default.create(modalConfig).then((modal=>{updatingNote=noteId,(updateNoteModal=modal).getRoot().on(_modal_events.default.hidden,(()=>{updatingNote=0,updateNoteModal=null}))}))};var fullScreenNote=(ident,notecontent)=>{const heading=getNoteHeadingForNote(notecontent).html(),modalBody=(0,_jquery.default)(document.createElement("div"));modalBody.addClass("mod_board_note_content");const text=getNoteTextForNote(notecontent);text&&modalBody.append(text.clone());const preview=(note=notecontent,(0,_jquery.default)(note).find(".mod_board_preview"));var note;preview&&modalBody.append(preview.clone());const commentArea=(0,_jquery.default)(document.createElement("div"));commentArea.attr("data-region","comment-area"),modalBody.append(commentArea),_comments.default.fetchFor(ident,commentArea),_modal_cancel.default.create({title:heading,body:modalBody}).then((function(modal){return modal.setLarge(),(0,_str.get_string)("close_button_text","mod_board").done((function(str){modal.setButtonText("cancel",str)})),modal.show(),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal}),this).catch(_notification.default.exception)},init=function(){serviceCall("get_board",{id:board.id,ownerid:ownerId,groupid:groupId},(function(columns){if(columns)for(var index in columns)addColumn(columns[index].id,columns[index].name,columns[index].locked,columns[index].notes||{},options.colours[columns[index].id%options.colours.length]);var column;isEditor&&((column=(0,_jquery.default)('<div class="board_column_empty"></div>')).append('<div class="board_button newcolumn" role="button" tabindex="0" aria-label="'+strings.aria_newcolumn+'" title="'+strings.aria_newcolumn+'"><div class="button_content"><span class="fa '+options.columnicon+'"></span></div></div>'),handleAction(column.find(".newcolumn"),(function(){showColumnCreateModal(board.id)})),(0,_jquery.default)(".mod_board").append(column)),lastHistoryId=board.historyid,isEditor&&(updateSortable(),columnSorting()),updateBoard()}))},stringsInfo=[];for(var string in strings)stringsInfo.push({key:string,component:"mod_board"});_jquery.default.when((0,_str.get_strings)(stringsInfo)).done((function(results){var index=0;for(string in strings)strings[string]=results[index++];init()}))},_jquery=_interopRequireDefault(_jquery),_ajax=_interopRequireDefault(_ajax),_modal_cancel=_interopRequireDefault(_modal_cancel),_modal_events=_interopRequireDefault(_modal_events),_notification=_interopRequireDefault(_notification),_comments=_interopRequireDefault(_comments),_movenotesdialog=_interopRequireDefault(_movenotesdialog),_movecolumnsdialog=_interopRequireDefault(_movecolumnsdialog),_modal=_interopRequireDefault(_modal),_url=_interopRequireDefault(_url);const decodeText=function(encodedText){return(0,_jquery.default)("<div />").html(encodedText).text()},handleAction=function(elem,callback){return elem.on("click keypress",(function(e){if("keypress"===e.type){if(13!=(key=e.keyCode)&&32!=key)return;e.preventDefault()}var key;callback(),e.preventDefault()}))};return _exports.default}));

//# sourceMappingURL=board.min.js.map