/**
 * @module     local_deepler/deepler
 * @file       amd/src/local/api.js
 * @copyright  2025 Bruno Baudry <bruno.baudry@bfh.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_deepler/local/api",["core/log","core/ajax","./utils","./customevents"],((Log,Ajax,Utils,Events)=>{const deeplService=(args,endPoint,successEvent,failedEvent)=>{Ajax.call([{methodname:endPoint,args:args,done:response=>{Events.emit(successEvent,response)},fail:(jqXHR,status,error)=>{var _ref13,_ref14,_ref15,_jqXHR$debuginfo5;Log.debug("".concat(endPoint," api/translate/fail::jqXHR")),Log.debug(jqXHR),Events.emit(failedEvent,null!==(_ref13=null!==(_ref14=null!==(_ref15=null!==(_jqXHR$debuginfo5=jqXHR.debuginfo)&&void 0!==_jqXHR$debuginfo5?_jqXHR$debuginfo5:jqXHR.message)&&void 0!==_ref15?_ref15:error)&&void 0!==_ref14?_ref14:jqXHR.errorcode)&&void 0!==_ref13?_ref13:"")}}])};return{APP_VERSION:"",GLOSSARY_ENTRIES_SUCCESS:"onGlossaryEntriesSuccess",GLOSSARY_ENTRIES_FAILED:"onGlossaryEntriesFailed",GLOSSARY_DB_SUCCESS:"onDbGlossaryUpdateSuccess",GLOSSARY_DB_FAILED:"onDbGlossaryUpdateFailed",GLOSSARY_DB_ALL_FAILED:"onDbGlossaryUpdateAllFailed",TR_DB_SUCCESS:"onDbUpdateSuccess",TR_DB_FAILED:"onDbUpdateFailed",DEEPL_SUCCESS:"onDeeplTrSuccess",DEEPL_RF_SUCCESS:"onDeeplRfSuccess",DEEPL_FAILED:"onDeeplTrFailed",DEEPL_RF_FAILED:"onDeeplRfFailed",getGlossariesEntries:glossaryId=>{Ajax.call([{methodname:"local_deepler_get_glossary_entries",args:{glossaryid:glossaryId},done:response=>{Events.emit("onGlossaryEntriesSuccess",response)},fail:(jqXHR,status,error)=>{var _ref7,_ref8,_ref9,_jqXHR$debuginfo3;Log.error("api/getGlossariesEntries/fail::jqXHR"),Log.error(jqXHR),Events.emit("onGlossaryEntriesFailed",null!==(_ref7=null!==(_ref8=null!==(_ref9=null!==(_jqXHR$debuginfo3=jqXHR.debuginfo)&&void 0!==_jqXHR$debuginfo3?_jqXHR$debuginfo3:jqXHR.message)&&void 0!==_ref9?_ref9:jqXHR.errorcode)&&void 0!==_ref8?_ref8:status)&&void 0!==_ref7?_ref7:error)}}])},updateGlossariesUsage:glossaries=>{Ajax.call([{methodname:"local_deepler_update_glossary",args:{glossaryids:glossaries},done:response=>{response.forEach((r=>{"error"===r.sattus?Events.emit("onDbGlossaryUpdateFailed",r):Events.emit("onDbGlossaryUpdateSuccess",r)}))},fail:(jqXHR,status,error)=>{var _ref,_ref2,_ref3,_jqXHR$debuginfo;Log.error("api/updateGlossariesUsage/fail::jqXHR"),Log.error(jqXHR),Events.emit("onDbGlossaryUpdateAllFailed",null!==(_ref=null!==(_ref2=null!==(_ref3=null!==(_jqXHR$debuginfo=jqXHR.debuginfo)&&void 0!==_jqXHR$debuginfo?_jqXHR$debuginfo:jqXHR.message)&&void 0!==_ref3?_ref3:jqXHR.errorcode)&&void 0!==_ref2?_ref2:status)&&void 0!==_ref?_ref:error)}}])},updateGlossariesVisibility:(glossaryId,visibility)=>{Ajax.call([{methodname:"local_deepler_update_glossary_visibility",args:{glossaryid:glossaryId,shared:visibility},done:response=>{Events.emit("onDbGlossaryUpdateSuccess",response)},fail:(jqXHR,status,error)=>{var _ref4,_ref5,_ref6,_jqXHR$debuginfo2;Log.error("api/updateGlossariesVisibility/fail::jqXHR"),Log.error(jqXHR),Events.emit("onDbGlossaryUpdateFailed",null!==(_ref4=null!==(_ref5=null!==(_ref6=null!==(_jqXHR$debuginfo2=jqXHR.debuginfo)&&void 0!==_jqXHR$debuginfo2?_jqXHR$debuginfo2:jqXHR.message)&&void 0!==_ref6?_ref6:jqXHR.errorcode)&&void 0!==_ref5?_ref5:status)&&void 0!==_ref4?_ref4:error)}}])},updateTranslationsInDb:(data,userid,courseid)=>{Ajax.call([{methodname:"local_deepler_update_translation",args:{data:data,userid:userid,courseid:courseid,action:"update"},done:response=>{if(1===response.length&&response[0].error&&""===response[0].keyid)return Log.warn("api/updateTranslationsInDb/done::response has errors"),void Events.emit("onDbUpdateFailed",response[0].error);Events.emit("onDbUpdateSuccess",response)},fail:(jqXHR,status,error)=>{var _ref10,_ref11,_ref12,_jqXHR$debuginfo4;Log.error("api/updateTranslationsInDb/fail::jqXHR"),Log.error(jqXHR),Events.emit("onDbUpdateFailed",null!==(_ref10=null!==(_ref11=null!==(_ref12=null!==(_jqXHR$debuginfo4=jqXHR.debuginfo)&&void 0!==_jqXHR$debuginfo4?_jqXHR$debuginfo4:jqXHR.message)&&void 0!==_ref12?_ref12:jqXHR.errorcode)&&void 0!==_ref11?_ref11:status)&&void 0!==_ref10?_ref10:error)}}])},translate:(data,options,version)=>{deeplService({translations:data,options:options,version:version},"local_deepler_get_translation","onDeeplTrSuccess","onDeeplTrFailed")},rephrase:(data,options,version)=>{deeplService({rephrasings:data,options:options,version:version},"local_deepler_get_rephrase","onDeeplRfSuccess","onDeeplRfFailed")}}}));

//# sourceMappingURL=api.min.js.map