/**
 * @module     local_deepler/deepler
 * @file       amd/src/local/translation.js
 * @copyright  2025 Bruno Baudry <bruno.baudry@bfh.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_deepler/local/translation",["core/log","./api","./utils","./selectors","./tokeniser","./customevents"],((Log,Api,Utils,Selectors,Tokeniser,Events)=>{let tempTranslations={},escapePatterns={},mainSourceLang="",deeplSourceLang="",targetLang="",courseid=0,userid=0,rephrasesymbol="";const deeplSettinRegex=/\[(name="local_deepler|data-id="local_deepler)\/(\w+)"\]/i,trSelectors=[Selectors.deepl.tagHandling,Selectors.deepl.context,Selectors.deepl.splitSentences,Selectors.deepl.preserveFormatting,Selectors.deepl.formality,Selectors.deepl.glossaryId,Selectors.deepl.outlineDetection,Selectors.deepl.nonSplittingTags,Selectors.deepl.splittingTags,Selectors.deepl.ignoreTags,Selectors.deepl.modelType],setMainLangs=config=>{void 0!==config.currentlang&&""!==config.currentlang&&(mainSourceLang=config.currentlang),void 0!==config.targetlang&&""!==config.targetlang&&(targetLang=config.targetlang.toLowerCase()),void 0!==config.deeplsourcelang&&""!==config.deeplsourcelang&&(deeplSourceLang=config.deeplsourcelang.toLowerCase())},onTrDbSuccess=data=>{if(0===data.length)Events.emit("onDbFailed","no data returned","");else{const errors=data.filter((item=>""!==item.error));data.forEach((item=>{""===item.error?(tempTranslations[item.keyid].fieldText=item.text,Events.emit("onItemSaved",item.keyid,item.text)):Events.emit("onItemNotSaved",item.keyid,item.error)})),Events.emit("onDbSuccess",errors)}},onTrDbFailed=(status,error)=>{Events.emit("onDbFailed",error,status),Log.trace(status),Log.trace(error)},prepareDbUpdateItem=(item,maineditorIsTextArea)=>{const key=item.key;Log.debug(tempTranslations[key]);const textTosave=getEditorText(tempTranslations[key].editor,maineditorIsTextArea);return Log.debug("translation/x/prepareDbUpdateItem::textTosave"),Log.debug(textTosave),Log.debug(tempTranslations[key]),Log.debug(mainSourceLang),Log.debug(deeplSourceLang),Log.debug(""),{tid:item.tid,text:getEditorText(tempTranslations[key].editor,maineditorIsTextArea),keyid:key,mainsourcecode:mainSourceLang,sourcecode:tempTranslations[key].sourceLang,targetcode:document.querySelector(Selectors.actions.targetCompatibleSwitcher).value,sourcetext:getSourceText(key)}},getEditorText=(editor,maineditorIsTextArea)=>{let text=editor.innerHTML;return maineditorIsTextArea&&(text=Utils.decodeHTML(text)),text},getSourceText=key=>{const sourceTokenised=tempTranslations[key].source;return Tokeniser.postprocess(sourceTokenised,tempTranslations[key].tokens)},onTranslateSuccess=response=>{Log.info(response);const glossaries=[];response.forEach((tr=>{if(""===tr.error){-1===glossaries.indexOf(tr.glossary_id)&&glossaries.push(tr.glossary_id);let key=tr.key,translation=Tokeniser.postprocess(tr.translated_text,tempTranslations[key].tokens);tempTranslations[key].editor.innerHTML=translation,tempTranslations[key].translation=translation,Events.emit("onItemTranslated",key)}else Events.emit("onTranslationFailed",tr.error)})),Api.updateGlossariesUsage(glossaries)},onRephraseSuccess=response=>{response.forEach((tr=>{if(""===tr.error){let key=tr.key,rephrase=Tokeniser.postprocess(tr.text,tempTranslations[key].tokens);tempTranslations[key].editor.innerHTML=rephrase,tempTranslations[key].translation=rephrase,Events.emit("onItemTranslated",key)}else Events.emit("onRephraseFailed",tr.error)}))},onTranslateFailed=(status,error)=>{Events.emit("onTranslationFailed",status,error)},onRephaseFailed=(status,error)=>{Events.emit("onRephraseFailed",status,error)},prepareTranslationSettings=settings=>{const s=filterSetting(settings,trSelectors);return s.target_lang=targetLang.toUpperCase(),s.show_billed_characters=!0,s},prepareRephraseSettings=settings=>{const rephraseSelectors=[Selectors.deepl.toneorstyle],s=filterSetting(settings,rephraseSelectors);return s.target_lang=targetLang.toUpperCase(),s},filterSetting=(settings,selList)=>{const se={};for(let i in selList){se[selList[i].match(deeplSettinRegex)[2]]=settings[selList[i]]}return se};return{init:cfg=>{Api.APP_VERSION=cfg.version,courseid=cfg.courseid,userid=cfg.userid,setMainLangs(cfg)},debugTemp:key=>{Log.debug("translation/x/debugTemp::key"),Log.debug(key),Log.debug(tempTranslations[key])},callTranslations:(keys,config,settings)=>{rephrasesymbol=config.rephrasesymbol;const translations=[],rephrases=[];keys.forEach((key=>{const t=(key=>({text:tempTranslations[key].source,source_lang:tempTranslations[key].sourceLang,key:key}))(key);config.canimprove&&t.source_lang.includes(rephrasesymbol)?(delete t.source_lang,Log.debug("translation/x/callTranslations::t"),Log.debug(t),rephrases.push(t)):translations.push(t)})),translations.length>0&&(Events.on(Api.DEEPL_SUCCESS,onTranslateSuccess),Events.on(Api.DEEPL_FAILED,onTranslateFailed),Api.translate(translations,prepareTranslationSettings(settings),Api.APP_VERSION)),rephrases.length>0&&(Events.on(Api.DEEPL_RF_SUCCESS,onRephraseSuccess),Events.on(Api.DEEPL_RF_FAILED,onRephaseFailed),Api.rephrase(rephrases,prepareRephraseSettings(settings),Api.APP_VERSION))},saveTranslations:(items,config)=>{const data=items.map((item=>prepareDbUpdateItem(item,"textarea"===config.userPrefs)));Log.debug("translation/x/saveTranslations::data"),Log.debug(data),Events.on(Api.TR_DB_SUCCESS,onTrDbSuccess),Events.on(Api.TR_DB_FAILED,onTrDbFailed),Api.updateTranslationsInDb(data,userid,courseid)},initTempForKey:(key,editorSettings,sourceTextEncoded,multilangRawTextEncoded,sourceLang)=>{const sourceText=Utils.fromBase64(sourceTextEncoded),fieldText=Utils.fromBase64(multilangRawTextEncoded),tokenised=Tokeniser.preprocess(sourceText,escapePatterns);tempTranslations[key]={editorType:editorSettings.editorType,editor:editorSettings.editor,source:tokenised.tokenizedText,sourceLang:sourceLang,fieldText:fieldText,status:Selectors.statuses.wait,translation:"",tokens:tokenised.expressions}},initTemp:key=>{tempTranslations[key]={editorType:null,editor:null,source:"",sourceLang:"",fieldText:"",status:"",translation:"",tokens:[]}},setMainLangs:setMainLangs,isTranslatable:()=>""!==targetLang,translated:key=>{var _tempTranslations$key,_tempTranslations$key2;return(null===(_tempTranslations$key=tempTranslations[key])||void 0===_tempTranslations$key||null===(_tempTranslations$key2=_tempTranslations$key.translation)||void 0===_tempTranslations$key2?void 0:_tempTranslations$key2.length)>0},ON_ITEM_TRANSLATED:"onItemTranslated",ON_DB_FAILED:"onDbFailed",ON_ITEM_SAVED:"onItemSaved",ON_ITEM_NOT_SAVED:"onItemNotSaved",ON_TRANSLATION_FAILED:"onTranslationFailed",ON_REPHRASE_FAILED:"onRephraseFailed",ON_DB_SAVE_SUCCESS:"onDbSuccess"}}));

//# sourceMappingURL=translation.min.js.map