define("block_ai_chat/marked.esm",["exports"],(function(_exports){function _getDefaults(){return{async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.defaults=_exports.Tokenizer=_exports.TextRenderer=_exports.Renderer=_exports.Parser=_exports.Marked=_exports.Lexer=_exports.Hooks=void 0,_exports.getDefaults=_getDefaults,_exports.lexer=void 0,_exports.marked=marked,_exports.walkTokens=_exports.use=_exports.setOptions=_exports.parser=_exports.parseInline=_exports.parse=_exports.options=void 0;let _defaults={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};function changeDefaults(newDefaults){_exports.defaults=_defaults=newDefaults}_exports.defaults=_defaults;const escapeTest=/[&<>"']/,escapeReplace=new RegExp(escapeTest.source,"g"),escapeTestNoEncode=/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/,escapeReplaceNoEncode=new RegExp(escapeTestNoEncode.source,"g"),escapeReplacements={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},getEscapeReplacement=ch=>escapeReplacements[ch];function escape$1(html,encode){if(encode){if(escapeTest.test(html))return html.replace(escapeReplace,getEscapeReplacement)}else if(escapeTestNoEncode.test(html))return html.replace(escapeReplaceNoEncode,getEscapeReplacement);return html}const unescapeTest=/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi;function unescape(html){return html.replace(unescapeTest,((_,n)=>"colon"===(n=n.toLowerCase())?":":"#"===n.charAt(0)?"x"===n.charAt(1)?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1)):""))}const caret=/(^|[^\[])\^/g;function edit(regex,opt){let source="string"==typeof regex?regex:regex.source;opt=opt||"";const obj={replace:(name,val)=>{let valSource="string"==typeof val?val:val.source;return valSource=valSource.replace(caret,"$1"),source=source.replace(name,valSource),obj},getRegex:()=>new RegExp(source,opt)};return obj}function cleanUrl(href){try{href=encodeURI(href).replace(/%25/g,"%")}catch(e){return null}return href}const noopTest={exec:()=>null};function splitCells(tableRow,count){const cells=tableRow.replace(/\|/g,((match,offset,str)=>{let escaped=!1,curr=offset;for(;--curr>=0&&"\\"===str[curr];)escaped=!escaped;return escaped?"|":" |"})).split(/ \|/);let i=0;if(cells[0].trim()||cells.shift(),cells.length>0&&!cells[cells.length-1].trim()&&cells.pop(),count)if(cells.length>count)cells.splice(count);else for(;cells.length<count;)cells.push("");for(;i<cells.length;i++)cells[i]=cells[i].trim().replace(/\\\|/g,"|");return cells}function rtrim(str,c,invert){const l=str.length;if(0===l)return"";let suffLen=0;for(;suffLen<l;){const currChar=str.charAt(l-suffLen-1);if(currChar!==c||invert){if(currChar===c||!invert)break;suffLen++}else suffLen++}return str.slice(0,l-suffLen)}function outputLink(cap,link,raw,lexer){const href=link.href,title=link.title?escape$1(link.title):null,text=cap[1].replace(/\\([\[\]])/g,"$1");if("!"!==cap[0].charAt(0)){lexer.state.inLink=!0;const token={type:"link",raw:raw,href:href,title:title,text:text,tokens:lexer.inlineTokens(text)};return lexer.state.inLink=!1,token}return{type:"image",raw:raw,href:href,title:title,text:escape$1(text)}}class _Tokenizer{options;rules;lexer;constructor(options){this.options=options||_defaults}space(src){const cap=this.rules.block.newline.exec(src);if(cap&&cap[0].length>0)return{type:"space",raw:cap[0]}}code(src){const cap=this.rules.block.code.exec(src);if(cap){const text=cap[0].replace(/^ {1,4}/gm,"");return{type:"code",raw:cap[0],codeBlockStyle:"indented",text:this.options.pedantic?text:rtrim(text,"\n")}}}fences(src){const cap=this.rules.block.fences.exec(src);if(cap){const raw=cap[0],text=function(raw,text){const matchIndentToCode=raw.match(/^(\s+)(?:```)/);if(null===matchIndentToCode)return text;const indentToCode=matchIndentToCode[1];return text.split("\n").map((node=>{const matchIndentInNode=node.match(/^\s+/);if(null===matchIndentInNode)return node;const[indentInNode]=matchIndentInNode;return indentInNode.length>=indentToCode.length?node.slice(indentToCode.length):node})).join("\n")}(raw,cap[3]||"");return{type:"code",raw:raw,lang:cap[2]?cap[2].trim().replace(this.rules.inline.anyPunctuation,"$1"):cap[2],text:text}}}heading(src){const cap=this.rules.block.heading.exec(src);if(cap){let text=cap[2].trim();if(/#$/.test(text)){const trimmed=rtrim(text,"#");this.options.pedantic?text=trimmed.trim():trimmed&&!/ $/.test(trimmed)||(text=trimmed.trim())}return{type:"heading",raw:cap[0],depth:cap[1].length,text:text,tokens:this.lexer.inline(text)}}}hr(src){const cap=this.rules.block.hr.exec(src);if(cap)return{type:"hr",raw:cap[0]}}blockquote(src){const cap=this.rules.block.blockquote.exec(src);if(cap){let text=cap[0].replace(/\n {0,3}((?:=+|-+) *)(?=\n|$)/g,"\n    $1");text=rtrim(text.replace(/^ *>[ \t]?/gm,""),"\n");const top=this.lexer.state.top;this.lexer.state.top=!0;const tokens=this.lexer.blockTokens(text);return this.lexer.state.top=top,{type:"blockquote",raw:cap[0],tokens:tokens,text:text}}}list(src){let cap=this.rules.block.list.exec(src);if(cap){let bull=cap[1].trim();const isordered=bull.length>1,list={type:"list",raw:"",ordered:isordered,start:isordered?+bull.slice(0,-1):"",loose:!1,items:[]};bull=isordered?`\\d{1,9}\\${bull.slice(-1)}`:`\\${bull}`,this.options.pedantic&&(bull=isordered?bull:"[*+-]");const itemRegex=new RegExp(`^( {0,3}${bull})((?:[\t ][^\\n]*)?(?:\\n|$))`);let raw="",itemContents="",endsWithBlankLine=!1;for(;src;){let endEarly=!1;if(!(cap=itemRegex.exec(src)))break;if(this.rules.block.hr.test(src))break;raw=cap[0],src=src.substring(raw.length);let line=cap[2].split("\n",1)[0].replace(/^\t+/,(t=>" ".repeat(3*t.length))),nextLine=src.split("\n",1)[0],indent=0;this.options.pedantic?(indent=2,itemContents=line.trimStart()):(indent=cap[2].search(/[^ ]/),indent=indent>4?1:indent,itemContents=line.slice(indent),indent+=cap[1].length);let blankLine=!1;if(!line&&/^ *$/.test(nextLine)&&(raw+=nextLine+"\n",src=src.substring(nextLine.length+1),endEarly=!0),!endEarly){const nextBulletRegex=new RegExp(`^ {0,${Math.min(3,indent-1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ \t][^\\n]*)?(?:\\n|$))`),hrRegex=new RegExp(`^ {0,${Math.min(3,indent-1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`),fencesBeginRegex=new RegExp(`^ {0,${Math.min(3,indent-1)}}(?:\`\`\`|~~~)`),headingBeginRegex=new RegExp(`^ {0,${Math.min(3,indent-1)}}#`);for(;src;){const rawLine=src.split("\n",1)[0];if(nextLine=rawLine,this.options.pedantic&&(nextLine=nextLine.replace(/^ {1,4}(?=( {4})*[^ ])/g,"  ")),fencesBeginRegex.test(nextLine))break;if(headingBeginRegex.test(nextLine))break;if(nextBulletRegex.test(nextLine))break;if(hrRegex.test(src))break;if(nextLine.search(/[^ ]/)>=indent||!nextLine.trim())itemContents+="\n"+nextLine.slice(indent);else{if(blankLine)break;if(line.search(/[^ ]/)>=4)break;if(fencesBeginRegex.test(line))break;if(headingBeginRegex.test(line))break;if(hrRegex.test(line))break;itemContents+="\n"+nextLine}blankLine||nextLine.trim()||(blankLine=!0),raw+=rawLine+"\n",src=src.substring(rawLine.length+1),line=nextLine.slice(indent)}}list.loose||(endsWithBlankLine?list.loose=!0:/\n *\n *$/.test(raw)&&(endsWithBlankLine=!0));let ischecked,istask=null;this.options.gfm&&(istask=/^\[[ xX]\] /.exec(itemContents),istask&&(ischecked="[ ] "!==istask[0],itemContents=itemContents.replace(/^\[[ xX]\] +/,""))),list.items.push({type:"list_item",raw:raw,task:!!istask,checked:ischecked,loose:!1,text:itemContents,tokens:[]}),list.raw+=raw}list.items[list.items.length-1].raw=raw.trimEnd(),list.items[list.items.length-1].text=itemContents.trimEnd(),list.raw=list.raw.trimEnd();for(let i=0;i<list.items.length;i++)if(this.lexer.state.top=!1,list.items[i].tokens=this.lexer.blockTokens(list.items[i].text,[]),!list.loose){const spacers=list.items[i].tokens.filter((t=>"space"===t.type)),hasMultipleLineBreaks=spacers.length>0&&spacers.some((t=>/\n.*\n/.test(t.raw)));list.loose=hasMultipleLineBreaks}if(list.loose)for(let i=0;i<list.items.length;i++)list.items[i].loose=!0;return list}}html(src){const cap=this.rules.block.html.exec(src);if(cap){return{type:"html",block:!0,raw:cap[0],pre:"pre"===cap[1]||"script"===cap[1]||"style"===cap[1],text:cap[0]}}}def(src){const cap=this.rules.block.def.exec(src);if(cap){const tag=cap[1].toLowerCase().replace(/\s+/g," "),href=cap[2]?cap[2].replace(/^<(.*)>$/,"$1").replace(this.rules.inline.anyPunctuation,"$1"):"",title=cap[3]?cap[3].substring(1,cap[3].length-1).replace(this.rules.inline.anyPunctuation,"$1"):cap[3];return{type:"def",tag:tag,raw:cap[0],href:href,title:title}}}table(src){const cap=this.rules.block.table.exec(src);if(!cap)return;if(!/[:|]/.test(cap[2]))return;const headers=splitCells(cap[1]),aligns=cap[2].replace(/^\||\| *$/g,"").split("|"),rows=cap[3]&&cap[3].trim()?cap[3].replace(/\n[ \t]*$/,"").split("\n"):[],item={type:"table",raw:cap[0],header:[],align:[],rows:[]};if(headers.length===aligns.length){for(const align of aligns)/^ *-+: *$/.test(align)?item.align.push("right"):/^ *:-+: *$/.test(align)?item.align.push("center"):/^ *:-+ *$/.test(align)?item.align.push("left"):item.align.push(null);for(const header of headers)item.header.push({text:header,tokens:this.lexer.inline(header)});for(const row of rows)item.rows.push(splitCells(row,item.header.length).map((cell=>({text:cell,tokens:this.lexer.inline(cell)}))));return item}}lheading(src){const cap=this.rules.block.lheading.exec(src);if(cap)return{type:"heading",raw:cap[0],depth:"="===cap[2].charAt(0)?1:2,text:cap[1],tokens:this.lexer.inline(cap[1])}}paragraph(src){const cap=this.rules.block.paragraph.exec(src);if(cap){const text="\n"===cap[1].charAt(cap[1].length-1)?cap[1].slice(0,-1):cap[1];return{type:"paragraph",raw:cap[0],text:text,tokens:this.lexer.inline(text)}}}text(src){const cap=this.rules.block.text.exec(src);if(cap)return{type:"text",raw:cap[0],text:cap[0],tokens:this.lexer.inline(cap[0])}}escape(src){const cap=this.rules.inline.escape.exec(src);if(cap)return{type:"escape",raw:cap[0],text:escape$1(cap[1])}}tag(src){const cap=this.rules.inline.tag.exec(src);if(cap)return!this.lexer.state.inLink&&/^<a /i.test(cap[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&/^<\/a>/i.test(cap[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&/^<(pre|code|kbd|script)(\s|>)/i.test(cap[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(cap[0])&&(this.lexer.state.inRawBlock=!1),{type:"html",raw:cap[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,block:!1,text:cap[0]}}link(src){const cap=this.rules.inline.link.exec(src);if(cap){const trimmedUrl=cap[2].trim();if(!this.options.pedantic&&/^</.test(trimmedUrl)){if(!/>$/.test(trimmedUrl))return;const rtrimSlash=rtrim(trimmedUrl.slice(0,-1),"\\");if((trimmedUrl.length-rtrimSlash.length)%2==0)return}else{const lastParenIndex=function(str,b){if(-1===str.indexOf(b[1]))return-1;let level=0;for(let i=0;i<str.length;i++)if("\\"===str[i])i++;else if(str[i]===b[0])level++;else if(str[i]===b[1]&&(level--,level<0))return i;return-1}(cap[2],"()");if(lastParenIndex>-1){const linkLen=(0===cap[0].indexOf("!")?5:4)+cap[1].length+lastParenIndex;cap[2]=cap[2].substring(0,lastParenIndex),cap[0]=cap[0].substring(0,linkLen).trim(),cap[3]=""}}let href=cap[2],title="";if(this.options.pedantic){const link=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(href);link&&(href=link[1],title=link[3])}else title=cap[3]?cap[3].slice(1,-1):"";return href=href.trim(),/^</.test(href)&&(href=this.options.pedantic&&!/>$/.test(trimmedUrl)?href.slice(1):href.slice(1,-1)),outputLink(cap,{href:href?href.replace(this.rules.inline.anyPunctuation,"$1"):href,title:title?title.replace(this.rules.inline.anyPunctuation,"$1"):title},cap[0],this.lexer)}}reflink(src,links){let cap;if((cap=this.rules.inline.reflink.exec(src))||(cap=this.rules.inline.nolink.exec(src))){const link=links[(cap[2]||cap[1]).replace(/\s+/g," ").toLowerCase()];if(!link){const text=cap[0].charAt(0);return{type:"text",raw:text,text:text}}return outputLink(cap,link,cap[0],this.lexer)}}emStrong(src,maskedSrc){let prevChar=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"",match=this.rules.inline.emStrongLDelim.exec(src);if(!match)return;if(match[3]&&prevChar.match(/[\p{L}\p{N}]/u))return;if(!(match[1]||match[2]||"")||!prevChar||this.rules.inline.punctuation.exec(prevChar)){const lLength=[...match[0]].length-1;let rDelim,rLength,delimTotal=lLength,midDelimTotal=0;const endReg="*"===match[0][0]?this.rules.inline.emStrongRDelimAst:this.rules.inline.emStrongRDelimUnd;for(endReg.lastIndex=0,maskedSrc=maskedSrc.slice(-1*src.length+lLength);null!=(match=endReg.exec(maskedSrc));){if(rDelim=match[1]||match[2]||match[3]||match[4]||match[5]||match[6],!rDelim)continue;if(rLength=[...rDelim].length,match[3]||match[4]){delimTotal+=rLength;continue}if((match[5]||match[6])&&lLength%3&&!((lLength+rLength)%3)){midDelimTotal+=rLength;continue}if(delimTotal-=rLength,delimTotal>0)continue;rLength=Math.min(rLength,rLength+delimTotal+midDelimTotal);const lastCharLength=[...match[0]][0].length,raw=src.slice(0,lLength+match.index+lastCharLength+rLength);if(Math.min(lLength,rLength)%2){const text=raw.slice(1,-1);return{type:"em",raw:raw,text:text,tokens:this.lexer.inlineTokens(text)}}const text=raw.slice(2,-2);return{type:"strong",raw:raw,text:text,tokens:this.lexer.inlineTokens(text)}}}}codespan(src){const cap=this.rules.inline.code.exec(src);if(cap){let text=cap[2].replace(/\n/g," ");const hasNonSpaceChars=/[^ ]/.test(text),hasSpaceCharsOnBothEnds=/^ /.test(text)&&/ $/.test(text);return hasNonSpaceChars&&hasSpaceCharsOnBothEnds&&(text=text.substring(1,text.length-1)),text=escape$1(text,!0),{type:"codespan",raw:cap[0],text:text}}}br(src){const cap=this.rules.inline.br.exec(src);if(cap)return{type:"br",raw:cap[0]}}del(src){const cap=this.rules.inline.del.exec(src);if(cap)return{type:"del",raw:cap[0],text:cap[2],tokens:this.lexer.inlineTokens(cap[2])}}autolink(src){const cap=this.rules.inline.autolink.exec(src);if(cap){let text,href;return"@"===cap[2]?(text=escape$1(cap[1]),href="mailto:"+text):(text=escape$1(cap[1]),href=text),{type:"link",raw:cap[0],text:text,href:href,tokens:[{type:"text",raw:text,text:text}]}}}url(src){let cap;if(cap=this.rules.inline.url.exec(src)){let text,href;if("@"===cap[2])text=escape$1(cap[0]),href="mailto:"+text;else{let prevCapZero;do{var _this$rules$inline$_b;prevCapZero=cap[0],cap[0]=(null===(_this$rules$inline$_b=this.rules.inline._backpedal.exec(cap[0]))||void 0===_this$rules$inline$_b?void 0:_this$rules$inline$_b[0])??""}while(prevCapZero!==cap[0]);text=escape$1(cap[0]),href="www."===cap[1]?"http://"+cap[0]:cap[0]}return{type:"link",raw:cap[0],text:text,href:href,tokens:[{type:"text",raw:text,text:text}]}}}inlineText(src){const cap=this.rules.inline.text.exec(src);if(cap){let text;return text=this.lexer.state.inRawBlock?cap[0]:escape$1(cap[0]),{type:"text",raw:cap[0],text:text}}}}_exports.Tokenizer=_Tokenizer;const hr=/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,bullet=/(?:[*+-]|\d{1,9}[.)])/,lheading=edit(/^(?!bull |blockCode|fences|blockquote|heading|html)((?:.|\n(?!\s*?\n|bull |blockCode|fences|blockquote|heading|html))+?)\n {0,3}(=+|-+) *(?:\n+|$)/).replace(/bull/g,bullet).replace(/blockCode/g,/ {4}/).replace(/fences/g,/ {0,3}(?:`{3,}|~{3,})/).replace(/blockquote/g,/ {0,3}>/).replace(/heading/g,/ {0,3}#{1,6}/).replace(/html/g,/ {0,3}<[^\n>]+>\n/).getRegex(),_paragraph=/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,_blockLabel=/(?!\s*\])(?:\\.|[^\[\]\\])+/,def=edit(/^ {0,3}\[(label)\]: *(?:\n *)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n *)?| *\n *)(title))? *(?:\n+|$)/).replace("label",_blockLabel).replace("title",/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/).getRegex(),list=edit(/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/).replace(/bull/g,bullet).getRegex(),_tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",_comment=/<!--(?:-?>|[\s\S]*?(?:-->|$))/,html=edit("^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$))","i").replace("comment",_comment).replace("tag",_tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),paragraph=edit(_paragraph).replace("hr",hr).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",_tag).getRegex(),blockNormal={blockquote:edit(/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/).replace("paragraph",paragraph).getRegex(),code:/^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,def:def,fences:/^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,hr:hr,html:html,lheading:lheading,list:list,newline:/^(?: *(?:\n|$))+/,paragraph:paragraph,table:noopTest,text:/^[^\n]+/},gfmTable=edit("^ *([^\\n ].*)\\n {0,3}((?:\\| *)?:?-+:? *(?:\\| *:?-+:? *)*(?:\\| *)?)(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)").replace("hr",hr).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",_tag).getRegex(),blockGfm={...blockNormal,table:gfmTable,paragraph:edit(_paragraph).replace("hr",hr).replace("heading"," {0,3}#{1,6}(?:\\s|$)").replace("|lheading","").replace("table",gfmTable).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",_tag).getRegex()},blockPedantic={...blockNormal,html:edit("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",_comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:noopTest,lheading:/^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/,paragraph:edit(_paragraph).replace("hr",hr).replace("heading"," *#{1,6} *[^\n]").replace("lheading",lheading).replace("|table","").replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").replace("|tag","").getRegex()},escape=/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,br=/^( {2,}|\\)\n(?!\s*$)/,punctuation=edit(/^((?![*_])[\spunctuation])/,"u").replace(/punctuation/g,"\\p{P}\\p{S}").getRegex(),emStrongLDelim=edit(/^(?:\*+(?:((?!\*)[punct])|[^\s*]))|^_+(?:((?!_)[punct])|([^\s_]))/,"u").replace(/punct/g,"\\p{P}\\p{S}").getRegex(),emStrongRDelimAst=edit("^[^_*]*?__[^_*]*?\\*[^_*]*?(?=__)|[^*]+(?=[^*])|(?!\\*)[punct](\\*+)(?=[\\s]|$)|[^punct\\s](\\*+)(?!\\*)(?=[punct\\s]|$)|(?!\\*)[punct\\s](\\*+)(?=[^punct\\s])|[\\s](\\*+)(?!\\*)(?=[punct])|(?!\\*)[punct](\\*+)(?!\\*)(?=[punct])|[^punct\\s](\\*+)(?=[^punct\\s])","gu").replace(/punct/g,"\\p{P}\\p{S}").getRegex(),emStrongRDelimUnd=edit("^[^_*]*?\\*\\*[^_*]*?_[^_*]*?(?=\\*\\*)|[^_]+(?=[^_])|(?!_)[punct](_+)(?=[\\s]|$)|[^punct\\s](_+)(?!_)(?=[punct\\s]|$)|(?!_)[punct\\s](_+)(?=[^punct\\s])|[\\s](_+)(?!_)(?=[punct])|(?!_)[punct](_+)(?!_)(?=[punct])","gu").replace(/punct/g,"\\p{P}\\p{S}").getRegex(),anyPunctuation=edit(/\\([punct])/,"gu").replace(/punct/g,"\\p{P}\\p{S}").getRegex(),autolink=edit(/^<(scheme:[^\s\x00-\x1f<>]*|email)>/).replace("scheme",/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/).replace("email",/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/).getRegex(),_inlineComment=edit(_comment).replace("(?:--\x3e|$)","--\x3e").getRegex(),tag=edit("^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>").replace("comment",_inlineComment).replace("attribute",/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/).getRegex(),_inlineLabel=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,link=edit(/^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/).replace("label",_inlineLabel).replace("href",/<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/).replace("title",/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/).getRegex(),reflink=edit(/^!?\[(label)\]\[(ref)\]/).replace("label",_inlineLabel).replace("ref",_blockLabel).getRegex(),nolink=edit(/^!?\[(ref)\](?:\[\])?/).replace("ref",_blockLabel).getRegex(),inlineNormal={_backpedal:noopTest,anyPunctuation:anyPunctuation,autolink:autolink,blockSkip:/\[[^[\]]*?\]\([^\(\)]*?\)|`[^`]*?`|<[^<>]*?>/g,br:br,code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,del:noopTest,emStrongLDelim:emStrongLDelim,emStrongRDelimAst:emStrongRDelimAst,emStrongRDelimUnd:emStrongRDelimUnd,escape:escape,link:link,nolink:nolink,punctuation:punctuation,reflink:reflink,reflinkSearch:edit("reflink|nolink(?!\\()","g").replace("reflink",reflink).replace("nolink",nolink).getRegex(),tag:tag,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,url:noopTest},inlinePedantic={...inlineNormal,link:edit(/^!?\[(label)\]\((.*?)\)/).replace("label",_inlineLabel).getRegex(),reflink:edit(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",_inlineLabel).getRegex()},inlineGfm={...inlineNormal,escape:edit(escape).replace("])","~|])").getRegex(),url:edit(/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,"i").replace("email",/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/).getRegex(),_backpedal:/(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/},inlineBreaks={...inlineGfm,br:edit(br).replace("{2,}","*").getRegex(),text:edit(inlineGfm.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()},block={normal:blockNormal,gfm:blockGfm,pedantic:blockPedantic},inline={normal:inlineNormal,gfm:inlineGfm,breaks:inlineBreaks,pedantic:inlinePedantic};class _Lexer{tokens;options;state;tokenizer;inlineQueue;constructor(options){this.tokens=[],this.tokens.links=Object.create(null),this.options=options||_defaults,this.options.tokenizer=this.options.tokenizer||new _Tokenizer,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};const rules={block:block.normal,inline:inline.normal};this.options.pedantic?(rules.block=block.pedantic,rules.inline=inline.pedantic):this.options.gfm&&(rules.block=block.gfm,this.options.breaks?rules.inline=inline.breaks:rules.inline=inline.gfm),this.tokenizer.rules=rules}static get rules(){return{block:block,inline:inline}}static lex(src,options){return new _Lexer(options).lex(src)}static lexInline(src,options){return new _Lexer(options).inlineTokens(src)}lex(src){src=src.replace(/\r\n|\r/g,"\n"),this.blockTokens(src,this.tokens);for(let i=0;i<this.inlineQueue.length;i++){const next=this.inlineQueue[i];this.inlineTokens(next.src,next.tokens)}return this.inlineQueue=[],this.tokens}blockTokens(src){let token,lastToken,cutSrc,lastParagraphClipped,tokens=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];for(src=this.options.pedantic?src.replace(/\t/g,"    ").replace(/^ +$/gm,""):src.replace(/^( *)(\t+)/gm,((_,leading,tabs)=>leading+"    ".repeat(tabs.length)));src;)if(!(this.options.extensions&&this.options.extensions.block&&this.options.extensions.block.some((extTokenizer=>!!(token=extTokenizer.call({lexer:this},src,tokens))&&(src=src.substring(token.raw.length),tokens.push(token),!0)))))if(token=this.tokenizer.space(src))src=src.substring(token.raw.length),1===token.raw.length&&tokens.length>0?tokens[tokens.length-1].raw+="\n":tokens.push(token);else if(token=this.tokenizer.code(src))src=src.substring(token.raw.length),lastToken=tokens[tokens.length-1],!lastToken||"paragraph"!==lastToken.type&&"text"!==lastToken.type?tokens.push(token):(lastToken.raw+="\n"+token.raw,lastToken.text+="\n"+token.text,this.inlineQueue[this.inlineQueue.length-1].src=lastToken.text);else if(token=this.tokenizer.fences(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.heading(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.hr(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.blockquote(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.list(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.html(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.def(src))src=src.substring(token.raw.length),lastToken=tokens[tokens.length-1],!lastToken||"paragraph"!==lastToken.type&&"text"!==lastToken.type?this.tokens.links[token.tag]||(this.tokens.links[token.tag]={href:token.href,title:token.title}):(lastToken.raw+="\n"+token.raw,lastToken.text+="\n"+token.raw,this.inlineQueue[this.inlineQueue.length-1].src=lastToken.text);else if(token=this.tokenizer.table(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.lheading(src))src=src.substring(token.raw.length),tokens.push(token);else{if(cutSrc=src,this.options.extensions&&this.options.extensions.startBlock){let startIndex=1/0;const tempSrc=src.slice(1);let tempStart;this.options.extensions.startBlock.forEach((getStartIndex=>{tempStart=getStartIndex.call({lexer:this},tempSrc),"number"==typeof tempStart&&tempStart>=0&&(startIndex=Math.min(startIndex,tempStart))})),startIndex<1/0&&startIndex>=0&&(cutSrc=src.substring(0,startIndex+1))}if(this.state.top&&(token=this.tokenizer.paragraph(cutSrc)))lastToken=tokens[tokens.length-1],lastParagraphClipped&&"paragraph"===lastToken.type?(lastToken.raw+="\n"+token.raw,lastToken.text+="\n"+token.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=lastToken.text):tokens.push(token),lastParagraphClipped=cutSrc.length!==src.length,src=src.substring(token.raw.length);else if(token=this.tokenizer.text(src))src=src.substring(token.raw.length),lastToken=tokens[tokens.length-1],lastToken&&"text"===lastToken.type?(lastToken.raw+="\n"+token.raw,lastToken.text+="\n"+token.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=lastToken.text):tokens.push(token);else if(src){const errMsg="Infinite loop on byte: "+src.charCodeAt(0);if(this.options.silent){console.error(errMsg);break}throw new Error(errMsg)}}return this.state.top=!0,tokens}inline(src){let tokens=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];return this.inlineQueue.push({src:src,tokens:tokens}),tokens}inlineTokens(src){let token,lastToken,cutSrc,match,keepPrevChar,prevChar,tokens=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],maskedSrc=src;if(this.tokens.links){const links=Object.keys(this.tokens.links);if(links.length>0)for(;null!=(match=this.tokenizer.rules.inline.reflinkSearch.exec(maskedSrc));)links.includes(match[0].slice(match[0].lastIndexOf("[")+1,-1))&&(maskedSrc=maskedSrc.slice(0,match.index)+"["+"a".repeat(match[0].length-2)+"]"+maskedSrc.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(match=this.tokenizer.rules.inline.blockSkip.exec(maskedSrc));)maskedSrc=maskedSrc.slice(0,match.index)+"["+"a".repeat(match[0].length-2)+"]"+maskedSrc.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);for(;null!=(match=this.tokenizer.rules.inline.anyPunctuation.exec(maskedSrc));)maskedSrc=maskedSrc.slice(0,match.index)+"++"+maskedSrc.slice(this.tokenizer.rules.inline.anyPunctuation.lastIndex);for(;src;)if(keepPrevChar||(prevChar=""),keepPrevChar=!1,!(this.options.extensions&&this.options.extensions.inline&&this.options.extensions.inline.some((extTokenizer=>!!(token=extTokenizer.call({lexer:this},src,tokens))&&(src=src.substring(token.raw.length),tokens.push(token),!0)))))if(token=this.tokenizer.escape(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.tag(src))src=src.substring(token.raw.length),lastToken=tokens[tokens.length-1],lastToken&&"text"===token.type&&"text"===lastToken.type?(lastToken.raw+=token.raw,lastToken.text+=token.text):tokens.push(token);else if(token=this.tokenizer.link(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.reflink(src,this.tokens.links))src=src.substring(token.raw.length),lastToken=tokens[tokens.length-1],lastToken&&"text"===token.type&&"text"===lastToken.type?(lastToken.raw+=token.raw,lastToken.text+=token.text):tokens.push(token);else if(token=this.tokenizer.emStrong(src,maskedSrc,prevChar))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.codespan(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.br(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.del(src))src=src.substring(token.raw.length),tokens.push(token);else if(token=this.tokenizer.autolink(src))src=src.substring(token.raw.length),tokens.push(token);else if(this.state.inLink||!(token=this.tokenizer.url(src))){if(cutSrc=src,this.options.extensions&&this.options.extensions.startInline){let startIndex=1/0;const tempSrc=src.slice(1);let tempStart;this.options.extensions.startInline.forEach((getStartIndex=>{tempStart=getStartIndex.call({lexer:this},tempSrc),"number"==typeof tempStart&&tempStart>=0&&(startIndex=Math.min(startIndex,tempStart))})),startIndex<1/0&&startIndex>=0&&(cutSrc=src.substring(0,startIndex+1))}if(token=this.tokenizer.inlineText(cutSrc))src=src.substring(token.raw.length),"_"!==token.raw.slice(-1)&&(prevChar=token.raw.slice(-1)),keepPrevChar=!0,lastToken=tokens[tokens.length-1],lastToken&&"text"===lastToken.type?(lastToken.raw+=token.raw,lastToken.text+=token.text):tokens.push(token);else if(src){const errMsg="Infinite loop on byte: "+src.charCodeAt(0);if(this.options.silent){console.error(errMsg);break}throw new Error(errMsg)}}else src=src.substring(token.raw.length),tokens.push(token);return tokens}}_exports.Lexer=_Lexer;class _Renderer{options;constructor(options){this.options=options||_defaults}code(code,infostring,escaped){var _match;const lang=null===(_match=(infostring||"").match(/^\S*/))||void 0===_match?void 0:_match[0];return code=code.replace(/\n$/,"")+"\n",lang?'<pre><code class="language-'+escape$1(lang)+'">'+(escaped?code:escape$1(code,!0))+"</code></pre>\n":"<pre><code>"+(escaped?code:escape$1(code,!0))+"</code></pre>\n"}blockquote(quote){return`<blockquote>\n${quote}</blockquote>\n`}html(html,block){return html}heading(text,level,raw){return`<h${level}>${text}</h${level}>\n`}hr(){return"<hr>\n"}list(body,ordered,start){const type=ordered?"ol":"ul";return"<"+type+(ordered&&1!==start?' start="'+start+'"':"")+">\n"+body+"</"+type+">\n"}listitem(text,task,checked){return`<li>${text}</li>\n`}checkbox(checked){return"<input "+(checked?'checked="" ':"")+'disabled="" type="checkbox">'}paragraph(text){return`<p>${text}</p>\n`}table(header,body){return body&&(body=`<tbody>${body}</tbody>`),"<table>\n<thead>\n"+header+"</thead>\n"+body+"</table>\n"}tablerow(content){return`<tr>\n${content}</tr>\n`}tablecell(content,flags){const type=flags.header?"th":"td";return(flags.align?`<${type} align="${flags.align}">`:`<${type}>`)+content+`</${type}>\n`}strong(text){return`<strong>${text}</strong>`}em(text){return`<em>${text}</em>`}codespan(text){return`<code>${text}</code>`}br(){return"<br>"}del(text){return`<del>${text}</del>`}link(href,title,text){const cleanHref=cleanUrl(href);if(null===cleanHref)return text;let out='<a href="'+(href=cleanHref)+'"';return title&&(out+=' title="'+title+'"'),out+=">"+text+"</a>",out}image(href,title,text){const cleanHref=cleanUrl(href);if(null===cleanHref)return text;let out=`<img src="${href=cleanHref}" alt="${text}"`;return title&&(out+=` title="${title}"`),out+=">",out}text(text){return text}}_exports.Renderer=_Renderer;class _TextRenderer{strong(text){return text}em(text){return text}codespan(text){return text}del(text){return text}html(text){return text}text(text){return text}link(href,title,text){return""+text}image(href,title,text){return""+text}br(){return""}}_exports.TextRenderer=_TextRenderer;class _Parser{options;renderer;textRenderer;constructor(options){this.options=options||_defaults,this.options.renderer=this.options.renderer||new _Renderer,this.renderer=this.options.renderer,this.renderer.options=this.options,this.textRenderer=new _TextRenderer}static parse(tokens,options){return new _Parser(options).parse(tokens)}static parseInline(tokens,options){return new _Parser(options).parseInline(tokens)}parse(tokens){let top=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],out="";for(let i=0;i<tokens.length;i++){const token=tokens[i];if(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[token.type]){const genericToken=token,ret=this.options.extensions.renderers[genericToken.type].call({parser:this},genericToken);if(!1!==ret||!["space","hr","heading","code","table","blockquote","list","html","paragraph","text"].includes(genericToken.type)){out+=ret||"";continue}}switch(token.type){case"space":continue;case"hr":out+=this.renderer.hr();continue;case"heading":{const headingToken=token;out+=this.renderer.heading(this.parseInline(headingToken.tokens),headingToken.depth,unescape(this.parseInline(headingToken.tokens,this.textRenderer)));continue}case"code":{const codeToken=token;out+=this.renderer.code(codeToken.text,codeToken.lang,!!codeToken.escaped);continue}case"table":{const tableToken=token;let header="",cell="";for(let j=0;j<tableToken.header.length;j++)cell+=this.renderer.tablecell(this.parseInline(tableToken.header[j].tokens),{header:!0,align:tableToken.align[j]});header+=this.renderer.tablerow(cell);let body="";for(let j=0;j<tableToken.rows.length;j++){const row=tableToken.rows[j];cell="";for(let k=0;k<row.length;k++)cell+=this.renderer.tablecell(this.parseInline(row[k].tokens),{header:!1,align:tableToken.align[k]});body+=this.renderer.tablerow(cell)}out+=this.renderer.table(header,body);continue}case"blockquote":{const blockquoteToken=token,body=this.parse(blockquoteToken.tokens);out+=this.renderer.blockquote(body);continue}case"list":{const listToken=token,ordered=listToken.ordered,start=listToken.start,loose=listToken.loose;let body="";for(let j=0;j<listToken.items.length;j++){const item=listToken.items[j],checked=item.checked,task=item.task;let itemBody="";if(item.task){const checkbox=this.renderer.checkbox(!!checked);loose?item.tokens.length>0&&"paragraph"===item.tokens[0].type?(item.tokens[0].text=checkbox+" "+item.tokens[0].text,item.tokens[0].tokens&&item.tokens[0].tokens.length>0&&"text"===item.tokens[0].tokens[0].type&&(item.tokens[0].tokens[0].text=checkbox+" "+item.tokens[0].tokens[0].text)):item.tokens.unshift({type:"text",text:checkbox+" "}):itemBody+=checkbox+" "}itemBody+=this.parse(item.tokens,loose),body+=this.renderer.listitem(itemBody,task,!!checked)}out+=this.renderer.list(body,ordered,start);continue}case"html":{const htmlToken=token;out+=this.renderer.html(htmlToken.text,htmlToken.block);continue}case"paragraph":{const paragraphToken=token;out+=this.renderer.paragraph(this.parseInline(paragraphToken.tokens));continue}case"text":{let textToken=token,body=textToken.tokens?this.parseInline(textToken.tokens):textToken.text;for(;i+1<tokens.length&&"text"===tokens[i+1].type;)textToken=tokens[++i],body+="\n"+(textToken.tokens?this.parseInline(textToken.tokens):textToken.text);out+=top?this.renderer.paragraph(body):body;continue}default:{const errMsg='Token with "'+token.type+'" type was not found.';if(this.options.silent)return console.error(errMsg),"";throw new Error(errMsg)}}}return out}parseInline(tokens,renderer){renderer=renderer||this.renderer;let out="";for(let i=0;i<tokens.length;i++){const token=tokens[i];if(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[token.type]){const ret=this.options.extensions.renderers[token.type].call({parser:this},token);if(!1!==ret||!["escape","html","link","image","strong","em","codespan","br","del","text"].includes(token.type)){out+=ret||"";continue}}switch(token.type){case"escape":{const escapeToken=token;out+=renderer.text(escapeToken.text);break}case"html":{const tagToken=token;out+=renderer.html(tagToken.text);break}case"link":{const linkToken=token;out+=renderer.link(linkToken.href,linkToken.title,this.parseInline(linkToken.tokens,renderer));break}case"image":{const imageToken=token;out+=renderer.image(imageToken.href,imageToken.title,imageToken.text);break}case"strong":{const strongToken=token;out+=renderer.strong(this.parseInline(strongToken.tokens,renderer));break}case"em":{const emToken=token;out+=renderer.em(this.parseInline(emToken.tokens,renderer));break}case"codespan":{const codespanToken=token;out+=renderer.codespan(codespanToken.text);break}case"br":out+=renderer.br();break;case"del":{const delToken=token;out+=renderer.del(this.parseInline(delToken.tokens,renderer));break}case"text":{const textToken=token;out+=renderer.text(textToken.text);break}default:{const errMsg='Token with "'+token.type+'" type was not found.';if(this.options.silent)return console.error(errMsg),"";throw new Error(errMsg)}}}return out}}_exports.Parser=_Parser;class _Hooks{options;constructor(options){this.options=options||_defaults}static passThroughHooks=new Set(["preprocess","postprocess","processAllTokens"]);preprocess(markdown){return markdown}postprocess(html){return html}processAllTokens(tokens){return tokens}}_exports.Hooks=_Hooks;class Marked{defaults={async:!1,breaks:!1,extensions:null,gfm:!0,hooks:null,pedantic:!1,renderer:null,silent:!1,tokenizer:null,walkTokens:null};options=this.setOptions;parse=this.#parseMarkdown(_Lexer.lex,_Parser.parse);parseInline=this.#parseMarkdown(_Lexer.lexInline,_Parser.parseInline);Parser=_Parser;Renderer=_Renderer;TextRenderer=_TextRenderer;Lexer=_Lexer;Tokenizer=_Tokenizer;Hooks=_Hooks;constructor(){this.use(...arguments)}walkTokens(tokens,callback){let values=[];for(const token of tokens)switch(values=values.concat(callback.call(this,token)),token.type){case"table":{const tableToken=token;for(const cell of tableToken.header)values=values.concat(this.walkTokens(cell.tokens,callback));for(const row of tableToken.rows)for(const cell of row)values=values.concat(this.walkTokens(cell.tokens,callback));break}case"list":{const listToken=token;values=values.concat(this.walkTokens(listToken.items,callback));break}default:{var _this$defaults$extens,_this$defaults$extens2;const genericToken=token;null!==(_this$defaults$extens=this.defaults.extensions)&&void 0!==_this$defaults$extens&&null!==(_this$defaults$extens2=_this$defaults$extens.childTokens)&&void 0!==_this$defaults$extens2&&_this$defaults$extens2[genericToken.type]?this.defaults.extensions.childTokens[genericToken.type].forEach((childTokens=>{const tokens=genericToken[childTokens].flat(1/0);values=values.concat(this.walkTokens(tokens,callback))})):genericToken.tokens&&(values=values.concat(this.walkTokens(genericToken.tokens,callback)))}}return values}use(){const extensions=this.defaults.extensions||{renderers:{},childTokens:{}};for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];return args.forEach((pack=>{const opts={...pack};if(opts.async=this.defaults.async||opts.async||!1,pack.extensions&&(pack.extensions.forEach((ext=>{if(!ext.name)throw new Error("extension name required");if("renderer"in ext){const prevRenderer=extensions.renderers[ext.name];extensions.renderers[ext.name]=prevRenderer?function(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++)args[_key2]=arguments[_key2];let ret=ext.renderer.apply(this,args);return!1===ret&&(ret=prevRenderer.apply(this,args)),ret}:ext.renderer}if("tokenizer"in ext){if(!ext.level||"block"!==ext.level&&"inline"!==ext.level)throw new Error("extension level must be 'block' or 'inline'");const extLevel=extensions[ext.level];extLevel?extLevel.unshift(ext.tokenizer):extensions[ext.level]=[ext.tokenizer],ext.start&&("block"===ext.level?extensions.startBlock?extensions.startBlock.push(ext.start):extensions.startBlock=[ext.start]:"inline"===ext.level&&(extensions.startInline?extensions.startInline.push(ext.start):extensions.startInline=[ext.start]))}"childTokens"in ext&&ext.childTokens&&(extensions.childTokens[ext.name]=ext.childTokens)})),opts.extensions=extensions),pack.renderer){const renderer=this.defaults.renderer||new _Renderer(this.defaults);for(const prop in pack.renderer){if(!(prop in renderer))throw new Error(`renderer '${prop}' does not exist`);if("options"===prop)continue;const rendererProp=prop,rendererFunc=pack.renderer[rendererProp],prevRenderer=renderer[rendererProp];renderer[rendererProp]=function(){for(var _len3=arguments.length,args=new Array(_len3),_key3=0;_key3<_len3;_key3++)args[_key3]=arguments[_key3];let ret=rendererFunc.apply(renderer,args);return!1===ret&&(ret=prevRenderer.apply(renderer,args)),ret||""}}opts.renderer=renderer}if(pack.tokenizer){const tokenizer=this.defaults.tokenizer||new _Tokenizer(this.defaults);for(const prop in pack.tokenizer){if(!(prop in tokenizer))throw new Error(`tokenizer '${prop}' does not exist`);if(["options","rules","lexer"].includes(prop))continue;const tokenizerProp=prop,tokenizerFunc=pack.tokenizer[tokenizerProp],prevTokenizer=tokenizer[tokenizerProp];tokenizer[tokenizerProp]=function(){for(var _len4=arguments.length,args=new Array(_len4),_key4=0;_key4<_len4;_key4++)args[_key4]=arguments[_key4];let ret=tokenizerFunc.apply(tokenizer,args);return!1===ret&&(ret=prevTokenizer.apply(tokenizer,args)),ret}}opts.tokenizer=tokenizer}if(pack.hooks){const hooks=this.defaults.hooks||new _Hooks;for(const prop in pack.hooks){if(!(prop in hooks))throw new Error(`hook '${prop}' does not exist`);if("options"===prop)continue;const hooksProp=prop,hooksFunc=pack.hooks[hooksProp],prevHook=hooks[hooksProp];_Hooks.passThroughHooks.has(prop)?hooks[hooksProp]=arg=>{if(this.defaults.async)return Promise.resolve(hooksFunc.call(hooks,arg)).then((ret=>prevHook.call(hooks,ret)));const ret=hooksFunc.call(hooks,arg);return prevHook.call(hooks,ret)}:hooks[hooksProp]=function(){for(var _len5=arguments.length,args=new Array(_len5),_key5=0;_key5<_len5;_key5++)args[_key5]=arguments[_key5];let ret=hooksFunc.apply(hooks,args);return!1===ret&&(ret=prevHook.apply(hooks,args)),ret}}opts.hooks=hooks}if(pack.walkTokens){const walkTokens=this.defaults.walkTokens,packWalktokens=pack.walkTokens;opts.walkTokens=function(token){let values=[];return values.push(packWalktokens.call(this,token)),walkTokens&&(values=values.concat(walkTokens.call(this,token))),values}}this.defaults={...this.defaults,...opts}})),this}setOptions(opt){return this.defaults={...this.defaults,...opt},this}lexer(src,options){return _Lexer.lex(src,options??this.defaults)}parser(tokens,options){return _Parser.parse(tokens,options??this.defaults)}#parseMarkdown(lexer,parser){return(src,options)=>{const origOpt={...options},opt={...this.defaults,...origOpt};!0===this.defaults.async&&!1===origOpt.async&&(opt.silent||console.warn("marked(): The async option was set to true by an extension. The async: false option sent to parse will be ignored."),opt.async=!0);const throwError=this.#onError(!!opt.silent,!!opt.async);if(null==src)return throwError(new Error("marked(): input parameter is undefined or null"));if("string"!=typeof src)return throwError(new Error("marked(): input parameter is of type "+Object.prototype.toString.call(src)+", string expected"));if(opt.hooks&&(opt.hooks.options=opt),opt.async)return Promise.resolve(opt.hooks?opt.hooks.preprocess(src):src).then((src=>lexer(src,opt))).then((tokens=>opt.hooks?opt.hooks.processAllTokens(tokens):tokens)).then((tokens=>opt.walkTokens?Promise.all(this.walkTokens(tokens,opt.walkTokens)).then((()=>tokens)):tokens)).then((tokens=>parser(tokens,opt))).then((html=>opt.hooks?opt.hooks.postprocess(html):html)).catch(throwError);try{opt.hooks&&(src=opt.hooks.preprocess(src));let tokens=lexer(src,opt);opt.hooks&&(tokens=opt.hooks.processAllTokens(tokens)),opt.walkTokens&&this.walkTokens(tokens,opt.walkTokens);let html=parser(tokens,opt);return opt.hooks&&(html=opt.hooks.postprocess(html)),html}catch(e){return throwError(e)}}}#onError(silent,async){return e=>{if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",silent){const msg="<p>An error occurred:</p><pre>"+escape$1(e.message+"",!0)+"</pre>";return async?Promise.resolve(msg):msg}if(async)return Promise.reject(e);throw e}}}_exports.Marked=Marked;const markedInstance=new Marked;function marked(src,opt){return markedInstance.parse(src,opt)}marked.options=marked.setOptions=function(options){return markedInstance.setOptions(options),marked.defaults=markedInstance.defaults,changeDefaults(marked.defaults),marked},marked.getDefaults=_getDefaults,marked.defaults=_defaults,marked.use=function(){return markedInstance.use(...arguments),marked.defaults=markedInstance.defaults,changeDefaults(marked.defaults),marked},marked.walkTokens=function(tokens,callback){return markedInstance.walkTokens(tokens,callback)},marked.parseInline=markedInstance.parseInline,marked.Parser=_Parser,marked.parser=_Parser.parse,marked.Renderer=_Renderer,marked.TextRenderer=_TextRenderer,marked.Lexer=_Lexer,marked.lexer=_Lexer.lex,marked.Tokenizer=_Tokenizer,marked.Hooks=_Hooks,marked.parse=marked;const options=marked.options;_exports.options=options;const setOptions=marked.setOptions;_exports.setOptions=setOptions;const use=marked.use;_exports.use=use;const walkTokens=marked.walkTokens;_exports.walkTokens=walkTokens;const parseInline=marked.parseInline;_exports.parseInline=parseInline;const parse=marked;_exports.parse=parse;const parser=_Parser.parse;_exports.parser=parser;const lexer=_Lexer.lex;_exports.lexer=lexer}));

//# sourceMappingURL=marked.esm.min.js.map