define("block_ai_chat/components/chat",["exports","block_ai_chat/components/base_content","tiny_ai/utils","tiny_ai/editor_utils","tiny_ai/constants","core/templates","local_ai_manager/config","core/str","core/notification","block_ai_chat/utils","block_ai_chat/constants","block_ai_chat/dom_extractor","core/utils"],(function(_exports,_base_content,TinyAiUtils,_editor_utils,_constants,_templates,_config,_str,_notification,_utils2,_constants2,DomExtractor,_utils3){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_base_content=_interopRequireDefault(_base_content),TinyAiUtils=_interopRequireWildcard(TinyAiUtils),_editor_utils=_interopRequireDefault(_editor_utils),_templates=_interopRequireDefault(_templates),DomExtractor=_interopRequireWildcard(DomExtractor);class Chat extends _base_content.default{static init(target){return new this({element:document.querySelector(target)})}create(){this.name="ChatComponent",this.selectors={MESSAGES:"[data-block_ai_chat-element='messages']",INPUT_TEXTAREA:"[data-block_ai_chat-element='inputtextarea']",SUBMIT_BUTTON:"[data-block_ai_chat-element='submitbutton']",LOADING_SPINNER_MESSAGE:"[data-block_ai_chat-element='loadingspinner']",TEMPORARY_PROMPT_MESSAGE:"[data-block_ai_chat-element='temporaryprompt']",TINY_AI_BUTTON:"[data-block_ai_chat-element='tinyaibutton']",OUTPUT_WRAPPER:"[data-block_ai_chat-element='outputwrapper']",CHAT_OUTPUT:"[data-block_ai_chat-element='chatoutput']",HISTORY_MARKER:"[data-block_ai_chat-element='historymarker']"},this._debouncedScrollToBottom=(0,_utils3.debounce)(this._scrollToBottom.bind(this),250),this._debouncedFocusInputTextarea=(0,_utils3.debounce)(this._focusInputTextarea.bind(this),250)}async stateReady(){this.reactive.dispatch("setView","chat")}getWatchers(){return[...super.getWatchers(),{watch:"messages:created",handler:this._addMessageToChatArea},{watch:"personas".concat(this.reactive.state.config.currentPersona,":deleted"),handler:this._removeCurrentPersona},{watch:"config.loadingState:updated",handler:this._handleLoadingStateUpdated}]}async _addMessageToChatArea(_ref){let{element:element}=_ref,placeholder=document.createElement("div");placeholder.setAttribute("data-id",element.id);let node=this.getElement(this.selectors.CHAT_OUTPUT);node.appendChild(placeholder);const responseIsAgentResponse="agent"===element.messageMode;let templateData={id:element.id,agentMode:responseIsAgentResponse,senderai:"ai"===element.sender,loading:!!element.hasOwnProperty("loading")&&element.loading};if(responseIsAgentResponse){const agentResponse=responseIsAgentResponse?this._getAgentAnswerTemplateContext(element.content):{};templateData={...templateData,...agentResponse}}else templateData.content=element.content;const newelement=(await this.renderComponent(placeholder,"block_ai_chat/components/message",templateData)).getElement();node.replaceChild(newelement,placeholder),this.reactive.dispatch("setMessageRendered",element.id,!0),this._debouncedScrollToBottom(),this._debouncedFocusInputTextarea()}async _submitAiRequestListener(){const prompt=this.getElement(this.selectors.INPUT_TEXTAREA).value;if(""===prompt.trim()){const errorString=(0,_str.getString)("erroremptyprompt","block_ai_chat");return void await(0,_utils2.showErrorToast)(errorString)}const additionalOptions={};this.reactive.state.config.mode===_constants2.MODES.AGENT&&(additionalOptions.agentoptions={formelements:DomExtractor.extractDomElements(),pageid:document.body.id}),this.reactive.dispatch("submitAiRequest",prompt,additionalOptions)}async _handleLoadingStateUpdated(_ref2){let{element:element}=_ref2;const loadingSpinnerMessage={id:"loadingspinner",sender:"ai",loading:!0,agentMode:!1},temporaryPromptMessage={id:"temporaryprompt",sender:"user",content:this.getElement(this.selectors.INPUT_TEXTAREA).value,agentMode:!1};if(element.loadingState){await this._addMessageToChatArea({element:temporaryPromptMessage}),await this._addMessageToChatArea({element:loadingSpinnerMessage});const inputTextarea=this.getElement(this.selectors.INPUT_TEXTAREA);inputTextarea.value="",inputTextarea.dispatchEvent(new Event("input"))}}_handleKeyDownOnInputTextarea(event){"Enter"!==event.key||event.shiftKey||(event.preventDefault(),this._submitAiRequestListener())}_removeCurrentPersona(){this.reactive.dispatch("selectCurrentPersona",0)}async _renderContent(){const{html:html,js:js}=await _templates.default.renderForPromise("block_ai_chat/chat_content",{conversationContextLimit:this.reactive.state.config.conversationContextLimit});_templates.default.replaceNodeContents(this.getElement(),html,js),await this._setupAfterContentRendering();const availabilityErrorMessage=await this.isAiChatAvailable();if(""!==availabilityErrorMessage){const notice=await(0,_str.getString)("notice","block_ai_chat");await(0,_notification.alert)(notice,availabilityErrorMessage),this.setElementLocked(this.getElement(this.selectors.INPUT_TEXTAREA),!0),this.setElementLocked(this.getElement(this.selectors.SUBMIT_BUTTON),!0),this.getElement(this.selectors.INPUT_TEXTAREA).disabled=!0,this.getElement(this.selectors.SUBMIT_BUTTON).disabled=!0}}async _setupAfterContentRendering(){this.reactive.dispatch("loadCurrentConversationMessages");const inputTextarea=this.getElement(this.selectors.INPUT_TEXTAREA),sendRequestButton=this.getElement(this.selectors.SUBMIT_BUTTON),tinyAiButton=this.getElement(this.selectors.TINY_AI_BUTTON),uniqid=Math.random().toString(16).slice(2);await TinyAiUtils.init(uniqid,this.reactive.state.static.contextid,_constants.constants.modalModes.standalone),this.addEventListener(tinyAiButton,"click",(async()=>{const selectionObject=window.getSelection();if(selectionObject.rangeCount>0){const range=selectionObject.getRangeAt(0),container=document.createElement("div");container.appendChild(range.cloneContents());const images=container.querySelectorAll("img");if(images.length>0&&images[0].src){const image=images[0],fetchResult=await fetch(image.src),data=await fetchResult.blob();TinyAiUtils.getDatamanager(uniqid).setSelectionImg(data)}selectionObject.toString()&&selectionObject.toString().length>0&&TinyAiUtils.getDatamanager(uniqid).setSelection(selectionObject.toString())}const editorUtils=new _editor_utils.default(uniqid,"block_ai_chat",this.reactive.state.static.contextid,this.reactive.state.static.userid,null);TinyAiUtils.setEditorUtils(uniqid,editorUtils),await editorUtils.displayDialogue()})),this.addEventListener(sendRequestButton,"click",this._submitAiRequestListener),this.addEventListener(inputTextarea,"keydown",this._handleKeyDownOnInputTextarea),this._enableTextAreaAutoResize(),this._debouncedScrollToBottom(),this._debouncedFocusInputTextarea()}getViewName(){return"chat"}_scrollToBottom(){const chatOutputWrapper=this.getElement(this.selectors.OUTPUT_WRAPPER);chatOutputWrapper.scrollTop=chatOutputWrapper.scrollHeight}_focusInputTextarea(){const inputTextarea=this.getElement(this.selectors.INPUT_TEXTAREA);requestAnimationFrame((()=>{inputTextarea.focus()}))}_enableTextAreaAutoResize(){const inputTextarea=this.getElement(this.selectors.INPUT_TEXTAREA);this.addEventListener(inputTextarea,"input",(()=>{inputTextarea.style.height="auto";const computedStyles=window.getComputedStyle(inputTextarea),lineHeight=parseFloat(computedStyles.lineHeight),paddingTop=parseFloat(computedStyles.paddingTop),paddingBottom=parseFloat(computedStyles.paddingBottom),borderTop=parseFloat(computedStyles.borderTopWidth),borderBottom=parseFloat(computedStyles.borderBottomWidth),maxHeight=4*lineHeight+paddingTop+paddingBottom+borderTop+borderBottom,newHeight=Math.min(inputTextarea.scrollHeight+borderTop+borderBottom,maxHeight);inputTextarea.style.height=newHeight+"px"}))}async isAiChatAvailable(){const contextid=this.reactive.state.static.contextid,aiConfig=await(0,_config.getAiConfig)(contextid,null,["chat"]);return"disabled"===aiConfig.availability.available?aiConfig.availability.errormessage:"disabled"===aiConfig.purposes[0].available?aiConfig.purposes[0].errormessage:""}_getAgentAnswerTemplateContext(content){const agentAnswer=JSON.parse(content),chatOutputIntroObject=agentAnswer.chatoutput.filter((object=>"intro"===object.type))[0],chatOutputOutroObject=agentAnswer.chatoutput.filter((object=>"outro"===object.type))[0],suggestionContext={intro:chatOutputIntroObject.text,suggestions:[],outro:chatOutputOutroObject.text};return agentAnswer.formelements.forEach((async formElement=>{const htmlElement=document.getElementById(formElement.id);let newValue=formElement.newValue?formElement.newValue.trim():"";0===newValue.length&&(newValue=0),suggestionContext.suggestions.push({fieldname:formElement.label,explanation:formElement.explanation,elementId:formElement.id,suggestionvalue:newValue,suggestiondisplayvalue:newValue,disabledButtons:!htmlElement})})),suggestionContext}}var _default=Chat;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=chat.min.js.map