define("block_ai_chat/components/headeractions",["exports","core/reactive","core/str","core/notification","core_form/modalform","core/modal_cancel","block_ai_chat/constants"],(function(_exports,_reactive,_str,_notification,_modalform,_modal_cancel,_constants){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_modalform=_interopRequireDefault(_modalform),_modal_cancel=_interopRequireDefault(_modal_cancel);class HeaderActions extends _reactive.BaseComponent{static init(target){return new this({element:document.querySelector(target)})}create(){this.name="headeractions",this.selectors={NEW_CONVERSATION_BUTTON:'[data-block_ai_chat-element="newconversationbutton"]',SHOW_HISTORY_BUTTON:'[data-block_ai_chat-element="showhistorybutton"]',PERSONA_LIST_BUTTON:'[data-block_ai_chat-element="personalistbutton"]',OPTIONS_BUTTON:'[data-block_ai_chat-element="optionsbutton"]',DELETE_CONVERSATION_BUTTON:'[data-block_ai_chat-element="deleteconversationbutton"]',VIEWMODE_WINDOW_BUTTON:'[data-block_ai_chat-element="viewmodewindowbutton"]',VIEWMODE_OPENFULL_BUTTON:'[data-block_ai_chat-element="viewmodeopenfullbutton"]',VIEWMODE_DOCKRIGHT_BUTTON:'[data-block_ai_chat-element="viewmodedockrightbutton"]',MODE_SWITCH:"[data-block_ai_chat-element='modeswitch']",PERSONA_BANNER:"[data-block_ai_chat-element='personabanner']",PERSONA_INFO_MODAL_MANAGE_PERSONA_BUTTON:"[data-block_ai_chat-element='personainfomodalpersonalistbutton']",MFORM:"form.mform"}}async stateReady(state){await this._modeUpdated({element:state.config}),this._refreshPersona({element:state.config}),this.addEventListener(this.getElement(this.selectors.NEW_CONVERSATION_BUTTON),"click",this._newConversationListener),this.addEventListener(this.getElement(this.selectors.SHOW_HISTORY_BUTTON),"click",this._showHistoryListener);this.getElement(this.selectors.PERSONA_LIST_BUTTON)&&this.addEventListener(this.getElement(this.selectors.PERSONA_LIST_BUTTON),"click",this._showPersonalistListener),this.addEventListener(this.getElement(this.selectors.PERSONA_BANNER),"click",this._showPersonaInfoModal);this.getElement(this.selectors.MODE_SWITCH)&&this.addEventListener(this.getElement(this.selectors.MODE_SWITCH),"click",this._clickModeSwitchListener);this.getElement(this.selectors.OPTIONS_BUTTON)&&this.addEventListener(this.getElement(this.selectors.OPTIONS_BUTTON),"click",this._renderOptionsForm),this.addEventListener(this.getElement(this.selectors.DELETE_CONVERSATION_BUTTON),"click",this._deleteConversationListener);this.getElement(this.selectors.VIEWMODE_WINDOW_BUTTON)&&this.addEventListener(this.getElement(this.selectors.VIEWMODE_WINDOW_BUTTON),"click",this._setWindowModeListener.bind(this,"window"));this.getElement(this.selectors.VIEWMODE_OPENFULL_BUTTON)&&this.addEventListener(this.getElement(this.selectors.VIEWMODE_OPENFULL_BUTTON),"click",this._setWindowModeListener.bind(this,"openfull"));this.getElement(this.selectors.VIEWMODE_DOCKRIGHT_BUTTON)&&this.addEventListener(this.getElement(this.selectors.VIEWMODE_DOCKRIGHT_BUTTON),"click",this._setWindowModeListener.bind(this,"dockright"))}getWatchers(){return[{watch:"config.mode:updated",handler:this._modeUpdated},{watch:"config.currentPersona:updated",handler:this._refreshPersona},{watch:"personas:updated",handler:this._personaInformationChanged}]}_selectCurrentPersonaListener(event){event.preventDefault(),this.reactive.dispatch("selectCurrentPersona",this.reactive.state.static.contextid,event.target.value)}_newConversationListener(event){event.preventDefault(),this.reactive.dispatch("createAndViewNewConversation")}_showHistoryListener(event){event.preventDefault(),this.reactive.dispatch("setView","history")}_showPersonalistListener(event){event.preventDefault(),this.reactive.dispatch("setView","personalist")}async _renderOptionsForm(){const optionsFormModalTitle=await(0,_str.getString)("preferences","block_ai_chat"),optionsForm=new _modalform.default({formClass:"block_ai_chat\\form\\options_form",moduleName:"core/modal_save_cancel",args:{contextid:this.reactive.state.static.contextid,component:this.reactive.state.static.component},modalConfig:{title:optionsFormModalTitle}});optionsForm.show(),this.addEventListener(optionsForm,optionsForm.events.FORM_SUBMITTED,this._optionsSubmitted)}async _deleteConversationListener(event){event.preventDefault();const deletetext=await(0,_str.getString)("delete","core"),confirmtext=await(0,_str.getString)("deletewarning","block_ai_chat"),canceltext=await(0,_str.getString)("cancel","moodle");(0,_notification.confirm)(deletetext,confirmtext,deletetext,canceltext,(()=>{this.reactive.dispatch("deleteCurrentConversation")}))}_setWindowModeListener(windowMode){this.reactive.dispatch("setWindowMode",windowMode)}_refreshPersona(_ref){let{element:element}=_ref;const newPersonaId=parseInt(element.currentPersona),personaBanner=this.getElement(this.selectors.PERSONA_BANNER),currentMode=this.reactive.state.config.mode;0===newPersonaId||currentMode===_constants.MODES.AGENT?personaBanner.classList.add("d-none"):(personaBanner.classList.remove("d-none"),personaBanner.innerHTML="".concat(this.reactive.state.personas.get(newPersonaId).userinfo))}_personaInformationChanged(_ref2){let{element:element}=_ref2;parseInt(this.reactive.state.config.currentPersona)===element.id&&this._refreshPersona({element:this.reactive.state.config})}_optionsSubmitted(event){this.reactive.dispatch("processDynamicFormUpdates",event.detail)}async _showPersonaInfoModal(){const currentPersonaId=parseInt(this.reactive.state.config.currentPersona),personalink=this.reactive.state.static.personalink,personalinkAvailable=null!==personalink,templateContext={personaSelected:0!==currentPersonaId,personalinkAvailable:personalinkAvailable};if(personalinkAvailable&&(templateContext.personalink=personalink),0!==currentPersonaId){const currentPersona=this.reactive.state.personas.get(currentPersonaId);templateContext.personaName=currentPersona.name,templateContext.personaUserInfo=currentPersona.userinfo,templateContext.personaPrompt=currentPersona.prompt}templateContext.showPersona=this.reactive.state.static.showPersona;const personaInfoModal=await _modal_cancel.default.create({large:!1,template:"block_ai_chat/persona_info_modal",templateContext:templateContext});await personaInfoModal.show();const managePersonasButton=personaInfoModal.getModal()[0].querySelector(this.selectors.PERSONA_INFO_MODAL_MANAGE_PERSONA_BUTTON);managePersonasButton&&managePersonasButton.addEventListener("click",(event=>{event.preventDefault(),this.reactive.dispatch("setView","personalist"),personaInfoModal.hide()}))}async _modeUpdated(_ref3){let{element:element}=_ref3;const modeChatString=await(0,_str.getString)("modechat","block_ai_chat"),modeAgentString=await(0,_str.getString)("modeagent","block_ai_chat"),modeSwitch=this.getElement(this.selectors.MODE_SWITCH);if(!modeSwitch)return;const mformElement=document.querySelector(this.selectors.MFORM);mformElement&&"none"!==window.getComputedStyle(mformElement).display&&"hidden"!==window.getComputedStyle(mformElement).visibility?modeSwitch.classList.remove("d-none"):(modeSwitch.classList.add("d-none"),this.reactive.dispatch("setMode",_constants.MODES.CHAT)),modeSwitch.innerText=element.mode===_constants.MODES.AGENT?modeAgentString:modeChatString,element.mode===_constants.MODES.AGENT?(modeSwitch.classList.remove("bg-dark"),modeSwitch.classList.add("bg-primary")):(modeSwitch.classList.remove("bg-primary"),modeSwitch.classList.add("bg-dark")),this._refreshPersona({element:this.reactive.state.config})}_clickModeSwitchListener(){const newMode=this.reactive.state.config.mode===_constants.MODES.AGENT?_constants.MODES.CHAT:_constants.MODES.AGENT;this.reactive.dispatch("setMode",newMode)}}var _default=HeaderActions;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=headeractions.min.js.map