define("block_ai_chat/components/main",["exports","core/reactive","core/templates","block_ai_chat/utils","core/localstorage","core/modal_events","block_ai_chat/constants"],(function(_exports,_reactive,_templates,_utils,_localstorage,_modal_events,_constants){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_templates=_interopRequireDefault(_templates),_localstorage=_interopRequireDefault(_localstorage),_modal_events=_interopRequireDefault(_modal_events);class Main extends _reactive.BaseComponent{create(descriptor){this.modal=descriptor.modal,this.name="MainComponent",this.classes={WINDOWMODE_WINDOW:"block_ai_chat_chatwindow",WINDOWMODE_OPENFULL:"block_ai_chat_openfull",WINDOWMODE_DOCKRIGHT:"block_ai_chat_dockright"},this.selectors={CONTENTAREA:"[data-block_ai_chat-component='contentarea']",TITLEAREA_PLACEHOLDER:"[data-block_ai_chat-element='titleareaplaceholder']"}}async stateReady(state){if(await this._renderSubComponents(),state.static.renderMode===_constants.RENDER_MODE.MODAL){this.getElement().closest(".modal").classList.add("block_ai_chat_modal");document.getElementById("ai_chat_button").addEventListener("mousedown",(async()=>{this.reactive.dispatch("setModalVisibility")})),this.modal.getRoot().on(_modal_events.default.hidden,(()=>{state.config.modalVisible&&this.reactive.dispatch("setModalVisibility",!1)})),this.modal.getRoot().on(_modal_events.default.outsideClick,(event=>{event.preventDefault()}));let storedWindowMode=await this._getLastWindowModeFromLocalStorage();"window"===storedWindowMode&&window.innerWidth<=576&&(storedWindowMode="openfull"),this.reactive.dispatch("setWindowMode",storedWindowMode),this.bodyObserver=this._setupOverflowWatcher(),this.reactive.dispatch("setModalVisibility",!0)}const{html:html,js:js}=await _templates.default.renderForPromise("block_ai_chat/toast_wrapper",{});_templates.default.prependNodeContents(this.getElement(this.selectors.CONTENTAREA),html,js)}destroy(){this.bodyObserver&&this.bodyObserver.disconnect()}getWatchers(){return[{watch:"config.windowMode:updated",handler:this._handleWindowModeUpdated},{watch:"config.windowMode:updated",handler:this._storeWindowModeToLocalStorage},{watch:"config.modalVisible:updated",handler:this._toggleModalVisibility}]}async _handleWindowModeUpdated(_ref){let{element:element}=_ref;const body=document.querySelector("body");Array.from(Object.values(this.classes)).forEach((classname=>{body.classList.remove(classname)}));let windowModeClass=null;switch(element.windowMode){case"window":windowModeClass=this.classes.WINDOWMODE_WINDOW;break;case"openfull":windowModeClass=this.classes.WINDOWMODE_OPENFULL;break;case"dockright":windowModeClass=this.classes.WINDOWMODE_DOCKRIGHT}body.classList.add(windowModeClass)}async _getLastWindowModeFromLocalStorage(){const key=await(0,_utils.hash)("chatmode"+this.reactive.state.static.userid),currentValue=_localstorage.default.get(key);return currentValue||"window"}async _storeWindowModeToLocalStorage(){const key=await(0,_utils.hash)("chatmode"+this.reactive.state.static.userid);_localstorage.default.set(key,this.reactive.state.config.windowMode)}async _toggleModalVisibility(_ref2){let{element:element}=_ref2;this.reactive.state.static.renderMode!==_constants.RENDER_MODE.EMBEDDED&&(element.modalVisible?(await this.modal.show(),document.body.classList.add("block_ai_chat_open")):(await this.modal.hide(),document.body.classList.remove("block_ai_chat_open")))}_setupOverflowWatcher(){const observer=new MutationObserver((mutations=>{mutations.forEach((mutation=>{if("attributes"===mutation.type&&"style"===mutation.attributeName){const body=document.body;"hidden"===window.getComputedStyle(body).overflow&&this.reactive.state.config.modalVisible&&(document.body.style.removeProperty("overflow"),document.body.style.removeProperty("padding-right"))}}))}));return observer.observe(document.body,{attributes:!0,attributeFilter:["style"]}),observer}async _renderSubComponents(){const titleAreaPlaceholder=document.createElement("div");this.getElement(this.selectors.TITLEAREA_PLACEHOLDER).appendChild(titleAreaPlaceholder);const titleAreaComponent=await this.renderComponent(titleAreaPlaceholder,"block_ai_chat/components/titlearea",{showPersona:this.reactive.state.static.showPersona,showOptions:this.reactive.state.static.showOptions,showAgentMode:this.reactive.state.static.renderMode===_constants.RENDER_MODE.MODAL&&this.reactive.state.static.showAgentMode,showViews:this.reactive.state.static.renderMode===_constants.RENDER_MODE.MODAL});this.getElement(this.selectors.TITLEAREA_PLACEHOLDER).replaceWith(titleAreaComponent.getElement()),titleAreaPlaceholder.remove();const placeholderChatarea=document.createElement("div");this.getElement(this.selectors.CONTENTAREA).appendChild(placeholderChatarea);const chatComponent=await this.renderComponent(placeholderChatarea,"block_ai_chat/components/chat",{});this.getElement(this.selectors.CONTENTAREA).appendChild(chatComponent.getElement()),placeholderChatarea.remove();const placeholderHistory=document.createElement("div");this.getElement(this.selectors.CONTENTAREA).appendChild(placeholderHistory);const historyComponent=await this.renderComponent(placeholderHistory,"block_ai_chat/components/history",{});this.getElement(this.selectors.CONTENTAREA).appendChild(historyComponent.getElement()),placeholderHistory.remove();const placeholderPersonalist=document.createElement("div");this.getElement(this.selectors.CONTENTAREA).appendChild(placeholderPersonalist);const personaListComponent=await this.renderComponent(placeholderPersonalist,"block_ai_chat/components/personalist",{});this.getElement(this.selectors.CONTENTAREA).appendChild(personaListComponent.getElement()),placeholderPersonalist.remove()}}var _default=Main;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=main.min.js.map