define("block_ai_chat/components/personalistitem",["exports","core/reactive","core_form/modalform","core/notification","core/str","block_ai_chat/constants","core/templates"],(function(_exports,_reactive,_modalform,_notification,_str,_constants,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_modalform=_interopRequireDefault(_modalform),_templates=_interopRequireDefault(_templates);class PersonaListItem extends _reactive.BaseComponent{static init(target){return new this({element:document.querySelector(target)})}create(){if(this.id=parseInt(this.getElement().dataset.block_ai_chatPersonaId),this.selectors={PERSONA_NAME_ELEMENT:"[data-block_ai_chat-element='personaname']",PERSONA_LIST_ITEM:'[data-block_ai_chat-component="personalistitem"]',EDIT_PERSONA_LINK:"[data-block_ai_chat-element='editpersonalink']",DUPLICATE_PERSONA_LINK:"[data-block_ai_chat-element='duplicatepersonalink']",DELETE_PERSONA_LINK:"[data-block_ai_chat-element='deletepersonalink']"},this.addEventListener(this.getElement(this.selectors.PERSONA_NAME_ELEMENT),"click",this._handleMarkPersona),0===this.id)return;this.getElement().classList.add("ml-2");const editPersonaLink=this.getElement(this.selectors.EDIT_PERSONA_LINK);editPersonaLink&&this.addEventListener(editPersonaLink,"click",(async e=>{e.preventDefault(),await this._renderPersonaEditForm()})),this.addEventListener(this.getElement(this.selectors.DUPLICATE_PERSONA_LINK),"click",(e=>{e.preventDefault(),this._handleDuplicatePersona()}));const deletePersonaLink=this.getElement(this.selectors.DELETE_PERSONA_LINK);deletePersonaLink&&this.addEventListener(deletePersonaLink,"click",(async e=>{e.preventDefault();const deletetext=await(0,_str.getString)("delete","core"),confirmtext=await this.getDeleteWarningText(),canceltext=await(0,_str.getString)("cancel","moodle");(0,_notification.confirm)(deletetext,confirmtext,deletetext,canceltext,(()=>{this.reactive.dispatch("deletePersona",this.id)}))}))}stateReady(state){this._applyFormatting({element:state.config})}getWatchers(){return[{watch:"config.currentlyMarkedPersona:updated",handler:this._applyFormatting},{watch:"personas[".concat(this.id,"]:deleted"),handler:this.remove}]}_handleMarkPersona(){this.reactive.dispatch("markPersona",this.id)}_applyFormatting(_ref){let{element:element}=_ref;parseInt(element.currentlyMarkedPersona)===this.id?this.getElement().classList.add("block_ai_chat-selected-personaitem"):this.getElement().classList.remove("block_ai_chat-selected-personaitem"),this.id===this.reactive.state.config.currentPersona?this.getElement().classList.add("block_ai_chat-current-personaitem"):this.getElement().classList.remove("block_ai_chat-current-personaitem")}_removePersonaItem(){this.remove()}async _renderPersonaEditForm(){const selectedPersona=this.reactive.state.personas.get(this.id),title=await(0,_str.getString)("editpersonatitle","block_ai_chat"),personaForm=new _modalform.default({formClass:"block_ai_chat\\form\\persona_form",moduleName:"core/modal_save_cancel",args:{contextid:this.reactive.state.static.contextid,component:this.reactive.state.static.component,personaid:this.id,name:selectedPersona.name,prompt:selectedPersona.prompt,userinfo:selectedPersona.userinfo,userid:selectedPersona.userid,type:selectedPersona.type},modalConfig:{title:title},returnFocus:this.getElement()});this.addEventListener(personaForm,personaForm.events.FORM_SUBMITTED,this._personaFormSubmitted),personaForm.show()}_personaFormSubmitted(event){this.reactive.dispatch("processDynamicFormUpdates",event.detail.content)}_handleDuplicatePersona(){this.reactive.dispatch("duplicatePersona",this.id)}async getDeleteWarningText(){const isTemplate=this.reactive.state.personas.get(this.id).type===_constants.PERSONA_TYPES.TYPE_TEMPLATE,{html:html,js:js}=await _templates.default.renderForPromise("block_ai_chat/templatedelete_warning",{isTemplate:isTemplate});return _templates.default.runTemplateJS(js),html}}var _default=PersonaListItem;return _exports.default=_default,_exports.default}));

//# sourceMappingURL=personalistitem.min.js.map