define("block_ai_chat/dom_extractor",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.extractDomElements=void 0;_exports.extractDomElements=()=>{const elements=[],contentDiv=document.getElementById("page-content");if(!contentDiv)return[];contentDiv.querySelectorAll('input[type="text"], input[type="password"], input[type="email"], input[type="number"], input[type="search"], input[type="tel"], input[type="url"], input[type="date"], input[type="datetime-local"], input[type="checkbox"], input[type="radio"], input[type="file"], input[type="hidden"], input[type="submit"], input[type="button"], textarea, select').forEach((node=>{var _node$getAttributeNod;let type=node.tagName.toLowerCase(),currentValue="";const options=[];if("input"===type)type=node.type,currentValue="checkbox"===type||"radio"===type?node.checked?node.value||"on":"":node.value||"";else if("textarea"===type)if(type="textarea","none"===node.style.display&&node.id){const tinyFrame=document.querySelector("#".concat(node.id,"_ifr"));if(null!=tinyFrame&&tinyFrame.contentDocument)try{const tinyBody=tinyFrame.contentDocument.body;currentValue=tinyBody?tinyBody.textContent||tinyBody.innerText||"":node.value||""}catch(e){currentValue=node.value||""}else currentValue=node.value||""}else currentValue=node.value||"";else if("select"===type){var _node$selectedOptions;if(type="select",currentValue=(null===(_node$selectedOptions=node.selectedOptions)||void 0===_node$selectedOptions?void 0:_node$selectedOptions.length)>0?node.selectedOptions[0].value:node.value||"",!isWithinDateTimeContainer(node)){node.querySelectorAll("option").forEach((option=>{options.push({value:option.value,text:option.textContent||option.innerText||"",selected:option.selected})}))}}const label=findLabelForElement(node),helptext=findHelptextForElement(node),errorText=findErrorForElement(node);let active=1,isDisabled=!1,dependsOnEnabled=null;!0===node.disabled&&(isDisabled=!0);const attrNode=null===(_node$getAttributeNod=node.getAttributeNode)||void 0===_node$getAttributeNod?void 0:_node$getAttributeNod.call(node,"disabled");null!=attrNode&&attrNode.specified&&(isDisabled=!0);const computedStyle=window.getComputedStyle(node);active="none"===computedStyle.display&&"hidden"!==type||isDisabled?0:1;const isVisuallyVisible=getElementVisualVisibility(node,computedStyle),enabledDependency=checkEnabledDependency(node);enabledDependency&&(dependsOnEnabled=enabledDependency.checkboxName,enabledDependency.isEnabled||(active=0));const allDependencies=checkElementDependencies(node),jsDependencies=analyzeJavaScriptDependencies(node),siblingDependencies=analyzeSiblingDependencies(node),elementData={id:node.id||"",name:node.name||"",type:type,currentValue:currentValue,label:label,helptext:helptext,active:active,visible:isVisuallyVisible};errorText&&(elementData.errorMessage=errorText),"checkbox"!==type&&"radio"!==type||(elementData.checked=node.checked||!1),dependsOnEnabled&&(elementData.dependsOnEnabled=dependsOnEnabled),allDependencies&&(elementData.dependencies=allDependencies),jsDependencies&&(elementData.jsDependencies=jsDependencies),siblingDependencies&&(elementData.siblingDependencies=siblingDependencies),"select"===type&&options.length>0&&(elementData.options=options),elements.push(elementData)}));const pageContextElements=extractPageContext(contentDiv);return elements.push(...pageContextElements),elements};const extractPageContext=contentDiv=>{const contextElements=[];return contentDiv.querySelectorAll("h2").forEach((heading=>{const helpButton=heading.querySelector("a[data-bs-content]");if(helpButton&&helpButton.getAttribute("data-bs-content")){const headingText=(heading=>{const headingClone=heading.cloneNode(!0),helpButtonClone=headingClone.querySelector("a[data-bs-content]");return helpButtonClone&&helpButtonClone.remove(),(headingClone.textContent||headingClone.innerText||"").trim()})(heading),rawHelp=helpButton.getAttribute("data-bs-content");let helpText="";if(rawHelp){const tmpDiv=document.createElement("div");tmpDiv.innerHTML=rawHelp,helpText=(tmpDiv.textContent||tmpDiv.innerText||"").trim()}if(headingText&&helpText){const contextElement={id:heading.id||"",name:"page_context_"+(heading.id||"heading_"+contextElements.length),type:"page_context",currentValue:"",label:headingText,helptext:helpText,active:1,visible:1};contextElements.push(contextElement)}}})),contextElements},findLabelForElement=element=>{let label="";if(element.id){const labelElement=document.querySelector('label[for="'.concat(element.id,'"]'));labelElement&&(label=labelElement.textContent||labelElement.innerText||"",label=label.trim())}if(!label){const parentLabel=element.closest("label");parentLabel&&(label=parentLabel.textContent||parentLabel.innerText||"",label=label.trim())}if(!label){const fitemDiv=element.closest(".fitem");if(fitemDiv){const labelDiv=fitemDiv.querySelector(".col-form-label label, .col-form-label p");labelDiv&&(label=labelDiv.textContent||labelDiv.innerText||"",label=label.trim())}}return label||(label=element.getAttribute("aria-label")||element.getAttribute("title")||""),label},findHelptextForElement=element=>{let helptext="";const searchContainers=[element.parentElement,element.closest(".fitem"),element.closest(".felement"),element.closest(".col-md-9")];for(const container of searchContainers)if(container){const helpAnchor=container.querySelector("a[data-bs-content]");if(null!=helpAnchor&&helpAnchor.getAttribute("data-bs-content")){const rawHelp=helpAnchor.getAttribute("data-bs-content"),tmpDiv=document.createElement("div");tmpDiv.innerHTML=rawHelp,helptext=tmpDiv.textContent||tmpDiv.innerText||"",helptext=helptext.trim();break}}return helptext},findErrorForElement=element=>{let errorText="";const searchContainers=[element.parentElement,element.closest(".fitem"),element.closest(".felement"),element.closest(".col-md-9")];for(const container of searchContainers)if(container){const errorDiv=container.querySelector(".invalid-feedback, .form-control-feedback.invalid-feedback");if(errorDiv&&"none"!==errorDiv.style.display&&(errorText=(errorDiv.textContent||errorDiv.innerText||"").trim(),errorText))break;if(!errorText){const errorSpan=container.querySelector(".error");if(errorSpan&&(errorText=(errorSpan.textContent||errorSpan.innerText||"").trim(),errorText))break}if(!errorText){const ariaErrorId=element.getAttribute("aria-describedby");if(ariaErrorId){const ariaErrorElement=document.getElementById(ariaErrorId);if(ariaErrorElement&&(errorText=(ariaErrorElement.textContent||ariaErrorElement.innerText||"").trim(),errorText))break}}}return errorText},checkEnabledDependency=element=>{const elementName=element.name||element.id||"",patterns=["".concat(elementName,"_enabled"),elementName.replace(/_[^_]+$/,"_enabled"),elementName.replace(/\[[^\]]+\]$/,"[enabled]")],nameParts=elementName.split("_");if(nameParts.length>1)for(let i=nameParts.length-1;i>=2;i--){const baseName=nameParts.slice(0,i).join("_");patterns.push("".concat(baseName,"_enabled"))}const searchContainers=[element.closest(".fitem"),element.closest("fieldset"),element.closest(".fcontainer"),document.getElementById("page-content")];for(const enabledName of patterns)for(const container of searchContainers){if(!container)continue;let enabledCheckbox=container.querySelector('input[type="checkbox"][name="'+enabledName+'"], input[type="checkbox"][id*="'+enabledName.replace(/[[\]]/g,"_")+'"]');if(enabledCheckbox)return{checkboxName:enabledName,checkboxId:enabledCheckbox.id,isEnabled:enabledCheckbox.checked}}let fitemContainer=element.closest(".fitem");if(fitemContainer){if(fitemContainer.id&&fitemContainer.id.match(/^fgroup_id_(.+)$/)){let groupCheckboxes=fitemContainer.querySelectorAll('input[type="checkbox"][name*="_enabled"]');for(let gc=0;gc<groupCheckboxes.length;gc++){let groupCheckbox=groupCheckboxes[gc],checkboxName=groupCheckbox.name;if(0===elementName.indexOf(checkboxName.replace("_enabled","")))return{checkboxName:checkboxName,checkboxId:groupCheckbox.id,isEnabled:groupCheckbox.checked}}}}return null},isWithinDateTimeContainer=element=>{if(element.closest('[data-fieldtype="date_time"]'))return!0;if(element.closest('fieldset[data-fieldtype="date_time"]'))return!0;return!!element.closest('div[data-fieldtype="date_time"]')},checkElementDependencies=element=>{const form=element.closest("form");if(!form)return null;const elementContainer=element.closest(".fitem"),dependencies=[],visibility=getElementVisibility(element,elementContainer);return form.querySelectorAll('select, input[type="checkbox"], input[type="radio"]').forEach((controlElement=>{if(controlElement===element||controlElement.closest('[style*="display: none"]')||controlElement.hasAttribute("disabled")||controlElement.disabled)return;const dependency=analyzeElementDependency(element,controlElement,visibility);dependency&&dependencies.push(dependency)})),dependencies.length>0?dependencies:null},getElementVisibility=(element,container)=>{let isHidden=!1,hideMethod="none";if(container){const style=container.style,hiddenAttr=container.hasAttribute("hidden"),computedStyle=window.getComputedStyle(container);style&&"none"===style.display?(isHidden=!0,hideMethod="style_display"):hiddenAttr?(isHidden=!0,hideMethod="hidden_attribute"):"none"===computedStyle.display?(isHidden=!0,hideMethod="computed_style"):"hidden"===computedStyle.visibility&&(isHidden=!0,hideMethod="visibility_hidden")}return{isHidden:isHidden,hideMethod:hideMethod,isDisabled:element.disabled||element.hasAttribute("disabled")}},analyzeElementDependency=(dependentElement,controlElement,visibility)=>{const controlName=controlElement.name||"",controlType=controlElement.type||controlElement.tagName.toLowerCase(),controlValue=getControlElementValue(controlElement),dependentName=dependentElement.name||"",dependentId=dependentElement.id||"",numericDependency=checkNumericSuffixDependency(dependentName,dependentId,controlName,controlValue);if(numericDependency)return createDependencyObject(controlElement,controlValue,numericDependency.requiredValue,visibility);const semanticDependency=checkSemanticDependency(dependentName,dependentId,controlName,controlValue);if(semanticDependency)return createDependencyObject(controlElement,controlValue,semanticDependency.requiredValue,visibility);const containerDependency=checkContainerDependency(dependentElement,controlElement,controlValue);if(containerDependency)return createDependencyObject(controlElement,controlValue,containerDependency.requiredValue,visibility);const enableDependency=checkEnableDependency(dependentName,dependentId,controlName,controlValue,controlType);return enableDependency?createDependencyObject(controlElement,controlValue,enableDependency.requiredValue,visibility):null},checkNumericSuffixDependency=(dependentName,dependentId,controlName,controlValue)=>{const dependentMatch=dependentName.match(/^(.+?)(\d+)$/)||dependentId.match(/^id_(.+?)(\d+)$/);if(!dependentMatch)return null;const baseName=dependentMatch[1],number=dependentMatch[2],controlBaseName=controlName.replace(/^(id_)?/,"").replace(/_$/,""),commonPatterns=[{control:"preset",dependents:["primer","instructions","example","template","config"]},{control:"mode",dependents:["option","setting","param","field"]},{control:"type",dependents:["config","option","param","setting"]},{control:"category",dependents:["subcategory","item","field"]},{control:"level",dependents:["detail","item","option"]}];for(let i=0;i<commonPatterns.length;i++){const pattern=commonPatterns[i];if(controlBaseName===pattern.control&&-1!==pattern.dependents.indexOf(baseName)&&number===controlValue)return{requiredValue:controlValue}}return null},checkSemanticDependency=(dependentName,dependentId,controlName,controlValue)=>{const semanticMappings={mode:{1:["topic","subject","theme"],2:["content","story","text","material"],3:["activities","courseactivities","course_content","modules"]},type:{manual:["manual_config","manual_settings"],auto:["auto_config","auto_settings"],custom:["custom_config","custom_settings"]},format:{html:["html_editor","wysiwyg"],plain:["plain_text","textarea"],markdown:["markdown_editor"]}},controlBaseName=controlName.replace(/^(id_)?/,""),dependentBaseName=dependentName.replace(/^(id_)?/,"");if(semanticMappings[controlBaseName]){const valueMapping=semanticMappings[controlBaseName][controlValue];if(valueMapping&&-1!==valueMapping.indexOf(dependentBaseName))return{requiredValue:controlValue}}return null},checkContainerDependency=(dependentElement,controlElement,controlValue)=>{const container=dependentElement.closest(".fitem");if(!container)return null;const dependsOn=container.getAttribute("data-depends-on");if(dependsOn===controlElement.name||dependsOn===controlElement.id){return{requiredValue:container.getAttribute("data-show-when")||controlValue}}const conditional=container.getAttribute("data-conditional");if(conditional)try{const conditionObj=JSON.parse(conditional);if(conditionObj.element===controlElement.name&&conditionObj.value===controlValue)return{requiredValue:controlValue}}catch(e){}return null},checkEnableDependency=(dependentName,dependentId,controlName,controlValue,controlType)=>{if("checkbox"!==controlType)return null;return-1!==[dependentName+"_enabled",dependentName+"_enable","enable_"+dependentName,dependentName.replace(/^id_/,"")+"_enabled"].indexOf(controlName)?{requiredValue:"1"}:null},getControlElementValue=element=>{const type=element.type||element.tagName.toLowerCase();return"checkbox"===type||"radio"===type?element.checked?"1":"0":element.value||""},createDependencyObject=(controlElement,controlValue,requiredValue,visibility)=>({controllingElement:controlElement.name||"",controllingElementId:controlElement.id||"",controllingType:controlElement.type||controlElement.tagName.toLowerCase(),controllingValue:controlValue,requiredValue:requiredValue,isCurrentlyVisible:!visibility.isHidden&&controlValue===requiredValue,hideMethod:visibility.hideMethod}),analyzeJavaScriptDependencies=element=>{const container=element.closest(".fitem");if(!container)return null;const dependencies=[];container.className.split(" ").forEach((cls=>{if(cls.startsWith("depends-on-")){const dependencyName=cls.replace("depends-on-","");dependencies.push({type:"css_class",pattern:cls,dependsOn:dependencyName})}else if(cls.match(/^show-when-\w+-\w+$/)){const parts=cls.replace("show-when-","").split("-");parts.length>=2&&dependencies.push({type:"css_class",pattern:cls,dependsOn:parts[0],requiredValue:parts.slice(1).join("-")})}}));if(element.closest("form")){document.querySelectorAll("script").forEach((script=>{const content=script.textContent||script.innerText;if(content&&content.includes(element.name||element.id)){[/addEventListener\(['"]change['"],\s*function/g,/\.on\(['"]change['"],\s*function/g,/onchange\s*=\s*['"]?[^'"]+/g].forEach((pattern=>{content.match(pattern)&&dependencies.push({type:"javascript_event",pattern:"change_listener",element:element.name||element.id})}))}}))}return dependencies.length>0?dependencies:null},analyzeSiblingDependencies=element=>{const container=element.closest(".fitem");if(!container)return null;const dependencies=[],elementName=element.name||"",siblingContainers=[],parent=container.parentNode;if(parent){parent.querySelectorAll(".fitem").forEach((fitem=>{fitem!==container&&siblingContainers.push(fitem)}))}return siblingContainers.forEach((siblingContainer=>{siblingContainer.querySelectorAll("input, select, textarea").forEach((siblingElement=>{const siblingName=siblingElement.name||"",similarity=analyzeSimilarity(elementName,siblingName);if(similarity.score>.7&&similarity.type){const siblingVisibility=getElementVisibility(siblingElement,siblingContainer);dependencies.push({type:"sibling_dependency",siblingElement:siblingName,siblingId:siblingElement.id||"",similarity:similarity,siblingVisible:!siblingVisibility.isHidden})}}))})),dependencies.length>0?dependencies:null},analyzeSimilarity=(name1,name2)=>{if(!name1||!name2)return{score:0,type:null};const cleanName1=name1.replace(/^(id_)?/,""),cleanName2=name2.replace(/^(id_)?/,""),numPattern1=cleanName1.match(/^(.+?)(\d+)$/),numPattern2=cleanName2.match(/^(.+?)(\d+)$/);if(numPattern1&&numPattern2&&numPattern1[1]===numPattern2[1])return{score:.9,type:"numeric_series",basePattern:numPattern1[1],numbers:[numPattern1[2],numPattern2[2]]};let commonPrefixLength=0;for(let i=0;i<Math.min(cleanName1.length,cleanName2.length)&&cleanName1[i]===cleanName2[i];i++)commonPrefixLength++;if(commonPrefixLength>=3){return{score:commonPrefixLength/Math.max(cleanName1.length,cleanName2.length),type:"similar_prefix",commonPrefix:cleanName1.substring(0,commonPrefixLength)}}return{score:0,type:null}},getElementVisualVisibility=(element,computedStyle)=>!!isElementDirectlyVisible(element,computedStyle)&&!hasHiddenParent(element),isElementDirectlyVisible=(element,computedStyle)=>{if(element.hasAttribute("hidden"))return!1;const styles=computedStyle||window.getComputedStyle(element);if("none"===styles.display)return!1;if("hidden"===styles.visibility)return!1;const width=parseFloat(styles.width),height=parseFloat(styles.height);return 0!==width||0!==height},hasHiddenParent=element=>{let parent=element.parentElement;for(;parent&&parent!==document.body&&parent!==document.documentElement;){if(parent.hasAttribute("hidden")||!0===parent.hidden)return!0;const parentStyles=window.getComputedStyle(parent);if("none"===parentStyles.display||"hidden"===parentStyles.visibility)return!0;parent=parent.parentElement}return!1}}));

//# sourceMappingURL=dom_extractor.min.js.map