define("block_ai_chat/mutations",["exports","block_ai_chat/utils"],(function(_exports,_utils){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;return _exports.default=
/**
   * Mutations for the AI Chat block.
   *
   * @module     block_ai_chat/mutations
   * @copyright  2025 ISB Bayern
   * @author     Philipp Memmel
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class{async selectCurrentPersona(stateManager,personaid){let ajaxresult=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_select_persona",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,personaid:personaid});null!==ajaxresult&&stateManager.processUpdates(ajaxresult)}async selectCurrentPersonaAndLoadChat(stateManager,personaid){await this.selectCurrentPersona(stateManager,personaid),await this.setView(stateManager,"chat")}async submitAiRequest(stateManager,prompt,additionalOptions){this.setLoadingState(stateManager,!0);const options={conversationid:stateManager.state.config.currentConversationId,...additionalOptions},requestOptions=JSON.stringify(options),result=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_request_ai",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,mode:stateManager.state.config.mode,prompt:prompt,options:requestOptions});null!==result?(this.setLoadingState(stateManager,!1),stateManager.processUpdates(result),0===stateManager.state.config.currentConversationId&&(stateManager.setReadOnly(!1),stateManager.state.config.currentConversationId=stateManager.state.messages.values().next().value.conversationid,stateManager.setReadOnly(!0))):this.setLoadingState(stateManager,!1)}setLoadingState(stateManager,isLoading){stateManager.setReadOnly(!1),stateManager.state.config.loadingState=isLoading,stateManager.setReadOnly(!0)}async setCurrentConversation(stateManager,conversationid){stateManager.setReadOnly(!1),stateManager.state.config.currentConversationId=conversationid,stateManager.setReadOnly(!0)}setView(stateManager,view){stateManager.state.config.view!==view&&(stateManager.setReadOnly(!1),stateManager.state.config.view=view,stateManager.setReadOnly(!0))}async createAndViewNewConversation(stateManager){await this.setConversationAndLoadChat(stateManager,0)}async setConversationAndLoadChat(stateManager,conversationid){await this.setCurrentConversation(stateManager,conversationid),stateManager.setReadOnly(!1),stateManager.state.config.view="dummy",stateManager.setReadOnly(!0),stateManager.setReadOnly(!1),stateManager.state.config.view="chat",stateManager.setReadOnly(!0)}async loadCurrentConversationMessages(stateManager){let deleteActions=[];if(stateManager.state.messages.forEach((message=>{deleteActions.push({name:"messages",action:"remove",fields:{id:message.id}})})),stateManager.processUpdates(deleteActions),0===stateManager.state.config.currentConversationId)return;const messages=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_get_messages",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,conversationid:stateManager.state.config.currentConversationId});null!==messages&&stateManager.processUpdates(messages)}markPersona(stateManager,personaId){stateManager.setReadOnly(!1),stateManager.state.config.currentlyMarkedPersona=personaId,stateManager.setReadOnly(!0)}async createNewDummyPersona(stateManager){let ajaxresult=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_create_dummy_persona",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component});null!==ajaxresult&&stateManager.processUpdates(ajaxresult)}async duplicatePersona(stateManager,personaid){let ajaxresult=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_duplicate_persona",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,personaid:personaid});null!==ajaxresult&&stateManager.processUpdates(ajaxresult)}async deletePersona(stateManager,personaid){let ajaxresult=await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_delete_persona",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,personaid:personaid});null!==ajaxresult&&stateManager.processUpdates(ajaxresult)}processDynamicFormUpdates(stateManager,stateUpdates){stateUpdates.map((update=>("object"!=typeof update.fields&&(update.fields=JSON.parse(update.fields)),update))),stateManager.processUpdates(stateUpdates)}async deleteCurrentConversation(stateManager){null!==await(0,_utils.callExternalFunctionReactiveUpdate)("block_ai_chat_delete_conversation",{contextid:stateManager.state.static.contextid,component:stateManager.state.static.component,conversationid:stateManager.state.config.currentConversationId})&&await this.createAndViewNewConversation(stateManager)}setWindowMode(stateManager,windowmode){stateManager.setReadOnly(!1),stateManager.state.config.windowMode=windowmode,stateManager.setReadOnly(!0)}setModalVisibility(stateManager){let visible=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;stateManager.setReadOnly(!1),stateManager.state.config.modalVisible=null===visible?!stateManager.state.config.modalVisible:visible,stateManager.setReadOnly(!0)}setMode(stateManager,mode){stateManager.setReadOnly(!1),stateManager.state.config.mode=mode,stateManager.setReadOnly(!0)}setMessageRendered(stateManager,messageid){stateManager.setReadOnly(!1);const message=stateManager.state.messages.get(messageid);message&&(message.rendered=!0,stateManager.state.messages.set(messageid,message)),stateManager.setReadOnly(!0)}},_exports.default}));

//# sourceMappingURL=mutations.min.js.map