define("block_ai_chat/reactive_init",["exports","core/reactive","block_ai_chat/events","block_ai_chat/components/main","block_ai_chat/mutations","core/ajax","core/notification","core/log","block_ai_chat/constants"],(function(_exports,_reactive,_events,_main,_mutations,Ajax,_notification,_log,_constants){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Main module for the reactive frontend of the block_ai_chat.
   *
   * @module     block_ai_chat/reactive_init
   * @copyright  2025 ISB Bayern
   * @author     Philipp Memmel
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_main=_interopRequireDefault(_main),_mutations=_interopRequireDefault(_mutations),Ajax=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Ajax),_log=_interopRequireDefault(_log);_exports.init=async function(contextid,mainElementSelector){let modal=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,component=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"block_ai_chat";const mainElement=document.querySelector(mainElementSelector);if(!mainElement){const errormessage="No main element found for selector "+mainElementSelector;return void await(0,_notification.alert)(errormessage)}if(null===modal&&(!mainElement.dataset.hasOwnProperty("id")||0===mainElement.dataset.id.length)){const errormessage="No data id attribute found on main element for selector "+mainElementSelector;return void await(0,_notification.alert)(errormessage)}let reactiveChatName,state=null;try{state=await Ajax.call([{methodname:"block_ai_chat_get_initial_state",args:{contextid:contextid,component:component}}])[0]}catch(error){return _log.default.error("Error while retrieving initial state",error),void await(0,_notification.exception)(error)}state.static.renderMode=null===modal?_constants.RENDER_MODE.EMBEDDED:_constants.RENDER_MODE.MODAL,reactiveChatName=state.static.renderMode===_constants.RENDER_MODE.MODAL?"block_ai_chat_reactive_chat_modal":"block_ai_chat_reactive_chat_embedded_"+mainElement.dataset.id;const reactiveChat=new _reactive.Reactive({name:reactiveChatName,eventName:_events.eventTypes.blockAiChatStateUpdated,eventDispatch:_events.notifyBlockAiChatStateUpdated,mutations:new _mutations.default,state:state});new _main.default({element:mainElement,reactive:reactiveChat,modal:modal})}}));

//# sourceMappingURL=reactive_init.min.js.map