define("block_ai_control/ai_control_info",["exports","block_ai_control/repository","core/templates","./ai_control"],(function(_exports,_repository,_templates,_ai_control){var obj;
/**
   * Renders the info part of the block_ai_control.
   *
   * @module     block_ai_control/ai_control_info
   * @copyright  2024 ISB Bayern
   * @author     Philipp Memmel
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_templates=(obj=_templates)&&obj.__esModule?obj:{default:obj};let baseElement=null,contextId=null,countdownTimer=null;const init=async(element,aiconfig)=>{baseElement=element,contextId=aiconfig.id,await renderWidget(aiconfig);const controlArea=baseElement.parentElement.querySelector('[data-aicontrol="config"]');controlArea&&controlArea.addEventListener("aiconfigUpdated",(async event=>{const aiconfig=event.detail.aiconfig,templateContext={enabled:aiconfig.enabled,expiresat:aiconfig.expiresat,expiresatFormatted:aiconfig.expiresatFormatted};await renderWidget(templateContext)}))};_exports.init=init;const renderWidget=async templateContext=>{const targetTime=templateContext.expiresat,distance=1e3*targetTime-Date.now();templateContext.warning=distance<3e5;const{html:html,js:js}=await _templates.default.renderForPromise("block_ai_control/ai_control_info",{...templateContext});_templates.default.replaceNodeContents(baseElement,html,js);const countdownElement=baseElement.querySelector('[data-aicontrol="countdown"]');clearInterval(countdownTimer),countdownTimer=setInterval((async()=>{const{days:days,hours:hours,minutes:minutes,seconds:seconds}=(0,_ai_control.convertTargetUnixTimeToCountdown)(targetTime),countdownContext={days:days,hours:hours,minutes:minutes,seconds:seconds};countdownContext.showDays=countdownContext.days>0,countdownContext.showHours=!!countdownContext.showDays||countdownContext.hours>0,countdownContext.showMinutes=!!countdownContext.showHours||countdownContext.minutes>0,countdownContext.showSeconds=!!countdownContext.showMinutes||countdownContext.seconds>0;const{html:html,js:js}=await _templates.default.renderForPromise("block_ai_control/ai_control_countdown",countdownContext);_templates.default.replaceNodeContents(countdownElement,html,js);const distance=1e3*targetTime-Date.now();if(templateContext.enabled&&distance<=0){clearInterval(countdownTimer);const aiconfig=await(0,_repository.getAiconfig)(contextId);await init(baseElement,{...aiconfig})}}),1e3)}}));

//# sourceMappingURL=ai_control_info.min.js.map