define("block_ai_control/ai_control_config",["exports","block_ai_control/repository","block_ai_control/ai_control","core/templates","core/str","core/notification","core/modal_save_cancel","core/modal_events"],(function(_exports,_repository,_ai_control,_templates,_str,_notification,_modal_save_cancel,_modal_events){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Handler for the config area of block_ai_control.
   *
   * @module     block_ai_control/ai_control_config
   * @copyright  2024 ISB Bayern
   * @author     Philipp Memmel
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_templates=_interopRequireDefault(_templates),_modal_save_cancel=_interopRequireDefault(_modal_save_cancel),_modal_events=_interopRequireDefault(_modal_events);let baseElement=null,aiconfig=null,currentTargetTime=0;_exports.init=async(element,aiconfigObject)=>{aiconfig=aiconfigObject,baseElement=element;const contextid=baseElement.parentElement.dataset.contextid,templateContext={identifier:"aiconfig_enabled"};templateContext.text=await(0,_str.getString)("toggleai","block_ai_control"),templateContext.checked=aiconfig.enabled,templateContext.coursecontextid=contextid,templateContext.showviewprompts=aiconfig.showviewprompts,currentTargetTime=aiconfig.expiresat,templateContext.expiresat=convertUnixtimeToDateElementFormat(currentTargetTime),templateContext.purposes=[],aiconfig.purposes.forEach((purpose=>{const purposeConfig={checked:purpose.allowed,identifier:"purpose_"+purpose.name,text:purpose.displayname};templateContext.purposes.push(purposeConfig)}));const{html:html,js:js}=await _templates.default.renderForPromise("block_ai_control/ai_control_config",{...templateContext});_templates.default.replaceNodeContents(baseElement,html,js),baseElement.querySelectorAll('[data-aicontrol-item^="switchexpiryview"]').forEach((button=>{button.addEventListener("click",(()=>{updateTargetTime();baseElement.querySelectorAll("[data-aicontrol-show]").forEach((element=>{element.dataset.aiconfigShow="1"===element.dataset.aiconfigShow?"0":"1",element.classList.toggle("d-none")}))}))})),baseElement.querySelector('[data-aicontrol="submitbutton"]').addEventListener("click",(async()=>{await handleSubmitButtonClick()})),baseElement.querySelector('[data-toggle-identifier="aiconfig_enabled"] input').addEventListener("change",(()=>{baseElement.querySelector('[data-aicontrol="purposeslist"]').classList.toggle("d-none"),baseElement.querySelector('[data-aicontrol="expirydate"]').classList.toggle("d-none")}))};const handleSubmitButtonClick=async()=>{updateTargetTime();const currentTime=new Date;if(Math.floor(currentTime.getTime()/1e3)>currentTargetTime)return void await(0,_notification.alert)((0,_str.getString)("error","core"),(0,_str.getString)("error_targettimeinpast","block_ai_control"));const isCurrentlyDisabled=!1===aiconfig.enabled&&"1"===baseElement.parentElement.querySelector('[data-toggle-identifier="aiconfig_enabled"]').dataset.checked;if(aiconfig.infoText.length>0&&isCurrentlyDisabled){(await _modal_save_cancel.default.create({title:(0,_str.getString)("infotextmodalheading","block_ai_control"),body:aiconfig.infoText,show:!0,buttons:{save:(0,_str.getString)("confirm","moodle"),cancel:(0,_str.getString)("cancel","moodle")}})).getRoot().on(_modal_events.default.save,(async()=>{const refreshedData=await(0,_repository.updateAiconfig)(buildUpdateAiconfigObject());aiconfig=refreshedData,dispatchChangedEvent(refreshedData)}))}else{const refreshedData=await(0,_repository.updateAiconfig)(buildUpdateAiconfigObject());aiconfig=refreshedData,dispatchChangedEvent(refreshedData)}},buildUpdateAiconfigObject=()=>{const purposeConfigElements=baseElement.querySelectorAll('[data-toggle-identifier^="purpose_"]'),enabledToggle=baseElement.querySelector('[data-toggle-identifier="aiconfig_enabled"]'),aiconfig={};return aiconfig.id=baseElement.parentElement.dataset.contextid,aiconfig.enabled=!!parseInt(enabledToggle.dataset.checked),aiconfig.expiresat=currentTargetTime,aiconfig.purposes=[],purposeConfigElements.forEach((purposeConfigElement=>{const purpose={};purpose.id=purposeConfigElement.dataset.toggleIdentifier.replace(/^purpose_/,""),purpose.allowed=!!parseInt(purposeConfigElement.dataset.checked),aiconfig.purposes.push(purpose)})),aiconfig},dispatchChangedEvent=refreshedAiconfig=>{baseElement.dispatchEvent(new CustomEvent("aiconfigUpdated",{detail:{aiconfig:refreshedAiconfig}}))},updateTargetTime=()=>{const durationElement=baseElement.querySelector('[data-aicontrol-item="expiryduration"]'),expirydurationDays=baseElement.querySelector('[data-aicontrol-item="expiryduration_days"]'),expirydurationHours=baseElement.querySelector('[data-aicontrol-item="expiryduration_hours"]'),expirydurationMinutes=baseElement.querySelector('[data-aicontrol-item="expiryduration_minutes"]'),dateElement=baseElement.querySelector('[data-aicontrol-item="expirydate"]');if("1"===durationElement.dataset.aiconfigShow){const currentTime=new Date;currentTargetTime=currentTime.getTime()+24*expirydurationDays.value*60*60*1e3+60*expirydurationHours.value*60*1e3+60*expirydurationMinutes.value*1e3,currentTargetTime=Math.round(currentTargetTime/1e3)}else currentTargetTime=Math.round(parseInt(+new Date(dateElement.value))/1e3);dateElement.value=convertUnixtimeToDateElementFormat(currentTargetTime);const{days:days,hours:hours,minutes:minutes}=(0,_ai_control.convertTargetUnixTimeToCountdown)(currentTargetTime);expirydurationDays.value=days,expirydurationHours.value=hours,expirydurationMinutes.value=minutes},convertUnixtimeToDateElementFormat=unixtime=>{const localTargetTime=new Date(1e3*unixtime);return localTargetTime.setTime(localTargetTime.getTime()-60*localTargetTime.getTimezoneOffset()*1e3),localTargetTime.toISOString().slice(0,16)}}));

//# sourceMappingURL=ai_control_config.min.js.map