define("aiinjection_alttext/alttext_injection",["exports","core/log","core/str","core/notification","local_ai_manager/make_request","core/templates","theme_boost/bootstrap/popover"],(function(_exports,_log,_str,_notification,_make_request,_templates,_popover){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Ultra-optimized AI Alt Text injection for Tiny Media modals.
   *
   * @module     aiinjection_alttext/alttext_injection
   * @copyright  2025 ISB Bayern
   * @author     Dr. Peter Mayer
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_log=_interopRequireDefault(_log),_templates=_interopRequireDefault(_templates),_popover=_interopRequireDefault(_popover);const initializedModals=new WeakSet;let aiConfig=null,contextId=0,prompt="";const isAiDisabled=()=>{var _aiConfig,_aiConfig$purposes;return"disabled"===aiConfig.availability.available||!(null===(_aiConfig=aiConfig)||void 0===_aiConfig||null===(_aiConfig$purposes=_aiConfig.purposes)||void 0===_aiConfig$purposes||!_aiConfig$purposes[0])&&"disabled"===aiConfig.purposes[0].available},getDisabledReason=()=>isAiDisabled()?"disabled"===aiConfig.availability.available?aiConfig.availability.errormessage:aiConfig.purposes[0].errormessage||null:null,generateAltText=async imageUrl=>{const imageBase64=await(async imageUrl=>{const response=await fetch(imageUrl);if(!response.ok)throw new Error("Failed to fetch image");const blob=await response.blob();return new Promise(((resolve,reject)=>{const reader=new FileReader;reader.onload=()=>resolve(reader.result),reader.onerror=()=>reject(new Error("FileReader failed")),reader.readAsDataURL(blob)}))})(imageUrl),result=await(0,_make_request.makeRequest)("itt",prompt,"aiinjection_alttext",contextId,{image:imageBase64});if(null!=result&&result.code&&200!==result.code){const parsedResult=JSON.parse(result.result);throw parsedResult.debuginfo&&_log.default.error(parsedResult.debuginfo),new Error(parsedResult.message||"AI request failed")}return(data=>{var _data$data;if(null!=data&&data.error)return null;const result=(null==data?void 0:data.result)||(null==data||null===(_data$data=data.data)||void 0===_data$data?void 0:_data$data.result);if(!result)return null;let text=result.replace(/<[^>]*>/g,"").trim();try{text=JSON.parse('"'+text.replace(/"/g,'\\"')+'"')}catch(e){}return text||null})(Array.isArray(result)?result[0]:result)},handleButtonClick=async event=>{event.preventDefault();const button=event.target.closest('[data-action="generate-alttext"]');if(!button)return;const modal=button.closest(".modal"),textarea=modal.querySelector(".tiny_image_altentry"),image=modal.querySelector(".tiny_image_preview");if(textarea&&null!=image&&image.src&&"data:,"!==image.src){await injectButton(modal,{isloading:!0});try{const altText=await generateAltText(image.src);altText&&(textarea.value=altText,textarea.dispatchEvent(new Event("input",{bubbles:!0})),textarea.dispatchEvent(new Event("change",{bubbles:!0})))}catch(error){_log.default.error("Alt text generation failed:",error);const errorMessage=await(0,_str.getString)("generateerrorwithmessage","aiinjection_alttext",error.message);await async function(message){let title=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;null===title&&(title=await(0,_str.getString)("generateerror","aiinjection_alttext")),await(0,_notification.alert)(title,message)}(errorMessage)}await injectButton(modal,{isloading:!1})}},injectButton=async function(modal){let templateContext=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const countspan=modal.querySelector('[data-region="character-count"]')||modal.querySelector("#the-count");if(!countspan)return;const existingButton=modal.querySelector('[data-action="generate-alttext"]');existingButton&&existingButton.remove(),isAiDisabled()&&(templateContext.isdisabled=!0,templateContext.disabledreason=getDisabledReason());const{html:html,js:js}=await _templates.default.renderForPromise("aiinjection_alttext/ai_button_container",templateContext);_templates.default.appendNodeContents(countspan.parentElement,html,js);const popoverTrigger=countspan.parentElement.querySelector('[data-bs-toggle="popover"]');popoverTrigger&&new _popover.default(popoverTrigger);const button=modal.querySelector('[data-action="generate-alttext"]');button&&!isAiDisabled()&&button.addEventListener("click",handleButtonClick)};_exports.init=config=>{aiConfig=config.aiconfig,contextId=config.contextid||0,prompt=config.prompt||"",new MutationObserver((mutations=>{mutations.forEach((mutation=>{mutation.addedNodes.forEach((node=>{if(node.nodeType===Node.ELEMENT_NODE){var _node$classList,_node$querySelector;null!==(_node$classList=node.classList)&&void 0!==_node$classList&&_node$classList.contains("modal")&&node.querySelector(".tiny_image_altentry")&&(initializedModals.has(node)||(initializedModals.add(node),injectButton(node)));const altentry=null===(_node$querySelector=node.querySelector)||void 0===_node$querySelector?void 0:_node$querySelector.call(node,".modal .tiny_image_altentry");if(altentry){const modalElement=altentry.closest(".modal");modalElement&&!initializedModals.has(modalElement)&&(initializedModals.add(modalElement),injectButton(modalElement))}}}))}))})).observe(document.body,{childList:!0,subtree:!0});document.querySelectorAll(".modal .tiny_image_altentry").forEach((textarea=>{const modal=textarea.closest(".modal");modal&&!initializedModals.has(modal)&&(initializedModals.add(modal),injectButton(modal))}))}}));

//# sourceMappingURL=alttext_injection.min.js.map