define("mod_kanban/card",["exports","core/reactive","mod_kanban/selectors","mod_kanban/exporter","core/notification","core_form/modalform","core/modal_events","core/str","core/templates","mod_kanban/kanbancomponent","core/log"],(function(_exports,_reactive,_selectors,_exporter,_notification,_modalform,_modal_events,Str,_templates,_kanbancomponent,_log){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_selectors=_interopRequireDefault(_selectors),_exporter=_interopRequireDefault(_exporter),_modalform=_interopRequireDefault(_modalform),_modal_events=_interopRequireDefault(_modal_events),Str=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Str),_templates=_interopRequireDefault(_templates),_kanbancomponent=_interopRequireDefault(_kanbancomponent),_log=_interopRequireDefault(_log);class _default extends _kanbancomponent.default{constructor(){var obj,key,value;super(...arguments),value={year:31536e6,month:2628e6,day:864e5,hour:36e5,minute:6e4,second:1e3},(key="_units")in(obj=this)?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value}static init(target){return new this({element:document.getElementById(target)})}create(){this.id=this.element.dataset.id}getWatchers(){return[{watch:"cards[".concat(this.id,"]:updated"),handler:this._cardUpdated},{watch:"cards[".concat(this.id,"]:deleted"),handler:this._cardDeleted},{watch:"discussions:created",handler:this._discussionUpdated},{watch:"discussions:updated",handler:this._discussionUpdated},{watch:"discussions:deleted",handler:this._discussionUpdated},{watch:"history:created",handler:this._historyUpdated},{watch:"history:updated",handler:this._historyUpdated},{watch:"history:deleted",handler:this._historyUpdated}]}stateReady(state){let lang="en";void 0!==state.common.lang&&(lang=state.common.lang);try{this.rtf=new Intl.RelativeTimeFormat(lang,{numeric:"auto"})}catch(e){this.rtf=new Intl.RelativeTimeFormat("en",{numeric:"auto"})}this.addEventListener(this.getElement(_selectors.default.DELETECARD,this.id),"click",this._removeConfirm),this.addEventListener(this.getElement(_selectors.default.ADDCARD,this.id),"click",this._addCard),this.addEventListener(this.getElement(_selectors.default.COMPLETE,this.id),"click",this._completeCard),this.addEventListener(this.getElement(_selectors.default.UNCOMPLETE,this.id),"click",this._uncompleteCard),this.addEventListener(this.getElement(_selectors.default.ASSIGNSELF,this.id),"click",this._assignSelf),this.addEventListener(this.getElement(_selectors.default.UNASSIGNSELF,this.id),"click",this._unassignSelf),this.addEventListener(this.getElement(_selectors.default.EDITDETAILS,this.id),"click",this._editDetails),this.addEventListener(this.getElement(_selectors.default.DISCUSSIONMODALTRIGGER),"click",this._updateDiscussion),this.addEventListener(this.getElement(_selectors.default.DISCUSSIONSHOW,this.id),"click",this._updateDiscussion),this.addEventListener(this.getElement(_selectors.default.DISCUSSIONSEND),"click",this._sendMessage),this.addEventListener(this.getElement(_selectors.default.HISTORYMODALTRIGGER),"click",this._updateHistory),this.addEventListener(this.getElement(_selectors.default.MOVEMODALTRIGGER),"click",this._showMoveModal),this.addEventListener(this.getElement(_selectors.default.PUSHCARD),"click",this._pushCardConfirm),this.addEventListener(this.getElement(_selectors.default.DUPLICATE),"click",this._duplicateCard),this.addEventListener(this.getElement(_selectors.default.DETAILBUTTON),"click",this._showDetailsModal),this.draggable=!1,this.dragdrop=new _reactive.DragDrop(this),this.checkEditing(state),this.boardid=state.board.id,this.cmid=state.common.id,this.userid=state.board.userid,this.groupid=state.board.groupid,this._dueDateFormat()}_showMoveModal(){let data=_exporter.default.exportStateForTemplate(this.reactive.state);data.cardid=this.id,data.kanbancolumn=this.reactive.state.cards.get(this.id).kanban_column,Str.get_strings([{key:"movecard",component:"mod_kanban"},{key:"move",component:"core"}]).then((strings=>(0,_notification.saveCancel)(strings[0],_templates.default.render("mod_kanban/movemodal",data),strings[1],(()=>{let column=document.querySelector(_selectors.default.MOVECARDCOLUMN+'[data-id="'.concat(this.id,'"]')).value,aftercard=document.querySelector(_selectors.default.MOVECARDAFTERCARD+'[data-id="'.concat(this.id,'"]')).value;this.reactive.dispatch("moveCard",this.id,column,aftercard)})))).catch((error=>_log.default.debug(error)))}_showDetailsModal(event){let id=this.id;void 0!==event.target.dataset.id&&(id=event.target.dataset.id);let data=_exporter.default.exportCard(this.reactive.state,id),title=this.reactive.state.common.usenumbers?"#"+data.number+" "+data.title:data.title;(0,_notification.alert)(title,_templates.default.render("mod_kanban/descriptionmodal",data),(0,Str.get_string)("close","form")).then((modal=>(modal.modal[0].addEventListener(_modal_events.default.bodyRendered,(()=>{document.querySelectorAll(_selectors.default.CARDNUMBER).forEach((el=>{this.removeEventListener(el,"click",this._clickDetailsButton),this.addEventListener(el,"click",this._clickDetailsButton)}))})),!0))).catch((error=>_log.default.debug(error)))}_clickDetailsButton(event){document.querySelector(_selectors.default.CARD+'[data-number="'.concat(event.target.dataset.id,'"]')+" "+_selectors.default.DETAILBUTTON).click()}_pushCardConfirm(event){Str.get_strings([{key:"pushcard",component:"mod_kanban"},{key:"pushcardconfirm",component:"mod_kanban"},{key:"copy",component:"core"}]).then((strings=>(0,_notification.saveCancel)(strings[0],strings[1],strings[2],(()=>{this._pushCard(event)})))).catch((error=>_log.default.debug(error)))}_removeConfirm(event){Str.get_strings([{key:"deletecard",component:"mod_kanban"},{key:"deletecardconfirm",component:"mod_kanban"},{key:"delete",component:"core"}]).then((strings=>(0,_notification.saveCancel)(strings[0],strings[1],strings[2],(()=>{this._removeCard(event)})))).catch((error=>_log.default.debug(error)))}_removeMessageConfirm(event){Str.get_strings([{key:"deletemessage",component:"mod_kanban"},{key:"deletemessageconfirm",component:"mod_kanban"},{key:"delete",component:"core"}]).then((strings=>(0,_notification.saveCancel)(strings[0],strings[1],strings[2],(()=>{this._removeMessage(event)})))).catch((error=>_log.default.debug(error)))}_sendMessage(){let el=this.getElement(_selectors.default.DISCUSSIONINPUT),message=el.value.trim();""!=message&&(this.reactive.dispatch("sendDiscussionMessage",this.id,message),el.value="")}_updateDiscussion(){this.getElement(_selectors.default.DISCUSSIONMODAL).classList.add("mod_kanban_loading"),this.reactive.dispatch("getDiscussionUpdates",this.id)}async _discussionUpdated(){let data={discussions:_exporter.default.exportDiscussion(this.reactive.state,this.id)};_templates.default.renderForPromise("mod_kanban/discussionmessages",data).then((_ref=>{let{html:html}=_ref;this.getElement(_selectors.default.DISCUSSION,this.id).innerHTML=html,this.getElement(_selectors.default.DISCUSSIONMODAL,this.id).classList.remove("mod_kanban_loading");let el=this.getElement(_selectors.default.DISCUSSIONMESSAGES);return el.scrollTop=el.scrollHeight,data.discussions.forEach((d=>{d.candelete&&this.addEventListener(this.getElement(_selectors.default.DELETEMESSAGE,d.id),"click",this._removeMessageConfirm)})),this.getElement(_selectors.default.DISCUSSION).querySelectorAll(_selectors.default.CARDNUMBER).forEach((el=>{this.removeEventListener(el,"click",this._clickDetailsButton),this.addEventListener(el,"click",this._clickDetailsButton)})),!0})).catch((error=>(0,_notification.exception)(error)))}_updateHistory(){this.getElement(_selectors.default.HISTORYMODAL).classList.add("mod_kanban_loading"),this.reactive.dispatch("getHistoryUpdates",this.id)}async _historyUpdated(){let data={historyitems:_exporter.default.exportHistory(this.reactive.state,this.id)};_templates.default.renderForPromise("mod_kanban/historyitems",data).then((_ref2=>{let{html:html}=_ref2;this.getElement(_selectors.default.HISTORY,this.id).innerHTML=html,this.getElement(_selectors.default.HISTORYMODAL).classList.remove("mod_kanban_loading");let el=this.getElement(_selectors.default.HISTORYITEMS);return el.scrollTop=el.scrollHeight,!0})).catch((error=>(0,_notification.exception)(error)))}_assignSelf(event){let target=event.target.closest(_selectors.default.ASSIGNSELF),data=Object.assign({},target.dataset);this.reactive.dispatch("assignUser",data.id)}_addCard(event){document.activeElement.blur();let target=event.target.closest(_selectors.default.ADDCARD),data=Object.assign({},target.dataset);this.reactive.dispatch("addCard",data.columnid,data.id)}async _cardUpdated(_ref3){let{element:element}=_ref3;const card=this.getElement();if(card.dataset.columnid!=element.kanban_column){document.querySelector(_selectors.default.COLUMNINNER+'[data-id="'+element.kanban_column+'"]').appendChild(card),this.getElement(_selectors.default.ADDCARD,this.id).setAttribute("data-columnid",element.kanban_column),card.setAttribute("data-columnid",element.kanban_column)}const assignees=this.getElement(_selectors.default.ASSIGNEES,this.id),assignedUsers=this.getElements(_selectors.default.ASSIGNEDUSER,this.id),userids=[...assignedUsers].map((v=>v.dataset.userid));if(void 0!==element.assignees){const additional=element.assignees.filter((x=>!userids.includes(x)));null!==assignedUsers&&assignedUsers.forEach((assignedUser=>{element.assignees.includes(assignedUser.dataset.userid)||assignedUser.parentNode.removeChild(assignedUser)})),this.toggleClass(0==element.assignees.length,"mod_kanban_unassigned"),element.assignees.length>0&&additional.forEach((async user=>{let userdata=this.reactive.state.users.get(user),data=Object.assign({cardid:element.id},userdata);data=Object.assign(data,_exporter.default.exportCapabilities(this.reactive.state)),_templates.default.renderForPromise("mod_kanban/user",data).then((_ref4=>{let{html:html,js:js}=_ref4;return _templates.default.appendNodeContents(assignees,html,js),!0})).catch((error=>(0,_notification.exception)(error)))}))}if(this.toggleClass(element.selfassigned,"mod_kanban_selfassigned"),this.toggleClass(1==element.completed,"mod_kanban_closed"),void 0!==element.title){let doc=(new DOMParser).parseFromString(element.title,"text/html");this.getElement(_selectors.default.INPLACEEDITABLE).setAttribute("data-value",doc.documentElement.textContent),this.getElement(_selectors.default.INPLACEEDITABLE).querySelector("a").innerHTML=element.title,this.getElement(_selectors.default.DISCUSSIONMODALTITLE).innerHTML=element.title}if(this.toggleClass(element.hasdescription,"mod_kanban_hasdescription"),this.toggleClass(element.hasattachment,"mod_kanban_hasattachment"),void 0!==element.duedate&&(this.getElement(_selectors.default.DUEDATE).setAttribute("data-date",element.duedate),this._dueDateFormat()),this.toggleClass(element.discussion,"mod_kanban_hasdiscussion"),void 0!==element.options){let options=JSON.parse(element.options);void 0===options.background?this.getElement().removeAttribute("style"):this.getElement().setAttribute("style","background-color: "+options.background)}this.checkEditing()}_cardDeleted(){this.destroy()}_removeCard(event){let target=event.target.closest(_selectors.default.DELETECARD),data=Object.assign({},target.dataset);this.reactive.dispatch("deleteCard",data.id)}_pushCard(event){let target=event.target.closest(_selectors.default.PUSHCARD),data=Object.assign({},target.dataset);this.reactive.dispatch("pushCard",data.id)}_removeMessage(event){let target=event.target.closest(_selectors.default.DELETEMESSAGE),data=Object.assign({},target.dataset);this.reactive.dispatch("deleteMessage",data.id)}_completeCard(event){let target=event.target.closest(_selectors.default.COMPLETE),data=Object.assign({},target.dataset);this.reactive.dispatch("completeCard",data.id)}_uncompleteCard(event){let target=event.target.closest(_selectors.default.UNCOMPLETE),data=Object.assign({},target.dataset);this.reactive.dispatch("uncompleteCard",data.id)}destroy(){void 0!==this.dragdrop&&this.dragdrop.unregister()}getDraggableData(){return{id:this.id,type:"card"}}checkEditing(state){void 0===state&&(state=this.reactive.stateManager.state),state.cards.get(this.id).canedit?(this.draggable=!0,this.dragdrop.setDraggable(!0)):(this.draggable=!1,this.dragdrop.setDraggable(!1)),1!=state.cards.get(this.id).completed&&state.cards.get(this.id).canedit?this.getElement(_selectors.default.INPLACEEDITABLE).setAttribute("data-inplaceeditable","1"):this.getElement(_selectors.default.INPLACEEDITABLE).removeAttribute("data-inplaceeditable"),this.toggleClass(state.cards.get(this.id).canedit,"mod_kanban_canedit")}validateDropData(dropdata){return"card"==(null==dropdata?void 0:dropdata.type)}drop(dropdata){if(dropdata.id!=this.id){let newcolumn=this.getElement(_selectors.default.ADDCARD,this.id).dataset.columnid,aftercard=this.id;this.reactive.dispatch("moveCard",dropdata.id,newcolumn,aftercard)}}_unassignSelf(event){let target=event.target.closest(_selectors.default.UNASSIGNSELF),data=Object.assign({},target.dataset);this.reactive.dispatch("unassignUser",data.id)}_editDetails(event){event.preventDefault();const modalForm=new _modalform.default({formClass:"mod_kanban\\form\\edit_card_form",args:{id:this.id,boardid:this.boardid,cmid:this.cmid,groupid:this.groupid,userid:this.userid},modalConfig:{title:(0,Str.get_string)("editcard","mod_kanban")},returnFocus:this.getElement()});this.addEventListener(modalForm,modalForm.events.FORM_SUBMITTED,this._updateCard),modalForm.show()}_updateCard(event){this.reactive.dispatch("processUpdates",event.detail)}updateRelativeTime(timestamp){let elapsed=new Date(timestamp)-new Date;for(var u in this._units)if(Math.abs(elapsed)>this._units[u]||"second"==u)return this.rtf.format(Math.round(elapsed/this._units[u]),u);return""}_dueDateFormat(){let duedate=1e3*this.getElement(_selectors.default.DUEDATE).dataset.date;if(duedate>0){let element=this.getElement(_selectors.default.DUEDATE);element.innerHTML=this.updateRelativeTime(duedate),duedate<(new Date).getTime()?element.classList.add("mod_kanban_overdue"):element.classList.remove("mod_kanban_overdue")}else this.getElement(_selectors.default.DUEDATE).innerHTML=""}_duplicateCard(event){let target=event.target.closest(_selectors.default.DUPLICATE),data=Object.assign({},target.dataset);this.reactive.dispatch("duplicateCard",data.id)}}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=card.min.js.map