define("mod_kanban/exporter",["exports","mod_kanban/capabilities"],(function(_exports,_capabilities){var obj;
/**
   * Exporter for use in mustache template.
   * @module mod_kanban/exporter
   * @copyright 2024 ISB Bayern
   * @author Stefan Hanauska stefan.hanauska@csg-in.de
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_capabilities=(obj=_capabilities)&&obj.__esModule?obj:{default:obj};return _exports.default=class{static exportStateForTemplate(state){let columnOrder=state.board.sequence.split(","),columns=[],hascolumns=""!=state.board.sequence;hascolumns&&(columns=columnOrder.map((value=>this.exportCardsForColumn(state,value))),columns=columns.filter((value=>void 0!==value.id)));let showactionmenu=1==state.common.userboards||""!=state.common.groupselector||state.capabilities.get(_capabilities.default.MANAGEBOARD).value||2==state.common.userboards&&state.capabilities.get(_capabilities.default.VIEWALLBOARDS).value;return Object.assign({cmid:state.common.id,id:state.board.id,sequence:state.board.sequence,hascolumns:hascolumns,columns:columns,locked:state.board.locked,hastemplate:0!=state.common.template,istemplate:0!=state.board.template,heading:state.board.heading,groupselector:state.common.groupselector,userboards:state.common.userboards,history:state.common.history&&state.capabilities.get(_capabilities.default.VIEWHISTORY).value,groupmode:state.common.groupmode,ismyuserboard:state.common.userid==state.board.userid,myuserid:state.common.userid,showactionmenu:showactionmenu,userboardsonly:2==state.common.userboards,iscourseboard:0==state.board.userid&&0==state.board.groupid&&0==state.board.template,users:JSON.parse(JSON.stringify(state.users)),usenumbers:state.common.usenumbers},this.exportCapabilities(state))}static exportCardsForColumn(state,columnid){let column=state.columns.get(columnid);if(void 0===column)return{};let col=JSON.parse(JSON.stringify(column)),options=JSON.parse(col.options);if(col.hascards=""!=col.sequence,col.autoclose=options.autoclose,col.autohide=options.autohide,options.wiplimit>0&&(col.wiplimit=options.wiplimit),col.cardcount=0,col.hascards){let cardOrder=col.sequence.split(",");col.cards=cardOrder.map((value=>this.exportCard(state,value))),col.cardcount=cardOrder.length}return col}static exportCard(state,cardid){let card={id:cardid,title:"-",assignees:[],options:"{}",canedit:!1,number:0};void 0!==state.cards.get(cardid)&&(card=JSON.parse(JSON.stringify(state.cards.get(cardid)))),card.cardid=card.id,card.hasassignees=card.assignees.length>0;let options=JSON.parse(card.options);return card.hasassignees&&"number"==typeof card.assignees[0]&&(card.assignees=card.assignees.map((userid=>state.users.get(userid))),card.assignees=[...new Set(card.assignees)]),Object.assign(card,options)}static exportCapabilities(state){let capabilities=[];return state.capabilities.forEach((c=>{capabilities[c.id]=c.value})),Object.assign({},capabilities)}static exportDiscussion(state,cardId){let d=[];return state.discussions.forEach((c=>{c.kanban_card==cardId&&d.push(c)})),d=d.sort(((a,b)=>parseInt(a.timecreated)>parseInt(b.timecreated))),d}static exportHistory(state,cardId){let d=[];return state.history.forEach((c=>{c.kanban_card==cardId&&d.push(c)})),d=d.sort(((a,b)=>parseInt(a.timestamp)>parseInt(b.timestamp))),d}},_exports.default}));

//# sourceMappingURL=exporter.min.js.map