define("mod_kanban/mutations",["exports","core/ajax","core/notification","core/str","core/log"],(function(_exports,_ajax,_notification,_str,_log){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_log=_interopRequireDefault(_log);return _exports.default=class{constructor(){var obj,key,value;value=0,(key="updateFails")in(obj=this)?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value}async saveAsTemplate(stateManager){await this._sendChange("save_as_template",stateManager)}async deleteCard(stateManager,cardId){await this._sendChange("delete_card",stateManager,{cardid:cardId})}async deleteBoard(stateManager){await this._sendChange("delete_board",stateManager)}async addCard(stateManager,columnId,afterCard){await this._sendChange("add_card",stateManager,{columnid:columnId,aftercard:afterCard})}async moveCard(stateManager,cardId,columnId,afterCard){await this._sendChange("move_card",stateManager,{cardid:cardId,columnid:columnId,aftercard:afterCard})}async deleteColumn(stateManager,columnId){await this._sendChange("delete_column",stateManager,{columnid:columnId})}async addColumn(stateManager,afterColumn){await this._sendChange("add_column",stateManager,{aftercol:afterColumn})}async moveColumn(stateManager,columnId,afterColumn){await this._sendChange("move_column",stateManager,{columnid:columnId,aftercol:afterColumn})}async assignUser(stateManager,cardId){let userId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;await this._sendChange("assign_user",stateManager,{cardid:cardId,userid:userId})}async completeCard(stateManager,cardId){await this._sendChange("set_card_complete",stateManager,{cardid:cardId,state:1})}async uncompleteCard(stateManager,cardId){await this._sendChange("set_card_complete",stateManager,{cardid:cardId,state:0})}async unassignUser(stateManager,cardId){let userId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;await this._sendChange("unassign_user",stateManager,{cardid:cardId,userid:userId})}async lockColumn(stateManager,columnId){await this._sendChange("set_column_locked",stateManager,{columnid:columnId,state:1})}async unlockColumn(stateManager,columnId){await this._sendChange("set_column_locked",stateManager,{columnid:columnId,state:0})}async lockColumns(stateManager){await this._sendChange("set_board_columns_locked",stateManager,{state:1})}async unlockColumns(stateManager){await this._sendChange("set_board_columns_locked",stateManager,{state:0})}async sendDiscussionMessage(stateManager,cardId,message){await this._sendChange("add_discussion_message",stateManager,{cardid:cardId,message:message})}async deleteMessage(stateManager,messageId){await this._sendChange("delete_discussion_message",stateManager,{messageid:messageId})}async pushCard(stateManager,cardId){await this._sendChange("push_card_copy",stateManager,{cardid:cardId})}async _sendChange(method,stateManager,data){const state=stateManager.state,request={methodname:"mod_kanban_"+method,args:{cmid:state.common.id,boardid:state.board.id,data:data},fail:this.displayError};let result=null;try{result=await _ajax.default.call([request])[0]}catch(e){return void(e instanceof Object||(_log.default.warn("Sending a change request to the kanban backend failed, probably due to connection loss."),this.processUpdateFail(stateManager)))}this.processUpdates(stateManager,result)}async getUpdates(stateManager){const state=stateManager.state;if(void 0===state.board)stateManager.setReadOnly(!1),stateManager.eventsToPublish.push({eventName:"board:deleted",eventData:{},action:"deleted"}),stateManager.setReadOnly(!0);else{let result=null;try{result=await _ajax.default.call([{methodname:"mod_kanban_get_kanban_content_update",args:{cmid:state.common.id,boardid:state.board.id,timestamp:state.common.timestamp},fail:()=>{this.processUpdateFail(stateManager)}}])[0]}catch(e){return void(e instanceof Object||(_log.default.warn("Sending a change request to the kanban backend failed, probably due to connection loss."),this.processUpdateFail(stateManager)))}this.processUpdates(stateManager,result)}}processUpdateFail(stateManager){const state=stateManager.state;stateManager.setReadOnly(!1),state.common.updatefails++,stateManager.setReadOnly(!0)}async displayError(data){data.message&&await _notification.default.alert((0,_str.get_string)("error"),data.message,(0,_str.get_string)("cancel"))}async getDiscussionUpdates(stateManager,cardId){const state=stateManager.state;let timestamp=0;state.discussions.forEach((c=>{c.kanban_card==cardId&&c.timestamp>timestamp&&(timestamp=c.timestamp)}));const result=await _ajax.default.call([{methodname:"mod_kanban_get_discussion_update",args:{cmid:state.common.id,boardid:state.board.id,cardid:cardId,timestamp:timestamp},fail:()=>{this.processUpdateFail(stateManager)}}])[0];this.processUpdates(stateManager,result)}async getHistoryUpdates(stateManager,cardId){const state=stateManager.state;let timestamp=0;state.history.forEach((c=>{c.kanban_card==cardId&&c.timestamp>timestamp&&(timestamp=c.timestamp)}));const result=await _ajax.default.call([{methodname:"mod_kanban_get_history_update",args:{cmid:state.common.id,boardid:state.board.id,cardid:cardId,timestamp:timestamp},fail:()=>{this.processUpdateFail(stateManager)}}])[0];this.processUpdates(stateManager,result)}async processUpdates(stateManager,result){let updates=JSON.parse(result.update);stateManager.processUpdates(updates)}async duplicateCard(stateManager,cardId){await this._sendChange("duplicate_card",stateManager,{cardid:cardId})}},_exports.default}));

//# sourceMappingURL=mutations.min.js.map