define("tiny_ai/datahandler/basedata",["exports","core/str","core/prefetch","tiny_ai/constants"],(function(_exports,_str,_prefetch,_constants){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.getTinyAiString=_exports.getShowPromptButtonContext=_exports.getReplaceButtonsContext=_exports.getInputContext=_exports.getBackAndGenerateButtonContext=void 0;
/**
   * Tiny AI base data provider.
   *
   * @module      tiny_ai/datahandler/basedata
   * @copyright   2024, ISB Bayern
   * @author      Philipp Memmel
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const stringKeys=["aigenerating","aisuggestion","audiogen_headline","audiogen_placeholder","back","backbutton_tooltip","cancel","deletebutton_tooltip","describe_baseprompt","describe_headline","dismiss","dismisssuggestion","error_nopromptgiven","freeprompt_placeholder","freepromptbutton_tooltip","gender","generalerror","generate","generatebutton_tooltip","hideprompt","imggen_headline","imggen_placeholder","insertatcaret","insertatcaretbutton_tooltip","insertbelow","insertbelowbutton_tooltip","keeplanguagetype","languagetype","languagetype_prompt","mainselection_heading","maxwordcount","maxwordcount_prompt","nomaxwordcount","regeneratebutton_tooltip","replaceselection","replaceselectionbutton_tooltip","reworkprompt","simplelanguage","size","showprompt","showpromptbutton_tooltip","summarize_baseprompt","summarize_headline","targetlanguage","technicallanguage","texttouse","toolname_audiogen","toolname_describe","toolname_describe_extension","toolname_imggen","toolname_summarize","toolname_summarize_extension","toolname_translate","toolname_translate_extension","toolname_tts","toolname_tts_extension","translate_baseprompt","translate_headline","tts_headline","voice"];let strings={};_exports.init=async()=>{(0,_prefetch.prefetchStrings)("tiny_ai",stringKeys);const stringRequest=stringKeys.map((key=>({key:key,component:"tiny_ai"})));[strings.aigenerating,strings.aisuggestion,strings.audiogen_headline,strings.audiogen_placeholder,strings.back,strings.backbutton_tooltip,strings.cancel,strings.deletebutton_tooltip,strings.describe_baseprompt,strings.describe_headline,strings.dismiss,strings.dismisssuggestion,strings.error_nopromptgiven,strings.freeprompt_placeholder,strings.freepromptbutton_tooltip,strings.gender,strings.generalerror,strings.generate,strings.generatebutton_tooltip,strings.hideprompt,strings.imggen_headline,strings.imggen_placeholder,strings.insertatcaret,strings.insertatcaretbutton_tooltip,strings.insertbelow,strings.insertbelowbutton_tooltip,strings.keeplanguagetype,strings.languagetype,strings.languagetype_prompt,strings.mainselection_heading,strings.maxwordcount,strings.maxwordcount_prompt,strings.nomaxwordcount,strings.regeneratebutton_tooltip,strings.replaceselection,strings.replaceselectionbutton_tooltip,strings.reworkprompt,strings.simplelanguage,strings.size,strings.showprompt,strings.showpromptbutton_tooltip,strings.summarize_baseprompt,strings.summarize_headline,strings.targetlanguage,strings.technicallanguage,strings.texttouse,strings.toolname_audiogen,strings.toolname_describe,strings.toolname_describe_extension,strings.toolname_imggen,strings.toolname_summarize,strings.toolname_summarize_extension,strings.toolname_translate,strings.toolname_translate_extension,strings.toolname_tts,strings.toolname_tts_extension,strings.translate_baseprompt,strings.translate_headline,strings.tts_headline,strings.voice]=await(0,_str.getStrings)(stringRequest)};_exports.getTinyAiString=string=>strings[string];_exports.getBackAndGenerateButtonContext=()=>({footer_buttons:[{hasText:!0,button_text:strings.back,icon_left:!0,icon_right:!1,primary:!1,secondary:!1,tertiary:!0,iconname:"arrow-left",iconstyle:"solid",action:"back",tooltip:strings.backbutton_tooltip},{hasText:!0,button_text:strings.generate,icon_left:!0,icon_right:!1,primary:!0,secondary:!1,tertiary:!1,iconname:"sparkle",customicon:!0,action:"generate",tooltip:strings.generatebutton_tooltip}]});_exports.getReplaceButtonsContext=mode=>({footer_iconbuttons:[{action:"delete",iconname:"trash",tooltip:strings.deletebutton_tooltip},{action:"regenerate",iconname:"arrows-rotate",tooltip:strings.regeneratebutton_tooltip}],footer_buttons:[{action:"insertbelow",hasText:!0,button_text:strings.insertbelow,icon_left:!0,icon_right:!1,secondary:!0,iconname:"text-insert-last",customicon:!0,tooltip:strings.insertbelow_tooltip},{action:mode===_constants.constants.modalModes.selection?"replace":"insertatcaret",hasText:!0,button_text:mode===_constants.constants.modalModes.selection?strings.replaceselection:strings.insertatcaret,icon_left:!0,icon_right:!1,primary:!0,iconname:"check",iconstyle:"solid",tooltip:mode===_constants.constants.modalModes.selection?strings.replaceselection_tooltip:strings.insertatcaret_tooltip}]});_exports.getInputContext=()=>({input:[{iconname:"sparkle",customicon:!0,button:[{customicon:!1,iconname:"arrow-right",iconstyle:"solid",icon_left:!1,icon_right:!0,tooltip:strings.freepromptbutton_tooltip}]}]});_exports.getShowPromptButtonContext=()=>({hasText:!0,button_text:strings.showprompt,icon_left:!0,icon_right:!1,tertiary:!0,iconname:"eye",iconstyle:"solid",action:"showprompt",textareatype:"prompt",collapsed:!0,tooltip:strings.showpromptbutton_tooltip})}));

//# sourceMappingURL=basedata.min.js.map