define("tiny_ai/datahandler/start",["exports","core/config","core/str","tiny_ai/constants","tiny_ai/datahandler/basedata","tiny_ai/datahandler/base","local_ai_manager/config","tiny_ai/utils"],(function(_exports,config,_str,_constants,BasedataHandler,_base,_config2,_utils){var obj;function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * Tiny AI data handler for start page.
   *
   * @module      tiny_ai/datahandler/start
   * @copyright   2024, ISB Bayern
   * @author      Philipp Memmel
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,config=_interopRequireWildcard(config),BasedataHandler=_interopRequireWildcard(BasedataHandler),_base=(obj=_base)&&obj.__esModule?obj:{default:obj};class _default extends _base.default{constructor(){super(...arguments),_defineProperty(this,"stringKeys",["error_limitreached","error_pleaseconfirm","error_purposenotconfigured","error_tenantdisabled","error_unavailable_noselection","error_unavailable_selection","error_userlocked","error_usernotconfirmed"]),_defineProperty(this,"aiConfig",null),_defineProperty(this,"strings",{})}async init(){this.aiConfig=await(0,_config2.getAiConfig)();const stringRequest=this.stringKeys.map((key=>({key:key,component:"local_ai_manager"})));[this.strings.error_limitreached,this.strings.error_pleaseconfirm,this.strings.error_purposenotconfigured,this.strings.error_tenantdisabled,this.strings.error_unavailable_noselection,this.strings.error_unavailable_selection,this.strings.error_userlocked,this.strings.error_usernotconfirmed]=await(0,_str.getStrings)(stringRequest),this.strings.error_editor_notavailable=await(0,_str.getString)("error_tiny_ai_notavailable","tiny_ai");const confirmLink=document.createElement("a");confirmLink.href="".concat(config.wwwroot,"/local/ai_manager/confirm_ai_usage.php"),confirmLink.innerText=this.strings.error_pleaseconfirm,confirmLink.target="_blank",this.strings.combinedusernotconfirmederror=this.strings.error_usernotconfirmed+" "+confirmLink.outerHTML}getPurposeConfig(tool){if(null===this.aiConfig)throw new Error("Coding error: init function was not called before accessing this.getPurposeConfig!");const toolPurpose=_constants.constants.toolPurposeMapping[tool];return this.aiConfig.purposes.filter((purpose=>purpose.purpose===toolPurpose))[0]}isTinyAiDisabled(){return this.aiConfig.tenantenabled?this.aiConfig.userconfirmed?this.aiConfig.userlocked?this.strings.error_userlocked:"":this.strings.combinedusernotconfirmederror:this.strings.error_tenantdisabled}isToolDisabled(tool,mode){if(this.isTinyAiDisabled())return this.isTinyAiDisabled();const purposeInfo=this.getPurposeConfig(tool);return purposeInfo.isconfigured?purposeInfo.limitreached?this.strings.error_limitreached:mode===_constants.constants.modalModes.selection?["audiogen","imggen"].includes(tool)?this.strings.error_unavailable_noselection:"":mode===_constants.constants.modalModes.general&&["summarize","translate","describe","tts"].includes(tool)?this.strings.error_unavailable_selection:"":this.strings.error_purposenotconfigured}isToolHidden(tool){const purposeInfo=this.getPurposeConfig(tool);if("role_basic"===this.aiConfig.role){if(!this.aiConfig.tenantenabled)return!0;if(!purposeInfo.isconfigured)return!0}return!1}async getTemplateContext(editorUtils){const mode=editorUtils.getMode();let toolButtons=[];"role_basic"===this.aiConfig.role&&this.isTinyAiDisabled()&&(await(0,_utils.errorAlert)(await(0,_str.getString)("error_tiny_ai_notavailable","tiny_ai")+"<br/>"+this.isTinyAiDisabled()),editorUtils.getModal().destroy()),this.isToolHidden("summarize")||toolButtons.push({toolname:"summarize",tool:BasedataHandler.getTinyAiString("toolname_summarize"),description:BasedataHandler.getTinyAiString("toolname_summarize_extension"),customicon:!0,iconname:"shorten",disabled:this.isToolDisabled("summarize",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("summarize",mode)),action:"loadsummarize"}),this.isToolHidden("translate")||toolButtons.push({toolname:"translate",tool:BasedataHandler.getTinyAiString("toolname_translate"),description:BasedataHandler.getTinyAiString("toolname_translate_extension"),iconname:"language",iconstyle:"solid",disabled:this.isToolDisabled("translate",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("translate",mode)),action:"loadtranslate"}),this.isToolHidden("describe")||toolButtons.push({toolname:"describe",tool:BasedataHandler.getTinyAiString("toolname_describe"),description:BasedataHandler.getTinyAiString("toolname_describe_extension"),customicon:!0,iconname:"extend",disabled:this.isToolDisabled("describe",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("describe",mode)),action:"loaddescribe"}),this.isToolHidden("tts")||toolButtons.push({toolname:"tts",tool:BasedataHandler.getTinyAiString("toolname_tts"),description:BasedataHandler.getTinyAiString("toolname_tts_extension"),iconstyle:"solid",iconname:"microphone",disabled:this.isToolDisabled("tts",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("tts",mode)),action:"loadtts"}),this.isToolHidden("audiogen")||toolButtons.push({toolname:"audiogen",tool:BasedataHandler.getTinyAiString("toolname_audiogen"),iconstyle:"solid",iconname:"microphone",disabled:this.isToolDisabled("audiogen",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("audiogen",mode)),action:"loadaudiogen"}),this.isToolHidden("imggen")||toolButtons.push({toolname:"imggen",tool:BasedataHandler.getTinyAiString("toolname_imggen"),iconstyle:"solid",iconname:"image",disabled:this.isToolDisabled("imggen",mode).length>0,tooltip:(0,_utils.stripHtmlTags)(this.isToolDisabled("imggen",mode)),action:"loadimggen"}),toolButtons.sort(((a,b)=>a.disabled&&!b.disabled?1:b.disabled&&!a.disabled?-1:0));const templateContext={showIcon:!0,modal_headline:BasedataHandler.getTinyAiString("mainselection_heading"),action:"loadfreeprompt",modal_buttons:toolButtons,freeprompthidden:!0};return Object.assign(templateContext,BasedataHandler.getInputContext()),this.isTinyAiDisabled()&&(templateContext.input[0].disabled=!0,templateContext.input[0].hasError=!0,templateContext.input[0].errorMessage=this.isTinyAiDisabled()),this.isToolDisabled("freeprompt",mode)&&(templateContext.input[0].disabled=!0),templateContext}}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=start.min.js.map