define("tiny_ai/controllers/promptedit",["exports","core/str","tiny_ai/utils"],(function(_exports,_str,_utils){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;return _exports.default=
/**
   * Controller for handling the show/hide prompt button and the associated textarea.
   *
   * @module      tiny_ai/controllers/promtedit_controller
   * @copyright   2024, ISB Bayern
   * @author      Philipp Memmel
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class{constructor(baseSelector){this.baseElement=document.querySelector(baseSelector)}async init(){const showPromptButton=this.baseElement.querySelector('[data-action="showprompt"]'),textarea=this.baseElement.querySelector('textarea[data-type="prompt"]'),datamanager=(0,_utils.getDatamanager)((0,_utils.getCurrentModalUniqId)(this.baseElement));if(textarea.innerHTML=datamanager.getCurrentPrompt(),datamanager.getEventEmitterElement().addEventListener("promptUpdated",(event=>{textarea.value=event.detail.newPrompt})),textarea.addEventListener("input",(()=>{datamanager.setCurrentPrompt(textarea.value)})),showPromptButton){const[showPromptString,hidePromptString]=await(0,_str.getStrings)([{key:"showprompt",component:"tiny_ai"},{key:"hideprompt",component:"tiny_ai"}]);showPromptButton.addEventListener("click",(()=>{const currentText=showPromptButton.querySelector("[data-text]").innerText;showPromptButton.querySelector("[data-text]").innerText=currentText===showPromptString?hidePromptString:showPromptString;const buttonIcon=showPromptButton.querySelector("i");buttonIcon.classList.contains("fa-eye")?(buttonIcon.classList.remove("fa-eye"),buttonIcon.classList.add("fa-eye-slash")):(buttonIcon.classList.remove("fa-eye-slash"),buttonIcon.classList.add("fa-eye")),textarea.classList.toggle("d-none")}))}}},_exports.default}));

//# sourceMappingURL=promptedit.min.js.map