define("tiny_ai/datahandler/basedata",["exports","core/str","core/prefetch","tiny_ai/constants"],(function(_exports,_str,_prefetch,_constants){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=_exports.getTinyAiString=_exports.getShowPromptButtonContext=_exports.getReplaceButtonsContext=_exports.getInputContext=_exports.getBackAndGenerateButtonContext=void 0;
/**
   * Tiny AI base data provider.
   *
   * @module      tiny_ai/datahandler/basedata
   * @copyright   2024, ISB Bayern
   * @author      Philipp Memmel
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const stringKeys=["aigenerating","aisuggestion","audiogen_headline","audiogen_placeholder","back","backbutton_tooltip","cancel","deletebutton_tooltip","describeimg_baseprompt","describeimg_headline","describe_baseprompt","describe_headline","dismiss","dismisssuggestion","error_nofile","error_nofileinclipboard_text","error_nofileinclipboard_title","error_nopromptgiven","freeprompt_placeholder","freepromptbutton_tooltip","gender","generalerror","generate","generatebutton_tooltip","hideprompt","imagefromeditor","imagetotext_baseprompt","imagetotext_headline","imagetotext_insertimage","imggen_headline","imggen_placeholder","insertatcaret","insertatcaret_tooltip","insertbelow","insertbelow_tooltip","keeplanguagetype","languagetype","languagetype_prompt","mainselection_heading","maxwordcount","maxwordcount_prompt","nomaxwordcount","regeneratebutton_tooltip","replaceselection","replaceselectionbutton_tooltip","reworkprompt","simplelanguage","size","showprompt","showpromptbutton_tooltip","summarize_baseprompt","summarize_headline","targetlanguage","technicallanguage","texttouse","toolname_audiogen","toolname_describe","toolname_describeimg","toolname_describe_extension","toolname_imggen","toolname_imagetotext","toolname_summarize","toolname_summarize_extension","toolname_translate","toolname_translate_extension","toolname_tts","toolname_tts_extension","translate_baseprompt","translate_headline","tts_headline","voice"];let strings=new Map;_exports.init=async()=>{(0,_prefetch.prefetchStrings)("tiny_ai",stringKeys);const stringRequest=stringKeys.map((key=>({key:key,component:"tiny_ai"}))),fetchedStrings=await(0,_str.getStrings)(stringRequest);for(let i=0;i<stringKeys.length;i++)strings.set(stringKeys[i],fetchedStrings[i])};const getTinyAiString=string=>strings.get(string);_exports.getTinyAiString=getTinyAiString;_exports.getBackAndGenerateButtonContext=()=>({footerButtons:[{hasText:!0,buttonText:getTinyAiString("back"),iconLeft:!0,iconRight:!1,primary:!1,secondary:!1,tertiary:!0,iconname:"arrow-left",iconstyle:"solid",action:"back",tooltip:getTinyAiString("backbutton_tooltip")},{hasText:!0,buttonText:getTinyAiString("generate"),iconLeft:!0,iconRight:!1,primary:!0,secondary:!1,tertiary:!1,iconname:"sparkle",customicon:!0,action:"generate",tooltip:getTinyAiString("generatebutton_tooltip")}]});_exports.getReplaceButtonsContext=mode=>({footerIconButtons:[{action:"delete",iconname:"trash",tooltip:getTinyAiString("deletebutton_tooltip")},{action:"regenerate",iconname:"arrows-rotate",tooltip:getTinyAiString("regeneratebutton_tooltip")}],footerButtons:[{action:"insertbelow",hasText:!0,buttonText:getTinyAiString("insertbelow"),iconLeft:!0,iconRight:!1,secondary:!0,iconname:"text-insert-last",customicon:!0,tooltip:getTinyAiString("insertbelow_tooltip")},{action:mode===_constants.constants.modalModes.selection?"replace":"insertatcaret",hasText:!0,buttonText:mode===_constants.constants.modalModes.selection?getTinyAiString("replaceselection"):getTinyAiString("insertatcaret"),iconLeft:!0,iconRight:!1,primary:!0,iconname:"check",iconstyle:"solid",tooltip:mode===_constants.constants.modalModes.selection?getTinyAiString("replaceselection_tooltip"):getTinyAiString("insertatcaret_tooltip")}]});_exports.getInputContext=()=>({input:[{iconname:"sparkle",customicon:!0,button:[{customicon:!1,iconname:"arrow-right",iconstyle:"solid",iconLeft:!1,iconRight:!0,tooltip:getTinyAiString("freepromptbutton_tooltip")}]}]});_exports.getShowPromptButtonContext=()=>({hasText:!0,buttonText:getTinyAiString("showprompt"),iconLeft:!0,iconRight:!1,tertiary:!0,iconname:"eye",iconstyle:"solid",action:"showprompt",textareatype:"prompt",collapsed:!0,tooltip:getTinyAiString("showpromptbutton_tooltip")})}));

//# sourceMappingURL=basedata.min.js.map