define("tiny_elements/ui",["exports","tiny_elements/modal","tiny_elements/options","core/modal_events","tiny_elements/variantslib","tiny_elements/preferencelib","editor_tiny/options","tiny_elements/data"],(function(_exports,_modal,_options,_modal_events,_variantslib,_preferencelib,_options2,_data){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tiny Elements UI.
   *
   * @module      tiny_elements/ui
   * @copyright   2022 Marc Català <reskit@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAction=void 0,_modal_events=_interopRequireDefault(_modal_events),_data=_interopRequireDefault(_data);let currentFlavor="",currentFlavorId=0,currentCategoryId=1,currentCategoryName="",lastFlavor=[],selection="",data={};_exports.handleAction=async editor=>{selection=editor.selection.getContent(),data=new _data.default((0,_options2.getContextId)(editor),(0,_options.isStudent)(editor),(0,_options.showPreview)(editor),(0,_options.canManage)(editor)),await data.loadData(),(0,_variantslib.setData)(data),currentCategoryId=await(0,_preferencelib.loadPreferences)(_preferencelib.Preferences.category),lastFlavor=await(0,_preferencelib.loadPreferences)(_preferencelib.Preferences.category_flavors),null==lastFlavor&&(lastFlavor=[]);let componentVariants=await(0,_preferencelib.loadPreferences)(_preferencelib.Preferences.component_variants);null==componentVariants&&(componentVariants={}),(0,_variantslib.loadVariantPreferences)(componentVariants),await displayDialogue(editor)};const displayDialogue=async editor=>{const templateContext=data.getTemplateContext(editor),modal=await _modal.ElementsModal.create({type:_modal.ElementsModal.TYPE,templateContext:templateContext,large:!0}),modalClass=data.getPreviewElements()?"elements-modal":"elements-modal-no-preview";editor.targetElm.closest("body").classList.add(modalClass),modal.show(),modal.getRoot().on(_modal_events.default.hidden,(()=>{handleModalHidden(editor)}));const soleCategories=modal.getRoot()[0].querySelectorAll(".elements-category.no-flavors");soleCategories.forEach((node=>{node.addEventListener("click",(event=>{handleCategoryClick(event,modal)}))}));const selectCategories=modal.getRoot()[0].querySelectorAll(".elements-category-flavor");selectCategories.forEach((node=>{node.addEventListener("click",(event=>{handleCategoryFlavorClick(event,modal)}))}));modal.getRoot()[0].querySelectorAll(".nav-link.dropdown-toggle").forEach((node=>{node.addEventListener("click",(event=>{handleCategoryRemember(event,modal)}))}));modal.getRoot()[0].querySelectorAll(".elementst-dialog-button").forEach((node=>{node.addEventListener("click",(event=>{handleButtonClick(event,editor,modal)})),data.getPreviewElements()&&(node.addEventListener("mouseenter",(event=>{handleButtonMouseEvent(event,modal,!0)})),node.addEventListener("mouseleave",(event=>{handleButtonMouseEvent(event,modal,!1)})))}));if(modal.getRoot()[0].querySelectorAll(".elements-button-variant").forEach((node=>{node.addEventListener("click",(event=>{handleVariantClick(event,modal)}))})),soleCategories.length>0||selectCategories.length>0){const savedCategory=currentCategoryId,savedFlavor=lastFlavor[currentCategoryId];if(0==soleCategories.length||soleCategories[0].displayorder>selectCategories[0].displayorder?selectCategories[0].click():soleCategories[0].click(),0!=savedCategory&&(soleCategories.forEach((node=>{node.dataset.categoryid==savedCategory&&node.click()})),selectCategories.forEach((node=>{node.dataset.categoryid==savedCategory&&node.click()})),savedFlavor)){const flavorlink=modal.getRoot()[0].querySelector('.elements-category-flavor[data-id="'+savedFlavor+'"]');flavorlink&&flavorlink.click()}}},handleCategoryClick=(event,modal)=>{const link=event.target;currentCategoryId=link.dataset.categoryid,currentCategoryName=link.dataset.categoryname;modal.getRoot()[0].querySelectorAll(".nav-link, .dropdown-item").forEach((node=>node.classList.remove("active"))),link.classList.add("active"),showCategoryButtons(modal,currentCategoryName)},handleCategoryFlavorClick=(event,modal)=>{const link=event.target;currentFlavor=link.dataset.flavor,currentFlavorId=link.dataset.id,currentCategoryId=link.dataset.categoryid,currentCategoryName=link.dataset.categoryname,lastFlavor[currentCategoryId]=currentFlavorId;modal.getRoot()[0].querySelectorAll(".nav-link, .dropdown-item").forEach((node=>node.classList.remove("active"))),link.classList.add("active");modal.getRoot()[0].querySelector('.nav-link[data-categoryid="'+currentCategoryId+'"]').classList.add("active");modal.getRoot()[0].querySelectorAll(".elements-buttons-preview button").forEach((componentButton=>{if(null!=componentButton.dataset.flavor&&componentButton.classList.remove(componentButton.dataset.flavor),componentButton.classList.add(currentFlavor),componentButton.dataset.flavor=currentFlavor,""!=componentButton.dataset.flavorlist&&!componentButton.dataset.flavorlist.split(",").includes(currentFlavor)||componentButton.dataset.category!=currentCategoryName)componentButton.classList.add("elements-hidden");else if(componentButton.classList.remove("elements-hidden"),""!=componentButton.dataset.flavorlist){let variants=(0,_variantslib.getVariantsClass)(data.getComponentById(componentButton.dataset.id).name,currentFlavor);componentButton.querySelectorAll(".elements-button-variant").forEach((variant=>{updateVariantButtonState(variant,-1!=variants.indexOf(variant.dataset.variantclass))}))}}))},handleCategoryRemember=(event,modal)=>{const link=event.target;if(currentCategoryId=link.dataset.categoryid,currentCategoryName=link.dataset.categoryname,currentFlavorId=lastFlavor[currentCategoryId],null!=currentFlavorId){let e={target:modal.getRoot()[0].querySelector('.elements-category-flavor[data-id="'+currentFlavorId+'"]')};handleCategoryFlavorClick(e,modal)}},handleModalHidden=editor=>{editor.targetElm.closest("body").classList.remove("elements-modal-no-preview"),0!=currentCategoryId&&0!=currentFlavorId&&(0,_preferencelib.savePreferences)([{type:_preferencelib.Preferences.category,value:currentCategoryId},{type:_preferencelib.Preferences.category_flavors,value:JSON.stringify(lastFlavor)},{type:_preferencelib.Preferences.component_variants,value:JSON.stringify((0,_variantslib.getVariantPreferences)())}])},updateComponentCode=function(componentCode,selectedButton,placeholder){let flavor=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"";componentCode=componentCode.replace("{{PLACEHOLDER}}",placeholder);const comp=data.getComponentById(selectedButton),variants=(0,_variantslib.getVariantsClass)(comp.name,flavor);return componentCode=variants.length>0?(componentCode=componentCode.replace("{{VARIANTS}}",variants.join(" "))).replace("{{VARIANTSHTML}}",(0,_variantslib.getVariantsHtml)(comp.name,flavor)):(componentCode=componentCode.replace("{{VARIANTS}}","")).replace("{{VARIANTSHTML}}",""),componentCode=(componentCode=(componentCode=currentFlavor?componentCode.replace("{{FLAVOR}}","elements-"+currentFlavor+"-flavor"):componentCode.replace("{{FLAVOR}}","")).replace("{{COMPONENT}}","elements-"+comp.name)).replace("{{CATEGORY}}","elements-"+data.getCategoryById(currentCategoryId).name),componentCode=applyRandomID(componentCode),componentCode=applyLangStrings(componentCode)},handleButtonClick=async(event,editor,modal)=>{const selectedButton=event.target.closest("button").dataset.id,comp=data.getComponentById(selectedButton);if(comp){let componentCode=comp.code;const placeholder=selection.length>0?selection:comp.text;let flavor=comp.flavors.length>0?currentFlavor:"";const randomId=generateRandomID(),newNode=document.createElement("span");newNode.dataset.id=randomId,newNode.innerHTML=placeholder,componentCode=updateComponentCode(componentCode,selectedButton,newNode.outerHTML,flavor),editor.selection.setContent(componentCode);const nodeSel=editor.dom.select('span[data-id="'+randomId+'"]');null!=nodeSel&&nodeSel[0]&&editor.selection.select(nodeSel[0]),modal.destroy(),editor.focus()}},handleButtonMouseEvent=(event,modal,show)=>{const selectedButton=event.target.closest("button").dataset.id,node=modal.getRoot()[0].querySelector('div[data-id="code-preview-'+selectedButton+'"]'),previewDefault=modal.getRoot()[0].querySelector('div[data-id="code-preview-default"]'),comp=data.getComponentById(selectedButton);let flavor=comp.flavors.length>0?currentFlavor:"";const placeholder=selection.length>0?selection:comp.text;node.innerHTML=updateComponentCode(comp.code,selectedButton,placeholder,flavor),node&&(show?(previewDefault.classList.toggle("elements-hidden"),node.classList.toggle("elements-hidden")):(node.classList.toggle("elements-hidden"),previewDefault.classList.toggle("elements-hidden")))},handleVariantClick=(event,modal)=>{event.stopPropagation();const variant=event.target.closest("span"),button=event.target.closest("button"),comp=data.getComponentById(button.dataset.id),flavor=comp.flavors.length>0?currentFlavor:"";updateVariantComponentState(variant,button,modal,!1,!0);modal.getRoot()[0].querySelector('div[data-id="code-preview-'+button.dataset.id+'"]').innerHTML=updateComponentCode(comp.code,button.dataset.id,comp.text,flavor)},updateVariantComponentState=(variant,button,modal,show,updateHtml)=>{const selectedVariant=variant.dataset.variantclass,selectedButton=button.dataset.id,componentClass=button.dataset.classcomponent,previewComponent=modal.getRoot()[0].querySelector('div[data-id="code-preview-'+button.dataset.id+'"] .'+componentClass),variantPreview=modal.getRoot()[0].querySelector('span[data-id="variantHTML-'+button.dataset.id+'"]'),comp=data.getComponentById(selectedButton);let variantsHtml="",hasflavors=comp.flavors.length>0;previewComponent?updateHtml?("on"==variant.dataset.state?((0,_variantslib.removeVariant)(comp.name,variant.dataset.variant,hasflavors?currentFlavor:""),updateVariantButtonState(variant,!1),previewComponent.classList.remove(selectedVariant)):((0,_variantslib.addVariant)(comp.name,variant.dataset.variant,hasflavors?currentFlavor:""),updateVariantButtonState(variant,!0),previewComponent.classList.add(selectedVariant)),variantPreview&&(variantPreview.innerHTML=(0,_variantslib.getVariantsHtml)(comp.name,currentFlavor))):(variantsHtml=(0,_variantslib.getVariantsHtml)(comp.name,currentFlavor),show?(previewComponent.classList.add(selectedVariant),variantsHtml+=(0,_variantslib.getVariantHtml)(variant.dataset.variant)):previewComponent.classList.remove(selectedVariant),variantPreview&&(variantPreview.innerHTML=variantsHtml)):"on"==variant.dataset.state?((0,_variantslib.removeVariant)(comp.name,variant.dataset.variant,hasflavors?currentFlavor:""),updateVariantButtonState(variant,!1)):((0,_variantslib.addVariant)(comp.name,variant.dataset.variant,hasflavors?currentFlavor:""),updateVariantButtonState(variant,!0))},updateVariantButtonState=(variant,activate)=>{activate?(variant.dataset.state="on",variant.classList.remove(variant.dataset.variant+"-variant-off"),variant.classList.add(variant.dataset.variant+"-variant-on"),variant.classList.add("on")):(variant.dataset.state="off",variant.classList.remove(variant.dataset.variant+"-variant-on"),variant.classList.add(variant.dataset.variant+"-variant-off"),variant.classList.remove("on"))},showCategoryButtons=(modal,context)=>{const showNodes=modal.getRoot()[0].querySelectorAll('button[data-type="'+context+'"]'),hideNodes=modal.getRoot()[0].querySelectorAll('button[data-type]:not([data-type="'+context+'"])');showNodes.forEach((node=>node.classList.remove("elements-hidden"))),hideNodes.forEach((node=>node.classList.add("elements-hidden")))},applyLangStrings=text=>([...text.matchAll(/{{#([^}]*)}}/g)].forEach((strLang=>{text=text.replace("{{#"+strLang[1]+"}}",data.getLangString(strLang[1]))})),text),generateRandomID=()=>{const timestamp=(new Date).getTime();return"R"+Math.round(1e5*Math.random())+"-"+timestamp},applyRandomID=text=>{const compRegex=/{{@ID}}/g;return text.match(compRegex)&&(text=text.replace(compRegex,generateRandomID())),text}}));

//# sourceMappingURL=ui.min.js.map