<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin Elements strings for language en.
 *
 * @package     tiny_elements
 * @category    string
 * @copyright   2022 Marc Català <reskit@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['additem'] = 'Add item';
$string['bulk_edit_displaynames'] = 'Bulk edit displaynames';
$string['bulk_edit_flavor_displaynames'] = 'Bulk edit flavor displaynames';
$string['bulk_edit_variant_displaynames'] = 'Bulk edit variant displaynames';
$string['button_elements'] = 'Elements';
$string['c4lcompatibility'] = 'If checked, the variant class name will be c4l-...-variant instead of elements-...-variant for compatibility with the original c4l components.';
$string['c4lcompatibility_help'] = 'c4l (components for learning) is the plugin elements is based on.';
$string['cachedef_tiny_elements_css'] = 'Cache for tiny_elements CSS';
$string['category'] = 'Category';
$string['close'] = 'Close';
$string['code'] = 'HTML';
$string['code_help'] = 'HTML code to insert. You can use {{VARIANTS}}, {{FLAVOR}} and {{PLACEHOLDER}} as placeholders for variants, flavors and text to be inserted.';
$string['compcat'] = 'Categories';
$string['compflavor_icons'] = 'Change button icons for components depending on flavors';
$string['component'] = 'Component';
$string['component_flavor'] = 'Component/flavor';
$string['componentname'] = 'Component name';
$string['componentname_help'] = 'Name of the component use for internal use (also as a class name in CSS)';
$string['components'] = 'Components';
$string['content'] = 'Content';
$string['copyasstring'] = 'Save all elements to clipboard';
$string['copyfail'] = 'Error copying elements';
$string['copyof'] = 'Copy of {$a}';
$string['copysuccess'] = 'Elements copied to clipboard';
$string['css'] = 'CSS';
$string['delete'] = 'Delete item "{$a}"';
$string['deletewarning'] = 'Are you sure you want to delete this item.';
$string['displayname'] = 'Display name';
$string['displayname_help'] = 'Name of the component visible to the users';
$string['displayorder'] = 'Display order';
$string['dryrun'] = 'Simulate import';
$string['dryrun_help'] = 'If checked, this will simulate an import run without changing anything. This can be used to see if there are any changes affecting existing items.';
$string['edititem'] = 'Edit item';
$string['editlicenses'] = 'Edit symbol licenses';
$string['editlicensesformfileautor_help'] = '<strong>Who</strong> created the work? <br> Here is the author, artist or if no person
            is named, the issuing institution is stated. <br> <br> The following scheme is usual: <br> Last name, first name.
            Editors are identified by “Hrsg.” highlighted at the end. In the case of multiple authors, these are separated from
            each other by slashes. <br> Are on one website If no authors are mentioned, the name of the website or the publishing
            institution takes the place of the author.';
$string['editlicensesformfilelicense_help'] = 'Please indicate which license the material used is under.';
$string['editlicensesformfileurl'] = 'Source or URL';
$string['editlicensesformfileurl_help'] = '<strong>Where</strong> was the work published? <br> <br> For books, the publisher is
            responsible and the place of publication, for magazine articles the name of the magazine plus the year, volume, issue
            and page details To provide websites with the full URL.';
$string['elements:manage'] = 'Manage components';
$string['elements:showteachercomponents'] = 'Show components that are for teacher use only';
$string['elements:viewplugin'] = 'View Elements plugin';
$string['enablepreview'] = 'Enable preview';
$string['enablepreview_desc'] = 'If enabled, a preview is showed when you hover the mouse cursor over each component.';
$string['error_export'] = 'Error creating export file';
$string['error_fileimport'] = 'Error importing file "{$a}"';
$string['error_import_component'] = 'Error importing component "{$a}"';
$string['error_import_missing_table'] = 'Error while importing xml: missing table "{$a}"';
$string['error_import_missing_xml'] = 'Import error: Missing XML file';
$string['errorbackupfile'] = 'Error in backup file';
$string['errorcompcat'] = '**compcat** cant be empty';
$string['errordisplayname'] = 'Displayname cant be empty';
$string['errorname'] = 'Name cant be empty';
$string['export'] = 'Export';
$string['files'] = 'Files';
$string['flavor'] = 'Flavor';
$string['flavors'] = 'Flavors';
$string['generalsettings'] = 'General settings';
$string['hideforstudents'] = 'Hide for students';
$string['iconurl'] = 'Icon URL';
$string['import'] = 'Import';
$string['import_simulation'] = 'Import simulation';
$string['js'] = 'JS';
$string['linktomanagerdesc'] = 'Go to <a href="{$a}">management page</a> to edit categories, components, flavors and variants.';
$string['linktomanagername'] = 'Link to management';
$string['linktopreviewall'] = 'Link to preview';
$string['linktopreviewall_desc'] = 'Go to <a href="{$a}">preview</a> to view examples of all elements and export them as string.';

$string['manage'] = 'Manage';
$string['management'] = 'Management';
$string['menuitem_elements'] = 'Course elements';
$string['name'] = 'Name';
$string['newcategory'] = 'New category "{$a}"';
$string['newcompflavor'] = 'Create relation component<->flavor "{$a}"';
$string['newcomponent'] = 'New component "{$a}"';
$string['newcompvariant'] = 'Create relation component<->variant "{$a}"';
$string['newfile'] = 'New file "{$a}"';
$string['newflavor'] = 'New flavor "{$a}"';
$string['newmetadata'] = 'New license "{$a}"';
$string['newmetadatafilemissing'] = 'Related file not found: "{$a}"';
$string['newvariant'] = 'New variant "{$a}"';
$string['pluginname'] = 'Course elements';
$string['preview'] = 'Preview';
$string['previewall'] = 'Preview all elements';
$string['previewcss'] = 'Preview CSS';
$string['previewcsstext'] = 'If everything is correct, the component should be shown in all flavors';
$string['previewdefault'] = 'Place the pointer on any component to see its preview.';
$string['privacy:preference:category'] = 'Preferred category';
$string['privacy:preference:components_flavors'] = 'Preferred flavor for each component';
$string['privacy:preference:components_variants'] = 'Preferred variants of each component';
$string['replacecategory'] = 'Replace category "{$a}"';
$string['replacecompflavor'] = 'Replace relation component<->flavor "{$a}"';
$string['replacecomponent'] = 'Replace component "{$a}"';
$string['replacecompvariant'] = 'Replace relation component<->variant "{$a}"';
$string['replacefile'] = 'Replace file "{$a}"';
$string['replaceflavor'] = 'Replace flavor "{$a}"';
$string['replacevariant'] = 'Replace variant "{$a}"';
$string['showprinturls'] = 'Pick an icon';
$string['text'] = 'Text';
$string['unchangedfile'] = 'File "{$a}" is unchanged';
$string['validclassname'] = 'The name has to be a valid css class name. It may only contain letters, numbers and the characters "-" and "_". It must start with a letter or "_". Using only lowercase letters is recommended.';
$string['variant'] = 'Variant';
$string['variants'] = 'Variants';
$string['wipe'] = 'Wipe everything';
$string['wipewarning'] = 'This will remove all categories, files, components, flavors and variants. There is no way to undo this step. Make sure, you have a backup!';
