define("tiny_elements/data",["exports","core/str","tiny_elements/common","./variantslib","./helper","core/ajax","core/log"],(function(_exports,_str,_common,_variantslib,_helper,_ajax,_log){var obj;function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_log=(obj=_log)&&obj.__esModule?obj:{default:obj};return _exports.default=class{constructor(contextid,userStudent,previewElements,canManage){_defineProperty(this,"categories",[]),_defineProperty(this,"components",[]),_defineProperty(this,"flavors",[]),_defineProperty(this,"variants",[]),_defineProperty(this,"langStrings",{}),_defineProperty(this,"userStudent",!1),_defineProperty(this,"canManage",!1),_defineProperty(this,"contextid",1),this.contextid=contextid,this.userStudent=userStudent,this.previewElements=previewElements,this.canManage=canManage,(0,_variantslib.setData)(this)}async loadData(){await this.loadElementsData(),this.langStrings=await this.getAllStrings()}getComponents(){return this.components}getFlavors(){return this.flavors}getVariants(){return this.variants}getComponentById(id){return(0,_helper.findById)(this.components,id)}getCategoryFlavors(categoryname){const categoryFlavors=[];return this.flavors.forEach((flavor=>{flavor.categoryname==categoryname&&categoryFlavors.push({id:flavor.id,name:flavor.name,displayname:flavor.displayname,displayorder:flavor.displayorder})})),categoryFlavors}getCategories(){const cats=[];return this.categories.forEach((category=>{let categoryFlavors=this.getCategoryFlavors(category.name);categoryFlavors.sort(((a,b)=>a.displayorder-b.displayorder));let hasFlavors=Array.isArray(categoryFlavors)&&categoryFlavors.length;cats.push({categoryid:category.id,name:category.displayname,categoryname:category.name,type:category.id,displayorder:category.displayorder,flavors:categoryFlavors,hasFlavors:hasFlavors,active:""})})),cats.sort(((a,b)=>a.displayorder-b.displayorder)),cats.length>0&&(cats[0].active="active",cats[0].flavors.length>0&&(cats[0].flavors[0].factive="active")),cats}getComponentVariants(component){const componentVariants=[];return component.variants.forEach((variant=>{let variantitem=(0,_helper.findByName)(this.variants,variant);if(void 0!==variantitem){let state=(0,_variantslib.variantExists)(component.name,variantitem.name)?"on":"off";componentVariants.push({id:variantitem.id,name:variantitem.name,displayname:variantitem.displayname,state:state,imageClass:variantitem.name+"-variant-"+state,variantclass:(variantitem.c4lcompatibility?"c4l":"elements")+"-"+variantitem.name+"-variant",title:this.langStrings.get(variantitem.name),content:variantitem.content})}})),componentVariants.sort(((a,b)=>a.name.localeCompare(b.name))),componentVariants}getCategoryById(id){return(0,_helper.findById)(this.categories,id)}getLangString(id){return this.langStrings.get(id)}getButtons(editor){const buttons=[];editor.selection.getContent();return Object.values(this.components).forEach((component=>{buttons.push({id:component.id,name:component.displayname,type:component.categoryname,imageClass:"elements-"+component.name+"-icon",htmlcode:component.code,variants:this.getComponentVariants(component),flavorlist:component.flavors.join(","),category:component.categoryname,displayorder:component.displayorder})})),buttons.sort(((a,b)=>a.displayorder-b.displayorder)),buttons}getTemplateContext(editor){return Object.assign({},{elementid:editor.id,buttons:this.getButtons(editor),categories:this.getCategories(),preview:this.previewElements,canmanage:this.canManage})}getPreviewElements(){return this.previewElements}async getAllStrings(){const keys=[],compRegex=/{{#([^}]*)}}/g;this.components.forEach((element=>{[...element.code.matchAll(compRegex)].forEach((strLang=>{-1===keys.indexOf(strLang[1])&&keys.push(strLang[1])})),[...element.text.matchAll(compRegex)].forEach((strLang=>{-1===keys.indexOf(strLang[1])&&keys.push(strLang[1])}))}));const stringValues=await(0,_str.get_strings)(keys.map((key=>({key:key,pluginname:_common.component}))));return new Map(keys.map(((key,index)=>[key,stringValues[index]])))}async loadElementsData(){const data=await(0,_ajax.call)([{methodname:"tiny_elements_get_elements_data",args:{isstudent:this.userStudent,contextid:this.contextid}}])[0].catch((err=>{_log.default.error(err.message)})),indexedComponents=[];data.components.forEach((component=>{indexedComponents[component.id]=component}));const indexedVariants=[];data.variants.forEach((variant=>{indexedVariants[variant.id]=variant}));const indexedCategories=[];data.categories.forEach((category=>{indexedCategories[category.id]=category})),this.components=indexedComponents,this.variants=indexedVariants,this.categories=indexedCategories,this.flavors=data.flavors}},_exports.default}));

//# sourceMappingURL=data.min.js.map