define("tiny_elements/management",["exports","tiny_elements/previewmodal","core_form/modalform","core/notification","core/str","core/ajax","core/templates","core/log"],(function(_exports,_previewmodal,_modalform,_notification,_str,_ajax,_templates,_log){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Management functions for tiny_elements admin backend.
   *
   * @module     tiny_elements/management
   * @copyright  2024 ISB Bayern
   * @author     Tobias Garske
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.wipe=_exports.init=_exports.duplicateItem=_exports.deleteItem=void 0,_modalform=_interopRequireDefault(_modalform),_notification=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(_notification),_log=_interopRequireDefault(_log);_exports.init=async params=>{document.getElementById("elements_import").addEventListener("click",(async e=>{importModal(e)})),document.getElementsByClassName("add").forEach((element=>{element.addEventListener("click",(async e=>{showModal(e,element.dataset.id,element.dataset.table)}))})),document.getElementsByClassName("edit").forEach((element=>{element.addEventListener("click",(async e=>{showModal(e,element.dataset.id,element.dataset.table)}))})),document.getElementsByClassName("delete").forEach((element=>{element.addEventListener("click",(async e=>{deleteModal(e,element.dataset.id,element.dataset.title,element.dataset.table)}))})),document.getElementsByClassName("preview-button").forEach((element=>{element.addEventListener("click",(async e=>{previewModal(e)}))})),document.getElementsByClassName("compcat").forEach((element=>{element.addEventListener("click",(async e=>{showItems(e,element.dataset.compcat)}))})),document.getElementsByClassName("editlicenses").forEach((element=>{element.addEventListener("click",(async e=>{editlicensesModal(e,element.dataset.id)}))})),document.querySelectorAll(".buttonicons").forEach((element=>{element.addEventListener("click",(async e=>{compflavorModal(e)}))})),document.getElementById("elements_displaynames_button").addEventListener("click",(async e=>{displaynamesModal(e)})),document.getElementById("elements_displaynames_flavor_button").addEventListener("click",(async e=>{displaynamesFlavorModal(e)})),document.getElementById("elements_displaynames_variant_button").addEventListener("click",(async e=>{displaynamesVariantModal(e)})),document.getElementsByClassName("duplicate").forEach((element=>{element.addEventListener("click",(async()=>{duplicateItem(element.dataset.id,element.dataset.table).always((()=>reload()))}))}));let wipebutton=document.getElementById("elements_wipe");if(wipebutton&&wipebutton.addEventListener("click",(async e=>{wipeModal(e)})),document.querySelectorAll(".flavor .card-body > .clickingextended, .component .card-body > .clickingextended, .variant .card-body > .clickingextended").forEach((element=>{element.addEventListener("click",(async e=>{e.target.closest(".item").querySelector("a.edit").click()}))})),params.compcatactive){let compcat=document.querySelector('.compcat[data-compcat="'+params.compcatactive+'"]');compcat&&(showItems(!1,params.compcatactive),compcat.classList.add("active"))}};const showModal=async(event,id,table)=>{let title;event.preventDefault(),title=0==id?(0,_str.get_string)("additem","tiny_elements"):(0,_str.get_string)("edititem","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_"+table+"_form",args:{id:id,compcat:getActiveCompcatId(),categoryname:getActiveCompcatName()},modalConfig:{title:title},returnFocus:event.target});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>reload())),await modalForm.show()},previewModal=async event=>{event.preventDefault();let preview=event.target.closest(".preview-button");const modal=await _previewmodal.PreviewModal.create({templateContext:{component:preview.dataset.component,flavors:preview.dataset.flavors.trim().split(" "),config:M.cfg}});await modal.show()},importModal=async event=>{event.preventDefault();let title=(0,_str.get_string)("import","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_import_form",args:{},modalConfig:{title:title}});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,importModalSubmitted),await modalForm.show()},importModalSubmitted=async event=>{event.detail.update?location.reload():(event.stopPropagation(),(0,_templates.render)("tiny_elements/management_import_form_result",event.detail).then((async html=>(await _notification.default.alert((0,_str.get_string)("import_simulation","tiny_elements"),html,(0,_str.get_string)("close","tiny_elements")),!0))).catch((error=>{(0,_notification.exception)(error)})))},compflavorModal=async event=>{var _target$dataset$compo,_target$dataset$flavo;event.preventDefault();let title=(0,_str.get_string)("manage","tiny_elements");const target=event.target.closest(".buttonicons"),component=null!==(_target$dataset$compo=target.dataset.component)&&void 0!==_target$dataset$compo?_target$dataset$compo:"",flavor=null!==(_target$dataset$flavo=target.dataset.flavor)&&void 0!==_target$dataset$flavo?_target$dataset$flavo:"",modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_comp_flavor_form",args:{component:component,flavor:flavor},modalConfig:{title:title}});await modalForm.show()},editlicensesModal=async(event,id)=>{event.preventDefault();let title=(0,_str.get_string)("editlicenses","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_editlicense_form",args:{id:id},modalConfig:{title:title}});await modalForm.show()},displaynamesModal=async event=>{event.preventDefault();let title=(0,_str.get_string)("manage","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_displaynames_form",args:{},modalConfig:{title:title}});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>location.reload())),await modalForm.show()},displaynamesFlavorModal=async event=>{event.preventDefault();let title=(0,_str.get_string)("manage","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_displaynames_flavors_form",args:{},modalConfig:{title:title}});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>location.reload())),await modalForm.show()},displaynamesVariantModal=async event=>{event.preventDefault();let title=(0,_str.get_string)("manage","tiny_elements");const modalForm=new _modalform.default({formClass:"tiny_elements\\form\\management_displaynames_variants_form",args:{},modalConfig:{title:title}});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>location.reload())),await modalForm.show()},deleteModal=(event,id,title,table)=>{event.preventDefault(),(0,_notification.deleteCancelPromise)((0,_str.get_string)("delete","tiny_elements",title),(0,_str.get_string)("deletewarning","tiny_elements")).then((async()=>{if(0!==id)try{if(await deleteItem(id,table)){const link=document.querySelector('[data-table="'+table+'"][data-id="'+id+'"]');if(link){link.closest(".item").remove()}}}catch(error){(0,_notification.exception)(error)}})).catch((err=>{err.message&&_log.default.error(err.message)}))},wipeModal=event=>{event.preventDefault(),(0,_notification.deleteCancelPromise)((0,_str.get_string)("wipe","tiny_elements"),(0,_str.get_string)("wipewarning","tiny_elements")).then((async()=>{try{return await wipe(),void reload()}catch(error){return void(0,_notification.exception)(error)}})).catch((err=>{err.message&&_log.default.error(err.message)}))},deleteItem=(id,table)=>(0,_ajax.call)([{methodname:"tiny_elements_delete_item",args:{id:id,table:table}}])[0];_exports.deleteItem=deleteItem;const wipe=()=>(0,_ajax.call)([{methodname:"tiny_elements_wipe",args:{contextid:1}}])[0];_exports.wipe=wipe;const showItems=(event,compcat)=>{document.querySelectorAll(".flavor, .component, .variant").forEach((element=>{element.classList.add("hidden")}));let itemsShow=document.querySelectorAll('[data-categoryname="'+compcat+'"]'),usedFlavors=[];itemsShow.forEach((element=>{if(element.classList.remove("hidden"),void 0!==element.dataset.flavors){let flavors=element.dataset.flavors.split(" ");for(let value of flavors)usedFlavors.includes(value)||0==value.length||usedFlavors.push(value)}}));let flavorstring=usedFlavors.map((item=>".".concat(item))).join(", ");if(flavorstring.length){document.querySelectorAll(flavorstring).forEach((element=>{element.classList.remove("hidden")}))}if(document.getElementsByClassName("addcontainer").forEach((element=>{element.classList.remove("hidden")})),event){document.getElementsByClassName("compcat").forEach((element=>{element.classList.remove("active")})),event.target.closest(".compcat").classList.add("active")}if("found-items"==compcat){let found=document.querySelector('.compcat[data-compcat="found-items"]');if(found.dataset.loneflavors.length){document.querySelectorAll(found.dataset.loneflavors).forEach((element=>{element.classList.remove("hidden")}))}if(found.dataset.lonevariants.length){document.querySelectorAll(found.dataset.lonevariants).forEach((element=>{element.classList.remove("hidden")}))}if(found.dataset.lonecomponents.length){document.querySelectorAll(found.dataset.lonecomponents).forEach((element=>{element.classList.remove("hidden")}))}}},reload=()=>{const currentUrl=new URL(window.location.href);currentUrl.searchParams.set("compcat",getActiveCompcatName()),window.location.href=currentUrl.toString(),window.location.reload()},getActiveCompcatName=()=>{var _compcat$dataset$comp;const compcat=document.querySelector(".compcat.active");return compcat&&null!==(_compcat$dataset$comp=compcat.dataset.compcat)&&void 0!==_compcat$dataset$comp?_compcat$dataset$comp:""},getActiveCompcatId=()=>{var _compcat$dataset$id;const compcat=document.querySelector(".compcat.active");return compcat&&null!==(_compcat$dataset$id=compcat.dataset.id)&&void 0!==_compcat$dataset$id?_compcat$dataset$id:0},duplicateItem=(id,table)=>(0,_ajax.call)([{methodname:"tiny_elements_duplicate_item",args:{id:id,table:table}}])[0];_exports.duplicateItem=duplicateItem}));

//# sourceMappingURL=management.min.js.map