<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace auth_outage\task;

use auth_outage\local\outagelib;
use core\task\scheduled_task;

/**
 * update_static_page class.
 *
 * @package   auth_outage
 * @author    Daniel Thee Roperto <daniel.roperto@catalyst-au.net>
 * @copyright 2016 Catalyst IT
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class update_static_page extends scheduled_task {
    /**
     * Gets the name of this event.
     * @return string Name of this event.
     */
    public function get_name() {
        return get_string('taskupdatestaticpage', 'auth_outage');
    }

    /**
     * Executes the event.
     */
    public function execute() {
        outagelib::prepare_next_outage();
    }
}
