<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Toggle debugging switch
 *
 * @package   local_envbar
 * @author    Trisha Milan (trishamilan@catalyst-au.net)
 * @copyright Catalyst IT
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_envbar\local\envbarlib;
require_once(dirname(__FILE__) . '/../../config.php');
require_once($CFG->libdir . '/moodlelib.php');

require_login();

if (!is_siteadmin()) {
    throw new \moodle_exception('accessdenied');
}

require_sesskey();

envbarlib::set_debug_config($CFG->debug);
// Go back to current page.
$redirecturl = base64_decode(required_param('redirect', PARAM_RAW));
$redirecturl = clean_param($redirecturl, PARAM_URL);
if (strpos($redirecturl, '/') !== 0) {
    throw new \moodle_exception('accessdenied');
}
redirect($redirecturl);

