<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Structure step to restore one facetoface activity
 *
 * Copyright (C) 2007-2011 Catalyst IT (http://www.catalyst.net.nz)
 * Copyright (C) 2011-2013 Totara LMS (http://www.totaralms.com)
 * Copyright (C) 2014 onwards Catalyst IT (http://www.catalyst-eu.net)
 *
 * @package    mod_facetoface
 * @copyright  2014 onwards Catalyst IT <http://www.catalyst-eu.net>
 * @author     Stacey Walker <stacey@catalyst-eu.net>
 * @author     Alastair Munro <alastair.munro@totaralms.com>
 * @author     Aaron Barnes <aaron.barnes@totaralms.com>
 * @author     Francois Marier <francois@catalyst.net.nz>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class restore_facetoface_activity_structure_step extends restore_activity_structure_step {
    /**
     * Defines structure.
     */
    protected function define_structure() {
        $paths = [];
        $userinfo = $this->get_setting_value('userinfo');

        $paths[] = new restore_path_element('facetoface', '/activity/facetoface');
        $paths[] = new restore_path_element('facetoface_session', '/activity/facetoface/sessions/session');
        $paths[] = new restore_path_element(
            'facetoface_sessions_dates',
            '/activity/facetoface/sessions/session/sessions_dates/sessions_date'
        );
        $paths[] = new restore_path_element(
            'facetoface_session_data',
            '/activity/facetoface/sessions/session/session_data/session_data_element'
        );
        $paths[] = new restore_path_element(
            'facetoface_session_field',
            '/activity/facetoface/sessions/session/session_field/session_field_element'
        );
        if ($userinfo) {
            $paths[] = new restore_path_element(
                'facetoface_signup',
                '/activity/facetoface/sessions/session/signups/signup'
            );
            $paths[] = new restore_path_element(
                'facetoface_signups_status',
                '/activity/facetoface/sessions/session/signups/signup/signups_status/signup_status'
            );
            $paths[] = new restore_path_element(
                'facetoface_session_roles',
                '/activity/facetoface/sessions/session/session_roles/session_role'
            );
        }

        // Return the paths wrapped into standard activity structure.
        return $this->prepare_activity_structure($paths);
    }

    /**
     * Process facetoface
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;
        $data->course = $this->get_courseid();

        // Insert the facetoface record.
        $newitemid = $DB->insert_record('facetoface', $data);
        $this->apply_activity_instance($newitemid);
    }

    /**
     * Process facetoface session
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_session($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->facetoface = $this->get_new_parentid('facetoface');

        $data->timecreated = $this->apply_date_offset($data->timecreated);
        $data->timemodified = $this->apply_date_offset($data->timemodified);

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_sessions', $data);
        $this->set_mapping('facetoface_session', $oldid, $newitemid, true); // Childs and files by itemname.
    }

    /**
     * Process facetoface signup
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_signup($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->sessionid = $this->get_new_parentid('facetoface_session');
        $data->userid = $this->get_mappingid('user', $data->userid);

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_signups', $data);
        $this->set_mapping('facetoface_signup', $oldid, $newitemid, true); // Childs and files by itemname.
    }

    /**
     * Process facetoface signup status
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_signups_status($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->signupid = $this->get_new_parentid('facetoface_signup');

        $data->timecreated = $this->apply_date_offset($data->timecreated);

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_signups_status', $data);
    }

    /**
     * Process facetoface roles
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_session_roles($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->sessionid = $this->get_new_parentid('facetoface_session');
        $data->userid = $this->get_mappingid('user', $data->userid);
        $data->roleid = $this->get_mappingid('role', $data->roleid);

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_session_roles', $data);
    }

    /**
     * Process session data
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_session_data($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->sessionid = $this->get_new_parentid('facetoface_session');
        $data->fieldid = $this->get_mappingid('facetoface_session_field');

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_session_data', $data);
        $this->set_mapping('facetoface_session_data', $oldid, $newitemid, true); // Childs and files by itemname.
    }

    /**
     * Process session field
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_session_field($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_session_field', $data);
    }

    /**
     * Process session dates
     *
     * @param array $data
     * @return void
     */
    protected function process_facetoface_sessions_dates($data) {
        global $DB;

        $data = (object) $data;
        $oldid = $data->id;

        $data->sessionid = $this->get_new_parentid('facetoface_session');

        $data->timestart = $this->apply_date_offset($data->timestart);
        $data->timefinish = $this->apply_date_offset($data->timefinish);

        // Insert the entry record.
        $newitemid = $DB->insert_record('facetoface_sessions_dates', $data);
    }

    /**
     * After execute hook
     */
    protected function after_execute() {
        // Face-to-face doesn't have any related files.
        // Add facetoface related files, no need to match by itemname (just internally handled context).
    }
}
