define("tool_dynamic_cohorts/manage_rules",["exports","core/ajax","core/notification","core/templates","core/modal_events","core/str","core_table/dynamic","core/fragment","core/modal_cancel","core_table/local/dynamic/selectors","core/toast","core_form/modalform"],(function(_exports,_ajax,_notification,_templates,_modal_events,_str,DynamicTable,_fragment,_modal_cancel,_selectors,_toast,_modalform){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage rules JS module.
   *
   * @module     tool_dynamic_cohorts/manage_rules
   * @copyright  2024 Catalyst IT
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates),_modal_events=_interopRequireDefault(_modal_events),DynamicTable=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(DynamicTable),_fragment=_interopRequireDefault(_fragment),_modal_cancel=_interopRequireDefault(_modal_cancel),_selectors=_interopRequireDefault(_selectors),_modalform=_interopRequireDefault(_modalform);const SELECTORS_RULE_MATCHING_USERS="tool-dynamic-cohorts-matching-users",SELECTORS_RULE_CONDITIONS=".tool-dynamic-cohorts-condition-view",SELECTORS_RULE_TOGGLE=".tool-dynamic-cohorts-rule-toggle",SELECTORS_RULE_DELETE=".tool-dynamic-cohorts-rule-delete",SELECTORS_RULE_EDIT=".tool-dynamic-cohorts-rule-edit",SELECTORS_RULE_ADD="[data-action=addrule]";_exports.init=()=>{initRuleAdd(),loadMatchingUsers(document),initMatchingUsersModals(document),initRuleConditionsModals(document),initRuleToggle(document),initRuleDelete(document),initRuleEdit(document),document.addEventListener(DynamicTable.Events.tableContentRefreshed,(e=>{const tableRoot=DynamicTable.getTableFromId(e.target.dataset.tableUniqueid);initMatchingUsersModals(tableRoot),loadMatchingUsers(tableRoot),initRuleConditionsModals(tableRoot),initRuleToggle(tableRoot),initRuleDelete(tableRoot),initRuleEdit(tableRoot)}))};const initMatchingUsersModals=root=>{Array.from(root.getElementsByClassName(SELECTORS_RULE_MATCHING_USERS)).forEach((collection=>{const ruleid=collection.dataset.ruleid;collection.children[1].addEventListener("click",(function(e){e.preventDefault(),displayMatchingUsers(ruleid)}))}))},displayMatchingUsers=ruleid=>{_modal_cancel.default.create({title:(0,_str.get_string)("matchingusers","tool_dynamic_cohorts"),body:getMatchingUsersModalBody(ruleid),large:!0}).then((function(modal){modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.show()}))},getMatchingUsersModalBody=ruleid=>{const params={ruleid:ruleid};return _fragment.default.loadFragment("tool_dynamic_cohorts","matching_users",1,params)},loadMatchingUsers=root=>{Array.from(root.getElementsByClassName(SELECTORS_RULE_MATCHING_USERS)).forEach((collection=>{const ruleid=collection.dataset.ruleid,loader=collection.children[0],link=collection.children[1];_ajax.default.call([{methodname:"tool_dynamic_cohorts_get_total_matching_users_for_rule",args:{ruleid:ruleid},done:function(number){link.children[0].append(number.toLocaleString().replace(/,/g," ")),loader.classList.add("hidden"),link.classList.remove("hidden")},fail:function(response){_notification.default.exception(response)}}])}))},initRuleConditionsModals=root=>{root.querySelectorAll(SELECTORS_RULE_CONDITIONS).forEach((link=>{let ruleid=link.dataset.ruleid;link.addEventListener("click",(function(){_ajax.default.call([{methodname:"tool_dynamic_cohorts_get_conditions",args:{ruleid:ruleid},done:function(conditions){_templates.default.render("tool_dynamic_cohorts/conditions",{conditions:conditions,hidecontrols:!0}).then((function(html){_modal_cancel.default.create({title:(0,_str.get_string)("conditionsformtitle","tool_dynamic_cohorts"),body:html,large:!0}).then((function(modal){modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.show()}))})).fail((function(response){_notification.default.exception(response)}))},fail:function(response){_notification.default.exception(response)}}])}))}))},sendFeedback=action=>{(0,_str.get_string)("completed:"+action,"tool_dynamic_cohorts").then((message=>{(0,_toast.add)(message)})).catch(_notification.default.exception)},sendWarning=()=>{(0,_str.get_string)("ruledisabledpleasereview","tool_dynamic_cohorts").then((message=>{(0,_toast.add)(message,{type:"warning",closeButton:!0,delay:1e4})})).catch(_notification.default.exception)},getTableRoot=()=>document.querySelector(_selectors.default.main.region),initRuleToggle=root=>{root.querySelectorAll(SELECTORS_RULE_TOGGLE).forEach((link=>{let ruleid=link.dataset.ruleid,action=link.dataset.action;link.addEventListener("click",(function(e){e.preventDefault(),_notification.default.confirm((0,_str.get_string)("confirm","moodle"),(0,_str.get_string)(action+"_confirm","tool_dynamic_cohorts"),(0,_str.get_string)("yes","moodle"),(0,_str.get_string)("no","moodle"),(function(){_ajax.default.call([{methodname:"tool_dynamic_cohorts_toggle_rule_status",args:{ruleid:ruleid},done:function(){sendFeedback(action),DynamicTable.refreshTableContent(getTableRoot()).catch(_notification.default.exception)},fail:function(response){_notification.default.exception(response)}}])}))}))}))},initRuleDelete=root=>{root.querySelectorAll(SELECTORS_RULE_DELETE).forEach((link=>{let ruleid=link.dataset.ruleid,action=link.dataset.action;link.addEventListener("click",(function(e){e.preventDefault(),_notification.default.confirm((0,_str.get_string)("confirm","moodle"),(0,_str.get_string)(action+"_confirm","tool_dynamic_cohorts",ruleid),(0,_str.get_string)("yes","moodle"),(0,_str.get_string)("no","moodle"),(function(){_ajax.default.call([{methodname:"tool_dynamic_cohorts_delete_rules`",args:{ruleids:{ruleid:ruleid}},done:function(){sendFeedback(action),DynamicTable.refreshTableContent(getTableRoot()).catch(_notification.default.exception)},fail:function(response){_notification.default.exception(response)}}])}))}))}))},initRuleAdd=()=>{document.querySelector(SELECTORS_RULE_ADD).addEventListener("click",(e=>{e.preventDefault();const modalForm=getRuleForm(0,"add");modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>{sendFeedback("add"),sendWarning(),DynamicTable.refreshTableContent(getTableRoot()).catch(_notification.default.exception)})),modalForm.show()}))},initRuleEdit=root=>{root.querySelectorAll(SELECTORS_RULE_EDIT).forEach((link=>{link.addEventListener("click",(function(e){e.preventDefault();let ruleid=link.dataset.ruleid;const modalForm=getRuleForm(ruleid,"edit");modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>{sendFeedback("update"),sendWarning(),DynamicTable.refreshTableContent(getTableRoot()).catch(_notification.default.exception)})),modalForm.show()}))}))},getRuleForm=(ruleid,action)=>new _modalform.default({formClass:"tool_dynamic_cohorts\\rule_form",args:{id:ruleid},modalConfig:{title:(0,_str.get_string)(action+"_rule","tool_dynamic_cohorts")}})}));

//# sourceMappingURL=manage_rules.min.js.map