<?php
// This file is part of the Certify Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace mod_certify\local;

/**
 * Defines local functions for handling interactions with the 'certify' database table.
 *
 * @package    mod_certify
 * @subpackage certify
 * @copyright  Certify <dev@certify.one>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class certify
{

    /**
     * Saves or updates an Certify plugin instance record in the 'certify' table.
     * This function handles both the creation of new records and the updating of existing ones.
     *
     * @param stdClass $post An object containing the incoming data from the form submission.
     * @param stdClass|null $existingrecord Optional. Existing certificate data to be updated.
     * @return bool|int Returns the new record ID on insert, or true on update success.
     */
    public function save_record($post, $existingrecord = null)
    {
        global $DB;

        $dbrecord = (object) [
            'name' => $post->name,
            'credentialuuid' => $post->credentialuuid,
            'attributemapping' => null,
            'timecreated' => time(),
        ];

        if ($existingrecord) {
            $dbrecord->id = $post->instance;

            if ($existingrecord->achievementid) {
                $dbrecord->certificatename = $post->certificatename;
                $dbrecord->description = $post->description;
                $dbrecord->achievementid = $post->achievementid;
                // Keep the existing credentialuuid.
                $dbrecord->credentialuuid = $existingrecord->credentialuuid;
            } else {
                $dbrecord->course = $post->course;
            }

            return $DB->update_record('certify', $dbrecord);
        } else {
            $dbrecord->course = $post->course;
            return $DB->insert_record('certify', $dbrecord);
        }
    }

    /**
     * Loads custom attributes for a credential.
     * Since attribute mapping is no longer collected via the form, this returns an empty array.
     * Kept for compatibility with event handlers and lib.php.
     *
     * @param stdClass $certify An object containing the 'certify' record data.
     * @param int $userid The ID of the user.
     * @return array An empty array (attribute mapping removed).
     */
    public function load_credential_custom_attributes($certify, $userid)
    {
        return [];
    }


}
