<?php
// This file is part of the Certify Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace mod_certify\local;

/**
 * Helper class for mod_form.php.
 *
 * @package    mod_certify
 * @subpackage certify
 * @copyright  Certify <dev@certify.one>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class formhelper
{
    /**
     * Reindex an associative array to have sequential numeric keys starting from 0.
     *
     * This function takes an associative array and returns a new array with
     * the same values but with sequential numeric keys starting from 0.
     *
     * @param array $array The associative array to be reindexed.
     * @return array The reindexed array with sequential numeric keys.
     */
    public function reindexarray($array)
    {
        if (!is_array($array)) {
            return [];
        }

        $reindexed = [];
        foreach ($array as $value) {
            $reindexed[] = $value;
        }
        return $reindexed;
    }
}
