<?php
// This file is part of the Certify Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Certify external functions and service definitions.
 *
 * @package    mod_certify
 * @subpackage certify
 * @copyright  Certify <dev@certify.one>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$services = [
    'certify_service' => [
        'functions' => [
            'mod_certify_reload_users',
        ],
        "restrictedusers" => 0,
        "enabled" => 1,
    ],
];

$functions = [
    'mod_certify_reload_users' => [
        'classname' => 'mod_certify\external\form_helper',
        'methodname' => 'reload_users',
        'classpath' => '',
        'description' => 'Use by form autocomplete for selecting a sharable question.',
        'type' => 'read',
        'ajax' => true,
    ],
];
