<?php
// This file is part of the Certify Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file keeps track of upgrades to the certificate module
 *
 * @package    mod_certify
 * @subpackage certify
 * @copyright  Certify <dev@certify.one>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Function to update the certify db.
 *
 * @param int $oldversion
 */
function xmldb_certify_upgrade($oldversion = 0)
{

    global $CFG, $THEME, $DB;
    $dbman = $DB->get_manager();

    $result = true;

    if ($oldversion < 2025121500) {

        // Changing type of field description on table certify to text.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('description', XMLDB_TYPE_TEXT, null, null, XMLDB_NOTNULL, null, null, 'achievementid');

        // Launch change of type for field description.
        $dbman->change_field_type($table, $field);

        // Define field certificatename to be added to certify.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('certificatename', XMLDB_TYPE_CHAR, '255', null, XMLDB_NOTNULL, null, null, 'timecreated');

        // Conditionally launch add field certificatename.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Set the certificate names to equal the Activity name.
        if ($certifyactivities = $DB->get_records('certify')) {
            foreach ($certifyactivities as $activity) {
                $activity->certificatename = $activity->name;
                $DB->update_record('certify', $activity);
            }
        }

        // Define field credentialuuid to be added to certify.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('credentialuuid', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'certificatename');

        // Conditionally launch add field credentialuuid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Changing nullability of field name on table certify to null.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('name', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'id');

        // Launch change of nullability for field name.
        $dbman->change_field_notnull($table, $field);

        // Changing nullability of field course on table certify to null.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('course', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'name');

        // Launch change of nullability for field course.
        $dbman->change_field_notnull($table, $field);

        // Changing nullability of field achievementid on table certify to null.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('achievementid', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'course');

        // Launch change of nullability for field achievementid.
        $dbman->change_field_notnull($table, $field);

        // Changing nullability of field description on table certify to null.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('description', XMLDB_TYPE_TEXT, null, null, null, null, null, 'achievementid');

        // Launch change of nullability for field description.
        $dbman->change_field_notnull($table, $field);
        
        $table = new xmldb_table('certify');

        // Define field finalgradetopass to be added to certify.
        $field = new xmldb_field('finalgradetopass', XMLDB_TYPE_INTEGER, '3', null, XMLDB_NOTNULL, null, '0', 'credentialuuid');

        // Conditionally launch add field finalgradetopass.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field attributemapping to be added to certify.
        $field = new xmldb_field('attributemapping', XMLDB_TYPE_TEXT, null, null, null, null, null, 'finalgradetopass');

        // Conditionally launch add field attributemapping.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $table = new xmldb_table('certify');
        $field = new xmldb_field('finalgradetopass', XMLDB_TYPE_INTEGER);
        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }
        
        // Rename table certify to certify.
        $table = new xmldb_table('certify');
        if ($dbman->table_exists($table)) {
            $dbman->rename_table($table, 'certify');
        }
        
        // Change credentialuuid from int to char to support UUIDs.
        $table = new xmldb_table('certify');
        $field = new xmldb_field('credentialuuid', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'certificatename');

        if ($dbman->field_exists($table, $field)) {
            $dbman->change_field_type($table, $field);
        }

        upgrade_mod_savepoint(true, 2025121500, 'certify');
    }

    return true;
}
